/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class FormatTools {
    public static void addMethodWithBestPosition(InnerClass innerClass, Method method) {
        FormatTools.addMethodWithBestPosition(method, innerClass.getMethods());
    }

    public static void addMethodWithBestPosition(Interface interfacz, Method method) {
        TreeSet<FullyQualifiedJavaType> importTypes = new TreeSet<FullyQualifiedJavaType>();
        if (method.getReturnType() != null) {
            importTypes.add(method.getReturnType());
            importTypes.addAll(method.getReturnType().getTypeArguments());
        }
        for (Parameter parameter : method.getParameters()) {
            boolean flag = true;
            for (String annotation : parameter.getAnnotations()) {
                if (!annotation.startsWith("@Param")) continue;
                importTypes.add(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Param"));
                if (!annotation.matches(".*selective.*") || !parameter.getType().getShortName().equals("Column")) continue;
                flag = false;
            }
            if (!flag) continue;
            importTypes.add(parameter.getType());
            importTypes.addAll(parameter.getType().getTypeArguments());
        }
        interfacz.addImportedTypes(importTypes);
        FormatTools.addMethodWithBestPosition(method, interfacz.getMethods());
    }

    public static void addMethodWithBestPosition(InnerEnum innerEnum, Method method) {
        FormatTools.addMethodWithBestPosition(method, innerEnum.getMethods());
    }

    public static void addMethodWithBestPosition(TopLevelClass topLevelClass, Method method) {
        FormatTools.addMethodWithBestPosition(method, topLevelClass.getMethods());
    }

    public static void addElementWithBestPosition(XmlElement rootElement, XmlElement element) {
        if (element.getName().equals("sql")) {
            int index = 0;
            for (Element ele : rootElement.getElements()) {
                if (!(ele instanceof XmlElement) || !((XmlElement)ele).getName().equals("sql")) continue;
                ++index;
            }
            rootElement.addElement(index, (Element)element);
        } else {
            String id = FormatTools.getIdFromElement(element);
            if (id == null) {
                rootElement.addElement((Element)element);
            } else {
                List elements = rootElement.getElements();
                int index = -1;
                for (int i = 0; i < elements.size(); ++i) {
                    String eleId;
                    Element ele = (Element)elements.get(i);
                    if (!(ele instanceof XmlElement) || (eleId = FormatTools.getIdFromElement((XmlElement)ele)) == null) continue;
                    if (eleId.startsWith(id)) {
                        if (index != -1) continue;
                        index = i;
                        continue;
                    }
                    if (!id.startsWith(eleId)) continue;
                    index = i + 1;
                }
                if (index == -1 || index >= elements.size()) {
                    rootElement.addElement((Element)element);
                } else {
                    elements.add(index, element);
                }
            }
        }
    }

    private static String getIdFromElement(XmlElement element) {
        for (Attribute attribute : element.getAttributes()) {
            if (!attribute.getName().equals("id")) continue;
            return attribute.getValue();
        }
        return null;
    }

    private static void addMethodWithBestPosition(Method method, List<Method> methods) {
        int index = -1;
        for (int i = 0; i < methods.size(); ++i) {
            Method m = methods.get(i);
            if (m.getName().equals(method.getName())) {
                if (m.getParameters().size() <= method.getParameters().size()) {
                    index = i + 1;
                    continue;
                }
                index = i;
                continue;
            }
            if (m.getName().startsWith(method.getName())) {
                if (index != -1) continue;
                index = i;
                continue;
            }
            if (!method.getName().startsWith(m.getName())) continue;
            index = i + 1;
        }
        if (index == -1 || index >= methods.size()) {
            methods.add(methods.size(), method);
        } else {
            methods.add(index, method);
        }
    }

    public static void replaceGeneralMethodComment(CommentGenerator commentGenerator, Method method, IntrospectedTable introspectedTable) {
        method.getJavaDocLines().clear();
        commentGenerator.addGeneralMethodComment(method, introspectedTable);
    }

    public static void replaceComment(CommentGenerator commentGenerator, XmlElement element) {
        Iterator elementIterator = element.getElements().iterator();
        boolean flag = false;
        while (elementIterator.hasNext()) {
            Element ele = (Element)elementIterator.next();
            if (ele instanceof TextElement && ((TextElement)ele).getContent().matches(".*<!--.*")) {
                flag = true;
            }
            if (flag) {
                elementIterator.remove();
            }
            if (!(ele instanceof TextElement) || !((TextElement)ele).getContent().matches(".*-->.*")) continue;
            flag = false;
        }
        XmlElement tmpEle = new XmlElement("tmp");
        commentGenerator.addComment(tmpEle);
        for (int i = tmpEle.getElements().size() - 1; i >= 0; --i) {
            element.addElement(0, (Element)tmpEle.getElements().get(i));
        }
    }

    public static String upFirstChar(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

