/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.ext;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class SwaggerPlugin
extends BasePlugin {
    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateSwagger(topLevelClass, introspectedTable);
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    private void generateSwagger(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addImportedType("io.swagger.annotations.ApiModelProperty");
        List fields = topLevelClass.getFields();
        for (Field field : fields) {
            IntrospectedColumn column = this.getColumn(field, introspectedTable);
            String remarks = column.getRemarks();
            if (null == remarks || "".equals(remarks)) continue;
            remarks = remarks.replace(System.getProperty("line.separator"), "");
            field.addAnnotation(String.format("@ApiModelProperty(value = \"%s\")", remarks));
        }
    }

    private IntrospectedColumn getColumn(Field field, IntrospectedTable introspectedTable) {
        List allColumns = introspectedTable.getAllColumns();
        for (IntrospectedColumn column : allColumns) {
            if (!field.getName().equals(column.getJavaProperty())) continue;
            return column;
        }
        return null;
    }
}

