/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.ext;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.internal.types.JavaTypeResolverDefaultImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTypeResolverSolver
extends JavaTypeResolverDefaultImpl {
    protected static final Logger logger = LoggerFactory.getLogger(MyTypeResolverSolver.class);
    public static final String KEY_TINYINT = "TINYINT";
    public static final String KEY_SMALLINT = "SMALLINT";

    protected FullyQualifiedJavaType overrideDefaultType(IntrospectedColumn column, FullyQualifiedJavaType defaultType) {
        FullyQualifiedJavaType answer = super.overrideDefaultType(column, defaultType);
        if (column.getJdbcType() == -6 && this.properties.containsKey(KEY_TINYINT)) {
            answer = new FullyQualifiedJavaType(this.properties.getProperty(KEY_TINYINT));
        }
        if (column.getJdbcType() == 5) {
            answer = new FullyQualifiedJavaType(this.properties.getProperty(KEY_SMALLINT));
        }
        return answer;
    }

    protected FullyQualifiedJavaType calculateBigDecimalReplacement(IntrospectedColumn column, FullyQualifiedJavaType defaultType) {
        FullyQualifiedJavaType answer = column.getScale() > 0 || column.getLength() > 18 || this.forceBigDecimals ? defaultType : (column.getLength() > 0 && column.getLength() <= 9 ? new FullyQualifiedJavaType(Integer.class.getName()) : new FullyQualifiedJavaType(Long.class.getName()));
        return answer;
    }
}

