/*
 * Decompiled with CFR 0.152.
 */
package com.github.swagger.enumeratum.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.github.swagger.scala.converter.AnnotatedTypeForOption;
import com.github.swagger.scala.converter.SwaggerScalaModelConverter$;
import enumeratum.Enum;
import enumeratum.EnumEntry;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class SwaggerEnumeratumModelConverter
extends ModelResolver {
    private final Class<EnumEntry> enumEntryClass = EnumEntry.class;

    public SwaggerEnumeratumModelConverter() {
        super(Json.mapper());
    }

    private Option<String> noneIfEmpty(String s) {
        return Option$.MODULE$.apply((Object)s).filter((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1.trim())));
    }

    public io.swagger.v3.oas.models.media.Schema<?> resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = this._mapper.constructType(annotatedType.getType());
        Class cls = javaType.getRawClass();
        if (this.isEnum(cls)) {
            io.swagger.v3.oas.models.media.Schema sp = PrimitiveType.STRING.createProperty();
            this.setRequired(annotatedType);
            this.getValues(cls).foreach((Function1)(JProcedure1 & Serializable)v -> sp.addEnumItemObject(v));
            this.nullSafeList(annotatedType.getCtxAnnotations()).foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
                Annotation annotation = x$12;
                if (annotation instanceof Parameter) {
                    Parameter p = (Parameter)annotation;
                    this.noneIfEmpty(p.description()).foreach((Function1)(JProcedure1 & Serializable)desc -> sp.setDescription(desc));
                    if (p.deprecated()) {
                        sp.setDeprecated(Predef$.MODULE$.boolean2Boolean(true));
                    }
                    this.noneIfEmpty(p.example()).foreach((Function1)(JProcedure1 & Serializable)ex -> sp.setExample(ex));
                    this.noneIfEmpty(p.name()).foreach((Function1)(JProcedure1 & Serializable)name -> sp.setName(name));
                    return;
                }
                if (annotation instanceof Schema) {
                    Schema s = (Schema)annotation;
                    this.noneIfEmpty(s.description()).foreach((Function1)(JProcedure1 & Serializable)desc -> sp.setDescription(desc));
                    this.noneIfEmpty(s.defaultValue()).foreach((Function1)(JProcedure1 & Serializable)df -> sp.setDefault(df));
                    if (s.deprecated()) {
                        sp.setDeprecated(Predef$.MODULE$.boolean2Boolean(true));
                    }
                    this.noneIfEmpty(s.example()).foreach((Function1)(JProcedure1 & Serializable)ex -> sp.setExample(ex));
                    this.noneIfEmpty(s.name()).foreach((Function1)(JProcedure1 & Serializable)name -> sp.setName(name));
                    Option$.MODULE$.apply((Object)s.accessMode()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Schema.AccessMode accessMode = x$1;
                        Schema.AccessMode accessMode2 = Schema.AccessMode.READ_ONLY;
                        Schema.AccessMode accessMode3 = accessMode;
                        if (!(accessMode2 != null ? !accessMode2.equals(accessMode3) : accessMode3 != null)) {
                            sp.setReadOnly(Predef$.MODULE$.boolean2Boolean(true));
                            return;
                        }
                        Schema.AccessMode accessMode4 = Schema.AccessMode.WRITE_ONLY;
                        Schema.AccessMode accessMode5 = accessMode;
                        if (!(accessMode4 != null ? !accessMode4.equals(accessMode5) : accessMode5 != null)) {
                            sp.setWriteOnly(Predef$.MODULE$.boolean2Boolean(true));
                            return;
                        }
                    });
                    return;
                }
            });
            return sp;
        }
        if (chain.hasNext()) {
            Option nextResolved = Option$.MODULE$.apply((Object)chain.next().resolve(annotatedType, context, chain));
            Option option = nextResolved;
            if (option instanceof Some) {
                io.swagger.v3.oas.models.media.Schema property = (io.swagger.v3.oas.models.media.Schema)((Some)option).value();
                this.setRequired(annotatedType);
                return property;
            }
            if (None$.MODULE$.equals(option)) {
                return (io.swagger.v3.oas.models.media.Schema)None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            throw new MatchError((Object)option);
        }
        return (io.swagger.v3.oas.models.media.Schema)None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean isEnum(Class<?> cls) {
        return this.enumEntryClass.isAssignableFrom(cls);
    }

    private Seq<String> getValues(Class<?> cls) {
        Enum enumEntry = (Enum)Class.forName(new StringBuilder(1).append(cls.getName()).append("$").toString()).getField("MODULE$").get(null);
        return (Seq)enumEntry.values().map((Function1 & Serializable)_$2 -> _$2.entryName());
    }

    private void setRequired(AnnotatedType annotatedType) {
        AnnotatedType annotatedType2 = annotatedType;
        if (annotatedType2 instanceof AnnotatedTypeForOption) {
            return;
        }
        boolean required = BoxesRunTime.unboxToBoolean((Object)SwaggerScalaModelConverter$.MODULE$.getRequiredSettings(annotatedType).headOption().getOrElse(SwaggerEnumeratumModelConverter::$anonfun$1));
        if (required) {
            Option$.MODULE$.apply((Object)annotatedType.getParent()).foreach((Function1)(JProcedure1 & Serializable)parent -> Option$.MODULE$.apply((Object)annotatedType.getPropertyName()).foreach((Function1)(JProcedure1 & Serializable)n -> this.addRequiredItem((io.swagger.v3.oas.models.media.Schema)parent, (String)n)));
            return;
        }
    }

    private <T> List<T> nullSafeList(Object array) {
        Option option = Option$.MODULE$.apply(array);
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        if (option instanceof Some) {
            Object arr = ((Some)option).value();
            return Predef$.MODULE$.genericWrapArray(arr).toList();
        }
        throw new MatchError((Object)option);
    }

    private static final boolean $anonfun$1() {
        return true;
    }
}

