/*
 * Decompiled with CFR 0.152.
 */
package com.github.svinci.ws.handler;

import com.github.svinci.ws.handler.MessageHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;

public class WebSocketHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClientHandshaker handshaker;
    private final MessageHandler handler;
    private ChannelPromise handshakeFuture;

    public WebSocketHandler(WebSocketClientHandshaker handshaker, MessageHandler handler) {
        this.handshaker = handshaker;
        this.handler = handler;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.handshaker.handshake(ctx.channel());
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        WebSocketFrame frame;
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
            this.handshakeFuture.setSuccess();
            this.handler.onOpen();
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            Exception error = new Exception("Unexpected FullHttpResponse (getStatus=" + response.getStatus() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            this.handler.onError(error);
        }
        if ((frame = (WebSocketFrame)msg) instanceof TextWebSocketFrame) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            this.handler.onMessage(textFrame.text());
        } else if (frame instanceof CloseWebSocketFrame) {
            this.handler.onClose();
            ch.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        this.handler.onError(cause);
        ctx.close();
    }
}

