/*
 * Decompiled with CFR 0.152.
 */
package com.github.svinci.ws.factory;

import com.github.svinci.ws.handler.WebSocketHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class ChannelInitializerFactory {
    public ChannelInitializer<SocketChannel> create(String protocol, final WebSocketHandler handler, final SSLContext context) {
        if (handler == null) {
            throw new IllegalArgumentException("handler is mandatory");
        }
        if ("wss".equals(protocol)) {
            return new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    if (context == null) {
                        throw new IllegalArgumentException("for secured web sockets, ssl context is mandatory");
                    }
                    SSLEngine engine = context.createSSLEngine();
                    engine.setUseClientMode(true);
                    ch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(engine)).addLast("http-codec", (ChannelHandler)new HttpClientCodec()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(8192)).addLast("ws-handler", (ChannelHandler)handler);
                }
            };
        }
        return this.create(protocol, handler);
    }

    public ChannelInitializer<SocketChannel> create(String protocol, final WebSocketHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler is mandatory");
        }
        if ("ws".equals(protocol)) {
            return new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast("http-codec", (ChannelHandler)new HttpClientCodec()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(8192)).addLast("ws-handler", (ChannelHandler)handler);
                }
            };
        }
        throw new IllegalArgumentException("Unsupported protocol: " + protocol);
    }
}

