/*
 * Decompiled with CFR 0.152.
 */
package com.github.svinci.ws;

import com.github.svinci.ws.Configuration;
import com.github.svinci.ws.factory.ChannelInitializerFactory;
import com.github.svinci.ws.factory.HandlerFactory;
import com.github.svinci.ws.handler.WebSocketHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.io.Closeable;

public class WebSocket
implements Runnable,
Closeable {
    private final Configuration configuration;
    private final EventLoopGroup group;
    private Channel channel;
    private boolean running = false;

    public WebSocket(Configuration configuration) {
        this.configuration = configuration;
        this.group = new NioEventLoopGroup();
    }

    public boolean isOpen() {
        return this.running;
    }

    public void ping() {
        if (!this.isOpen()) {
            throw new IllegalArgumentException("web socket is not open");
        }
        PingWebSocketFrame frame = new PingWebSocketFrame(Unpooled.copiedBuffer((byte[])new byte[]{8, 1, 8, 1}));
        this.channel.writeAndFlush((Object)frame);
    }

    public void sendMessage(String message) {
        if (!this.isOpen()) {
            throw new IllegalArgumentException("web socket is not open");
        }
        TextWebSocketFrame frame = new TextWebSocketFrame(message);
        this.channel.writeAndFlush((Object)frame);
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            throw new IllegalArgumentException("web socket is not open");
        }
        this.group.shutdownGracefully();
        this.configuration.getHandler().onClose();
        this.running = false;
    }

    @Override
    public void run() {
        if (!this.isOpen()) {
            this.running = true;
            try {
                WebSocketHandler handler = new HandlerFactory().create(this.configuration);
                ChannelInitializer<SocketChannel> initializer = new ChannelInitializerFactory().create(this.configuration.getUri().getScheme(), handler, this.configuration.getSslContext());
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler(initializer);
                int port = this.resolvePort(this.configuration);
                this.channel = b.connect(this.configuration.getUri().getHost(), port).sync().channel();
                handler.handshakeFuture().sync();
            }
            catch (Exception e) {
                this.configuration.getHandler().onError(e);
                this.running = false;
            }
        } else {
            throw new IllegalArgumentException("web socket is already open");
        }
    }

    private int resolvePort(Configuration configuration) {
        int port = configuration.getUri().getPort();
        if (port == -1) {
            port = "wss".equals(configuration.getUri().getScheme()) ? 443 : 80;
        }
        return port;
    }
}

