/*
 * Decompiled with CFR 0.152.
 */
package com.github.svinci.ws;

import com.github.svinci.ws.handler.MessageHandler;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;

public class Configuration {
    private final MessageHandler handler;
    private final URI uri;
    private final SSLContext sslContext;

    public Configuration(MessageHandler handler, String uri) throws URISyntaxException {
        this(handler, new URI(uri));
    }

    public Configuration(MessageHandler handler, URI uri) {
        this(handler, uri, null);
    }

    public Configuration(MessageHandler handler, String uri, SSLContext context) throws URISyntaxException {
        this(handler, new URI(uri), context);
    }

    public Configuration(MessageHandler handler, URI uri, SSLContext context) {
        if (handler == null) {
            throw new IllegalArgumentException("handler is mandatory");
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri is mandatory");
        }
        if ("wss".equals(uri.getScheme()) && context == null) {
            throw new IllegalArgumentException("wss protocol requires ssl context");
        }
        this.handler = handler;
        this.uri = uri;
        this.sslContext = context;
    }

    public MessageHandler getHandler() {
        return this.handler;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public URI getUri() {
        return this.uri;
    }
}

