/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.web.mvc.multipart;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import jetbrick.io.IoUtils;
import jetbrick.web.mvc.Managed;
import jetbrick.web.mvc.multipart.FilePart;
import jetbrick.web.mvc.multipart.FileUpload;
import jetbrick.web.mvc.multipart.MultipartRequest;
import jetbrick.web.mvc.multipart.UploadUtils;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;

@Managed
public final class CommonsFileUpload
implements FileUpload {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultipartRequest transform(HttpServletRequest request) throws IOException {
        String contextType = request.getHeader("Content-Type");
        if (contextType == null || !contextType.startsWith("multipart/form-data")) {
            return null;
        }
        String encoding = request.getCharacterEncoding();
        MultipartRequest req = new MultipartRequest(request);
        ServletFileUpload upload = new ServletFileUpload();
        upload.setHeaderEncoding(encoding);
        try {
            FileItemIterator it = upload.getItemIterator(request);
            while (it.hasNext()) {
                FileItemStream item = it.next();
                String fieldName = item.getFieldName();
                InputStream stream = item.openStream();
                try {
                    if (item.isFormField()) {
                        req.setParameter(fieldName, Streams.asString((InputStream)stream, (String)encoding));
                        continue;
                    }
                    String originalFilename = item.getName();
                    if (originalFilename == null || originalFilename.length() == 0) continue;
                    File diskFile = UploadUtils.getUniqueTemporaryFile((String)originalFilename);
                    FileOutputStream fos = new FileOutputStream(diskFile);
                    try {
                        IoUtils.copy((InputStream)stream, (OutputStream)fos);
                    }
                    finally {
                        IoUtils.closeQuietly((Closeable)fos);
                    }
                    FilePart filePart = new FilePart(fieldName, originalFilename, diskFile);
                    req.addFile(filePart);
                }
                finally {
                    IoUtils.closeQuietly((Closeable)stream);
                }
            }
        }
        catch (FileUploadException e) {
            throw new IllegalStateException(e);
        }
        return req;
    }
}

