/*
 * Decompiled with CFR 0.152.
 */
package com.github.squirrelgrip.scientist4k.controlled.http.server;

import com.github.squirrelgrip.scientist4k.controlled.http.server.ControlledHttpExperiment;
import com.github.squirrelgrip.scientist4k.core.AbstractExperiment;
import com.github.squirrelgrip.scientist4k.core.exception.LaboratoryException;
import com.github.squirrelgrip.scientist4k.core.model.ExperimentComparator;
import com.github.squirrelgrip.scientist4k.core.model.sample.SampleFactory;
import com.github.squirrelgrip.scientist4k.http.core.comparator.DefaultExperimentResponseComparator;
import com.github.squirrelgrip.scientist4k.http.core.configuration.ControlledHttpExperimentConfiguration;
import com.github.squirrelgrip.scientist4k.http.core.configuration.EndPointConfiguration;
import com.github.squirrelgrip.scientist4k.http.core.configuration.MappingConfiguration;
import com.github.squirrelgrip.scientist4k.http.core.model.ExperimentResponse;
import com.github.squirrelgrip.scientist4k.metrics.MetricsProvider;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\tJ\u0016\u0010!\u001a\u00020\u00002\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\tJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u001f\u0010&\u001a\u00020\u00002\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130(\"\u00020\u0013\u00a2\u0006\u0002\u0010)J\u0012\u0010*\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u0015J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0017J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\tJ\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/github/squirrelgrip/scientist4k/controlled/http/server/ControlledHttpExperimentBuilder;", "", "controlledHttpExperimentConfiguration", "Lcom/github/squirrelgrip/scientist4k/http/core/configuration/ControlledHttpExperimentConfiguration;", "(Lcom/github/squirrelgrip/scientist4k/http/core/configuration/ControlledHttpExperimentConfiguration;)V", "()V", "async", "", "candidateConfig", "Lcom/github/squirrelgrip/scientist4k/http/core/configuration/EndPointConfiguration;", "comparator", "Lcom/github/squirrelgrip/scientist4k/core/model/ExperimentComparator;", "Lcom/github/squirrelgrip/scientist4k/http/core/model/ExperimentResponse;", "controlConfig", "enabled", "eventBus", "Lcom/google/common/eventbus/EventBus;", "mappings", "", "Lcom/github/squirrelgrip/scientist4k/http/core/configuration/MappingConfiguration;", "metrics", "Lcom/github/squirrelgrip/scientist4k/metrics/MetricsProvider;", "name", "", "raiseOnMismatch", "referenceConfig", "sampleFactory", "Lcom/github/squirrelgrip/scientist4k/core/model/sample/SampleFactory;", "build", "Lcom/github/squirrelgrip/scientist4k/controlled/http/server/ControlledHttpExperiment;", "withAsync", "withCandidateConfig", "candidateConfiguration", "withComparator", "withControlConfig", "controlConfiguration", "withEnabled", "withEventBus", "withMappings", "mapping", "", "([Lcom/github/squirrelgrip/scientist4k/http/core/configuration/MappingConfiguration;)Lcom/github/squirrelgrip/scientist4k/controlled/http/server/ControlledHttpExperimentBuilder;", "withMetricsProvider", "metricsProvider", "withName", "withRaiseOnMismatch", "withReferenceConfig", "referenceConfiguration", "withSampleFactory", "scientist4k-controlled-http-server"})
public final class ControlledHttpExperimentBuilder {
    private List<MappingConfiguration> mappings;
    private String name;
    private MetricsProvider<?> metrics;
    private boolean raiseOnMismatch;
    private SampleFactory sampleFactory;
    private ExperimentComparator<ExperimentResponse> comparator;
    private EventBus eventBus;
    private boolean enabled;
    private boolean async;
    private EndPointConfiguration controlConfig;
    private EndPointConfiguration candidateConfig;
    private EndPointConfiguration referenceConfig;

    @NotNull
    public final ControlledHttpExperimentBuilder withName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withMetricsProvider(@NotNull String metricsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)metricsProvider, (String)"metricsProvider");
        this.metrics = MetricsProvider.Companion.build(metricsProvider);
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withMetricsProvider(@NotNull MetricsProvider<?> metricsProvider) {
        Intrinsics.checkParameterIsNotNull(metricsProvider, (String)"metricsProvider");
        this.metrics = metricsProvider;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withComparator(@NotNull ExperimentComparator<ExperimentResponse> comparator) {
        Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
        this.comparator = comparator;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withRaiseOnMismatch(boolean raiseOnMismatch) {
        this.raiseOnMismatch = raiseOnMismatch;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withSampleFactory(@NotNull SampleFactory sampleFactory) {
        Intrinsics.checkParameterIsNotNull((Object)sampleFactory, (String)"sampleFactory");
        this.sampleFactory = sampleFactory;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withControlConfig(@NotNull EndPointConfiguration controlConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)controlConfiguration, (String)"controlConfiguration");
        this.controlConfig = controlConfiguration;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withCandidateConfig(@NotNull EndPointConfiguration candidateConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)candidateConfiguration, (String)"candidateConfiguration");
        this.candidateConfig = candidateConfiguration;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withReferenceConfig(@NotNull EndPointConfiguration referenceConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)referenceConfiguration, (String)"referenceConfiguration");
        this.referenceConfig = referenceConfiguration;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withEventBus(@NotNull EventBus eventBus) {
        Intrinsics.checkParameterIsNotNull((Object)eventBus, (String)"eventBus");
        this.eventBus = eventBus;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withAsync(boolean async) {
        this.async = async;
        return this;
    }

    @NotNull
    public final ControlledHttpExperimentBuilder withMappings(MappingConfiguration ... mapping) {
        Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
        this.mappings = ArraysKt.toList((Object[])mapping);
        return this;
    }

    @NotNull
    public final ControlledHttpExperiment build() {
        if (this.controlConfig != null && this.referenceConfig != null && this.candidateConfig != null) {
            EndPointConfiguration endPointConfiguration = this.controlConfig;
            if (endPointConfiguration == null) {
                Intrinsics.throwNpe();
            }
            EndPointConfiguration endPointConfiguration2 = this.referenceConfig;
            if (endPointConfiguration2 == null) {
                Intrinsics.throwNpe();
            }
            EndPointConfiguration endPointConfiguration3 = this.candidateConfig;
            if (endPointConfiguration3 == null) {
                Intrinsics.throwNpe();
            }
            return new ControlledHttpExperiment(this.name, this.raiseOnMismatch, this.metrics, this.comparator, this.sampleFactory, this.eventBus, this.enabled, this.async, this.mappings, endPointConfiguration, endPointConfiguration2, endPointConfiguration3);
        }
        throw (Throwable)new LaboratoryException("primaryControl, secondaryControl and candidate configurations must be set");
    }

    public ControlledHttpExperimentBuilder() {
        this.mappings = CollectionsKt.emptyList();
        this.name = "Test";
        this.metrics = MetricsProvider.Companion.build("DROPWIZARD");
        this.sampleFactory = new SampleFactory(null, null, 3, null);
        this.comparator = (ExperimentComparator)new DefaultExperimentResponseComparator();
        this.eventBus = AbstractExperiment.Companion.getDEFAULT_EVENT_BUS();
        this.enabled = true;
        this.async = true;
    }

    /*
     * WARNING - void declaration
     */
    public ControlledHttpExperimentBuilder(@NotNull ControlledHttpExperimentConfiguration controlledHttpExperimentConfiguration) {
        Collection<MappingConfiguration> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)controlledHttpExperimentConfiguration, (String)"controlledHttpExperimentConfiguration");
        this();
        this.name = controlledHttpExperimentConfiguration.getExperiment().getName();
        this.metrics = controlledHttpExperimentConfiguration.getExperiment().getMetrics();
        this.raiseOnMismatch = controlledHttpExperimentConfiguration.getExperiment().getRaiseOnMismatch();
        this.sampleFactory = controlledHttpExperimentConfiguration.getExperiment().getSampleFactory();
        this.controlConfig = controlledHttpExperimentConfiguration.getControl();
        this.candidateConfig = controlledHttpExperimentConfiguration.getCandidate();
        this.referenceConfig = controlledHttpExperimentConfiguration.getReference();
        Map map = controlledHttpExperimentConfiguration.getMappings();
        ControlledHttpExperimentBuilder controlledHttpExperimentBuilder = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void control;
            void $dstr$control$candidate;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            void var13_14 = $dstr$control$candidate;
            boolean bl3 = false;
            String string = (String)var13_14.getKey();
            var13_14 = $dstr$control$candidate;
            bl3 = false;
            String candidate = (String)var13_14.getValue();
            MappingConfiguration mappingConfiguration = new MappingConfiguration((String)control, candidate);
            collection.add(mappingConfiguration);
        }
        collection = (List)destination$iv$iv;
        controlledHttpExperimentBuilder.mappings = collection;
    }
}

