/*
 * Decompiled with CFR 0.152.
 */
package com.github.squirrelgrip.scientist4k.controlled.http;

import com.github.squirrelgrip.scientist4k.controlled.ControlledExperiment;
import com.github.squirrelgrip.scientist4k.core.model.ExperimentComparator;
import com.github.squirrelgrip.scientist4k.core.model.sample.Sample;
import com.github.squirrelgrip.scientist4k.core.model.sample.SampleFactory;
import com.github.squirrelgrip.scientist4k.http.core.HttpExperimentUtil;
import com.github.squirrelgrip.scientist4k.http.core.comparator.ExperimentResponseComparator;
import com.github.squirrelgrip.scientist4k.http.core.configuration.EndPointConfiguration;
import com.github.squirrelgrip.scientist4k.http.core.configuration.MappingConfiguration;
import com.github.squirrelgrip.scientist4k.http.core.factory.RequestFactory;
import com.github.squirrelgrip.scientist4k.http.core.model.ExperimentRequest;
import com.github.squirrelgrip.scientist4k.http.core.model.ExperimentResponse;
import com.github.squirrelgrip.scientist4k.metrics.MetricsProvider;
import com.google.common.eventbus.EventBus;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)Bq\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\b\u0002\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/github/squirrelgrip/scientist4k/controlled/http/ControlledHttpExperiment;", "Lcom/github/squirrelgrip/scientist4k/controlled/ControlledExperiment;", "Lcom/github/squirrelgrip/scientist4k/http/core/model/ExperimentResponse;", "name", "", "raiseOnMismatch", "", "metrics", "Lcom/github/squirrelgrip/scientist4k/metrics/MetricsProvider;", "comparator", "Lcom/github/squirrelgrip/scientist4k/core/model/ExperimentComparator;", "sampleFactory", "Lcom/github/squirrelgrip/scientist4k/core/model/sample/SampleFactory;", "eventBus", "Lcom/google/common/eventbus/EventBus;", "mappings", "", "Lcom/github/squirrelgrip/scientist4k/http/core/configuration/MappingConfiguration;", "controlConfig", "Lcom/github/squirrelgrip/scientist4k/http/core/configuration/EndPointConfiguration;", "referenceConfig", "candidateConfig", "(Ljava/lang/String;ZLcom/github/squirrelgrip/scientist4k/metrics/MetricsProvider;Lcom/github/squirrelgrip/scientist4k/core/model/ExperimentComparator;Lcom/github/squirrelgrip/scientist4k/core/model/sample/SampleFactory;Lcom/google/common/eventbus/EventBus;Ljava/util/List;Lcom/github/squirrelgrip/scientist4k/http/core/configuration/EndPointConfiguration;Lcom/github/squirrelgrip/scientist4k/http/core/configuration/EndPointConfiguration;Lcom/github/squirrelgrip/scientist4k/http/core/configuration/EndPointConfiguration;)V", "candidateRequestFactory", "Lcom/github/squirrelgrip/scientist4k/http/core/factory/RequestFactory;", "controlRequestFactory", "referenceRequestFactory", "createCandidateRequest", "Lkotlin/Function0;", "request", "Lcom/github/squirrelgrip/scientist4k/http/core/model/ExperimentRequest;", "createControlRequest", "createReferenceRequest", "run", "", "inboundRequest", "Ljavax/servlet/http/HttpServletRequest;", "inboundResponse", "Ljavax/servlet/http/HttpServletResponse;", "sample", "Lcom/github/squirrelgrip/scientist4k/core/model/sample/Sample;", "Companion", "scientist4k-controlled-http-server"})
public final class ControlledHttpExperiment
extends ControlledExperiment<ExperimentResponse> {
    private final RequestFactory controlRequestFactory;
    private final RequestFactory referenceRequestFactory;
    private final RequestFactory candidateRequestFactory;
    private final EndPointConfiguration candidateConfig;
    private static final Logger LOGGER;
    public static final Companion Companion;

    public final void run(@NotNull HttpServletRequest inboundRequest, @NotNull HttpServletResponse inboundResponse, @NotNull Sample sample) {
        Intrinsics.checkParameterIsNotNull((Object)inboundRequest, (String)"inboundRequest");
        Intrinsics.checkParameterIsNotNull((Object)inboundResponse, (String)"inboundResponse");
        Intrinsics.checkParameterIsNotNull((Object)sample, (String)"sample");
        ExperimentRequest experimentRequest = HttpExperimentUtil.INSTANCE.createRequest(inboundRequest, sample);
        ExperimentResponse controlResponse = this.candidateConfig.getAllowedMethods().contains("*") | this.candidateConfig.getAllowedMethods().contains(inboundRequest.getMethod()) ? (ExperimentResponse)this.run(this.createControlRequest(experimentRequest), this.createReferenceRequest(experimentRequest), this.createCandidateRequest(experimentRequest), sample) : (ExperimentResponse)this.createControlRequest(experimentRequest).invoke();
        HttpExperimentUtil.INSTANCE.processResponse(inboundResponse, controlResponse);
    }

    public static /* synthetic */ void run$default(ControlledHttpExperiment controlledHttpExperiment, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Sample sample, int n, Object object) {
        if ((n & 4) != 0) {
            sample = controlledHttpExperiment.getSampleFactory().create();
        }
        controlledHttpExperiment.run(httpServletRequest, httpServletResponse, sample);
    }

    private final Function0<ExperimentResponse> createControlRequest(ExperimentRequest request) {
        return this.controlRequestFactory.create(request);
    }

    private final Function0<ExperimentResponse> createReferenceRequest(ExperimentRequest request) {
        return this.referenceRequestFactory.create(request);
    }

    private final Function0<ExperimentResponse> createCandidateRequest(ExperimentRequest request) {
        return this.candidateRequestFactory.create(request);
    }

    public ControlledHttpExperiment(@NotNull String name, boolean raiseOnMismatch, @NotNull MetricsProvider<?> metrics, @NotNull ExperimentComparator<ExperimentResponse> comparator, @NotNull SampleFactory sampleFactory, @NotNull EventBus eventBus, @NotNull List<MappingConfiguration> mappings, @NotNull EndPointConfiguration controlConfig, @NotNull EndPointConfiguration referenceConfig, @NotNull EndPointConfiguration candidateConfig) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(metrics, (String)"metrics");
        Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
        Intrinsics.checkParameterIsNotNull((Object)sampleFactory, (String)"sampleFactory");
        Intrinsics.checkParameterIsNotNull((Object)eventBus, (String)"eventBus");
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        Intrinsics.checkParameterIsNotNull((Object)controlConfig, (String)"controlConfig");
        Intrinsics.checkParameterIsNotNull((Object)referenceConfig, (String)"referenceConfig");
        Intrinsics.checkParameterIsNotNull((Object)candidateConfig, (String)"candidateConfig");
        super(name, raiseOnMismatch, metrics, comparator, sampleFactory, eventBus);
        this.candidateConfig = candidateConfig;
        this.controlRequestFactory = new RequestFactory(controlConfig, HttpExperimentUtil.INSTANCE.getCONTROL_COOKIE_STORE(), null, 4, null);
        this.referenceRequestFactory = new RequestFactory(referenceConfig, HttpExperimentUtil.INSTANCE.getREFERENCE_COOKIE_STORE(), null, 4, null);
        this.candidateRequestFactory = new RequestFactory(this.candidateConfig, HttpExperimentUtil.INSTANCE.getCANDIDATE_COOKIE_STORE(), mappings);
    }

    public /* synthetic */ ControlledHttpExperiment(String string, boolean bl, MetricsProvider metricsProvider, ExperimentComparator experimentComparator, SampleFactory sampleFactory, EventBus eventBus, List list, EndPointConfiguration endPointConfiguration, EndPointConfiguration endPointConfiguration2, EndPointConfiguration endPointConfiguration3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            metricsProvider = MetricsProvider.Companion.build("DROPWIZARD");
        }
        if ((n & 8) != 0) {
            experimentComparator = (ExperimentComparator)new ExperimentResponseComparator();
        }
        if ((n & 0x10) != 0) {
            sampleFactory = new SampleFactory(null, null, 3, null);
        }
        if ((n & 0x20) != 0) {
            eventBus = new EventBus();
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, bl, metricsProvider, (ExperimentComparator<ExperimentResponse>)experimentComparator, sampleFactory, eventBus, list, endPointConfiguration, endPointConfiguration2, endPointConfiguration3);
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(ControlledHttpExperiment.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\u2026tpExperiment::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/squirrelgrip/scientist4k/controlled/http/ControlledHttpExperiment$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "scientist4k-controlled-http-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

