/*
 * Copyright 2016-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.mariadb.embedded.exception;

import com.mariadb.embedded.MariadbServer;

/**
 * {@link Exception} for {@link MariadbServer}
 */
@SuppressWarnings("serial")
public class MariadbServerException extends IllegalStateException {
	
	/**
	 * Constructor
	 * 
	 * @param message message
	 */
	public MariadbServerException(String message) {
		
		super(message);
	}
	
	/**
	 * Constructor
	 * 
	 * @param message message
	 * @param cause {@link Throwable}
	 */
	public MariadbServerException(String message, Throwable cause) {
		
		super(message, cause);
	}
}
