import spinal.core._
import spinal.core.sim._
import spinal.lib._
import spinal.lib.misc.pipeline._

import spinal.core._
import spinal.lib._
import spinal.lib.misc.pipeline._

import scala.collection.mutable.ArrayBuffer

case class Pipes() extends Area {
  val decode = CtrlLink()

  val IR = Payload(Bits(32 bits))
  val OPCODE = Payload(Bits(7 bits))
  val RD = Payload(UInt(5 bits))

  Builder(decode)
}

case class DecodeOps(pipes: Pipes) {
  import pipes._

  val decoder = new decode.Area {
    OPCODE := IR(6 downto 0)
    RD := U(IR(11 downto 7))
  }
}

case class Bug() extends Component {
  val pipes = Pipes()
  val decodeOps = DecodeOps(pipes)
}

object BugTop extends App {
  SpinalConfig().generateVhdl(Bug()).printPruned()
}
