/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.eda.xilinx;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.BigDecimal$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import spinal.core.HertzNumber;
import spinal.core.TimeNumber;
import spinal.core.package;
import spinal.core.package$;
import spinal.lib.DoCmd$;
import spinal.lib.eda.bench.Report;
import spinal.lib.eda.bench.Rtl;

public final class VivadoFlow$ {
    public static VivadoFlow$ MODULE$;

    static {
        new VivadoFlow$();
    }

    public Report apply(String vivadoPath, String workspacePath, Rtl rtl, String family, String device, HertzNumber frequencyTarget, int processorCount) {
        TimeNumber targetPeriod = (frequencyTarget != null ? frequencyTarget : package.IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(400))).toTime();
        File workspacePathFile = new File(workspacePath);
        FileUtils.deleteDirectory((File)workspacePathFile);
        workspacePathFile.mkdir();
        rtl.getRtlPaths().foreach((Function1 & Serializable & scala.Serializable)file -> {
            VivadoFlow$.$anonfun$apply$1(workspacePathFile, file);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable & scala.Serializable isVhdl = (Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)VivadoFlow$.$anonfun$apply$2(file));
        String readRtl = ((TraversableOnce)rtl.getRtlPaths().map((Function1 & Serializable & scala.Serializable)file -> new StringBuilder(6).append("read_").append((Object)(BoxesRunTime.unboxToBoolean((Object)isVhdl.apply(file)) ? "vhdl" : "verilog")).append(" ").append(Paths.get(file, new String[0]).getFileName()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
        FileWriter tcl = new FileWriter(Paths.get(workspacePath, "doit.tcl").toFile());
        tcl.write(new StringBuilder(116).append(readRtl).append("\nread_xdc doit.xdc\n\nsynth_design -part ").append(device).append(" -top ").append(rtl.getTopModuleName()).append("\nopt_design\nplace_design\nroute_design\n\nreport_utilization\nreport_timing").toString());
        tcl.flush();
        tcl.close();
        FileWriter xdc = new FileWriter(Paths.get(workspacePath, "doit.xdc").toFile());
        xdc.write(new StringBuilder(37).append("create_clock -period ").append(targetPeriod.$times(BigDecimal$.MODULE$.double2bigDecimal(1.0E9)).toBigDecimal()).append(" [get_ports clk]").toString());
        xdc.flush();
        xdc.close();
        DoCmd$.MODULE$.doCmd(new StringBuilder(61).append(vivadoPath).append("/vivado -nojournal -log doit.log -mode batch -source doit.tcl").toString(), workspacePath);
        BufferedSource log = Source$.MODULE$.fromFile(Paths.get(workspacePath, "doit.log").toFile(), Codec$.MODULE$.fallbackSystemCodec());
        String report = log.getLines().mkString();
        return new Report(family, report, targetPeriod){
            private final String family$1;
            private final String report$1;
            private final TimeNumber targetPeriod$1;

            public String toString() {
                return Report.toString$(this);
            }

            public double getFMax() {
                double d;
                Regex intFind = new StringOps(Predef$.MODULE$.augmentString("-?(\\d+\\.?)+")).r();
                try {
                    String string = this.family$1;
                    boolean bl = "Artix 7".equals(string) ? true : ("Kintex 7".equals(string) ? true : ("Kintex UltraScale".equals(string) ? true : ("Kintex UltraScale+".equals(string) ? true : "Virtex UltraScale+".equals(string))));
                    if (!bl) {
                        throw new MatchError((Object)string);
                    }
                    String string2 = (String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("-?(\\d+.?)+ns  \\(required time - arrival time\\)")).r().findFirstIn((CharSequence)this.report$1).get()).get();
                    d = new StringOps(Predef$.MODULE$.augmentString(string2)).toDouble();
                }
                catch (Exception e) {
                    d = -100000.0;
                }
                double slack = d;
                return 1.0 / (this.targetPeriod$1.toDouble() - slack * 1.0E-9);
            }

            public String getArea() {
                String string;
                Regex intFind = new StringOps(Predef$.MODULE$.augmentString("(\\d+,?)+")).r();
                try {
                    String string2;
                    String string3 = this.family$1;
                    boolean bl = "Artix 7".equals(string3) ? true : "Kintex 7".equals(string3);
                    if (bl) {
                        string2 = new StringBuilder(9).append((String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("Slice LUTs[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)this.report$1).get()).get()).append(" LUT ").append(intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("Slice Registers[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)this.report$1).get()).get()).append(" FF ").toString();
                    } else {
                        boolean bl2 = "Kintex UltraScale".equals(string3) ? true : ("Kintex UltraScale+".equals(string3) ? true : "Virtex UltraScale+".equals(string3));
                        if (bl2) {
                            string2 = new StringBuilder(9).append((String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("CLB LUTs[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)this.report$1).get()).get()).append(" LUT ").append(intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("CLB Registers[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)this.report$1).get()).get()).append(" FF ").toString();
                        } else {
                            throw new MatchError((Object)string3);
                        }
                    }
                    string = string2;
                }
                catch (Exception e) {
                    string = "???";
                }
                String leArea = string;
                return leArea;
            }
            {
                this.family$1 = family$1;
                this.report$1 = report$1;
                this.targetPeriod$1 = targetPeriod$1;
                Report.$init$(this);
            }
        };
    }

    public HertzNumber apply$default$6() {
        return null;
    }

    public int apply$default$7() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$apply$1(File workspacePathFile$1, String file) {
        FileUtils.copyFileToDirectory((File)new File(file), (File)workspacePathFile$1);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(String file) {
        return file.endsWith(".vhd") || file.endsWith(".vhdl");
    }

    private VivadoFlow$() {
        MODULE$ = this;
    }
}

