/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.bus.bram;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import spinal.core.BaseType;
import spinal.core.Bits;
import spinal.core.Bool;
import spinal.core.Bundle;
import spinal.core.Data;
import spinal.core.UInt;
import spinal.core.in$;
import spinal.core.out$;
import spinal.core.package;
import spinal.core.package$;
import spinal.lib.IMasterSlave;
import spinal.lib.bus.bram.BRAM$;
import spinal.lib.bus.bram.BRAMConfig;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0010!\u0001&B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u007f!)A\t\u0001C\u0001\u000b\"9\u0001\n\u0001b\u0001\n\u0003I\u0005BB'\u0001A\u0003%!\nC\u0004O\u0001\t\u0007I\u0011A(\t\rM\u0003\u0001\u0015!\u0003Q\u0011\u001d!\u0006A1A\u0005\u0002UCa!\u0017\u0001!\u0002\u00131\u0006b\u0002.\u0001\u0005\u0004%\ta\u0014\u0005\u00077\u0002\u0001\u000b\u0011\u0002)\t\u000fq\u0003!\u0019!C\u0001\u001f\"1Q\f\u0001Q\u0001\nACQA\u0018\u0001\u0005B}CQa\u0019\u0001\u0005\u0002\u0011DQa\u001a\u0001\u0005\u0002!DqA\u001b\u0001\u0002\u0002\u0013\u00051\u000eC\u0004n\u0001E\u0005I\u0011\u00018\t\u000fe\u0004\u0011\u0011!C!u\"I\u0011q\u0001\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0002\u0005\n\u0003#\u0001\u0011\u0011!C\u0001\u0003'A\u0011\"a\b\u0001\u0003\u0003%\t%!\t\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005Er!CA\u001eA\u0005\u0005\t\u0012AA\u001f\r!y\u0002%!A\t\u0002\u0005}\u0002B\u0002#\u001a\t\u0003\ti\u0005C\u0005\u0002Pe\t\t\u0011\"\u0012\u0002R!I\u00111K\r\u0002\u0002\u0013\u0005\u0015Q\u000b\u0005\n\u00033J\u0012\u0011!CA\u00037B\u0011\"a\u001a\u001a\u0003\u0003%I!!\u001b\u0003\t\t\u0013\u0016)\u0014\u0006\u0003C\t\nAA\u0019:b[*\u00111\u0005J\u0001\u0004EV\u001c(BA\u0013'\u0003\ra\u0017N\u0019\u0006\u0002O\u000511\u000f]5oC2\u001c\u0001aE\u0003\u0001UA\"$\b\u0005\u0002,]5\tAF\u0003\u0002.M\u0005!1m\u001c:f\u0013\tyCF\u0001\u0004Ck:$G.\u001a\t\u0003cIj\u0011\u0001J\u0005\u0003g\u0011\u0012A\"S'bgR,'o\u00157bm\u0016\u0004\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00026w%\u0011AH\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007G>tg-[4\u0016\u0003}\u0002\"\u0001Q!\u000e\u0003\u0001J!A\u0011\u0011\u0003\u0015\t\u0013\u0016)T\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\rqJg.\u001b;?)\t1u\t\u0005\u0002A\u0001!)Qh\u0001a\u0001\u007f\u0005\u0011QM\\\u000b\u0002\u0015B\u00111fS\u0005\u0003\u00192\u0012AAQ8pY\u0006\u0019QM\u001c\u0011\u0002\u0005],W#\u0001)\u0011\u0005-\n\u0016B\u0001*-\u0005\u0011\u0011\u0015\u000e^:\u0002\u0007],\u0007%\u0001\u0003bI\u0012\u0014X#\u0001,\u0011\u0005-:\u0016B\u0001--\u0005\u0011)\u0016J\u001c;\u0002\u000b\u0005$GM\u001d\u0011\u0002\r]\u0014H-\u0019;b\u0003\u001d9(\u000fZ1uC\u0002\naA\u001d3eCR\f\u0017a\u0002:eI\u0006$\u0018\rI\u0001\tCNl\u0015m\u001d;feR\t\u0001\r\u0005\u00026C&\u0011!M\u000e\u0002\u0005+:LG/\u0001\t%OJ,\u0017\r^3sI\u001d\u0014X-\u0019;feR\u0011\u0001-\u001a\u0005\u0006M>\u0001\rAR\u0001\u0005g&t7.\u0001\u0006%Y\u0016\u001c8\u000f\n7fgN$\"\u0001Y5\t\u000b\u0019\u0004\u0002\u0019\u0001$\u0002\t\r|\u0007/\u001f\u000b\u0003\r2Dq!P\t\u0011\u0002\u0003\u0007q(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003=T#a\u00109,\u0003E\u0004\"A]<\u000e\u0003MT!\u0001^;\u0002\u0013Ut7\r[3dW\u0016$'B\u0001<7\u0003)\tgN\\8uCRLwN\\\u0005\u0003qN\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t1\u0010E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\fA\u0001\\1oO*\u0011\u0011\u0011A\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0006u\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0006!\r)\u0014QB\u0005\u0004\u0003\u001f1$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u000b\u00037\u00012!NA\f\u0013\r\tIB\u000e\u0002\u0004\u0003:L\b\"CA\u000f+\u0005\u0005\t\u0019AA\u0006\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0005\t\u0007\u0003K\tY#!\u0006\u000e\u0005\u0005\u001d\"bAA\u0015m\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0012q\u0005\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00024\u0005e\u0002cA\u001b\u00026%\u0019\u0011q\u0007\u001c\u0003\u000f\t{w\u000e\\3b]\"I\u0011QD\f\u0002\u0002\u0003\u0007\u0011QC\u0001\u0005\u0005J\u000bU\n\u0005\u0002A3M!\u0011$!\u0011;!\u0019\t\u0019%!\u0013@\r6\u0011\u0011Q\t\u0006\u0004\u0003\u000f2\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u0017\n)EA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!!\u0010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a_\u0001\u0006CB\u0004H.\u001f\u000b\u0004\r\u0006]\u0003\"B\u001f\u001d\u0001\u0004y\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003;\n\u0019\u0007\u0005\u00036\u0003?z\u0014bAA1m\t1q\n\u001d;j_:D\u0001\"!\u001a\u001e\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u001b\u0011\u0007q\fi'C\u0002\u0002pu\u0014aa\u00142kK\u000e$\b")
public class BRAM
extends Bundle
implements IMasterSlave,
Product,
scala.Serializable {
    private final BRAMConfig config;
    private final Bool en;
    private final Bits we;
    private final UInt addr;
    private final Bits wrdata;
    private final Bits rddata;
    private boolean isMasterInterface;

    public static Option<BRAMConfig> unapply(BRAM bRAM) {
        return BRAM$.MODULE$.unapply(bRAM);
    }

    public static BRAM apply(BRAMConfig bRAMConfig) {
        return BRAM$.MODULE$.apply(bRAMConfig);
    }

    public static <A> Function1<BRAMConfig, A> andThen(Function1<BRAM, A> function1) {
        return BRAM$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BRAM> compose(Function1<A, BRAMConfig> function1) {
        return BRAM$.MODULE$.compose(function1);
    }

    @Override
    public void asSlave() {
        IMasterSlave.asSlave$(this);
    }

    @Override
    public boolean isMasterInterface() {
        return this.isMasterInterface;
    }

    @Override
    public void isMasterInterface_$eq(boolean x$1) {
        this.isMasterInterface = x$1;
    }

    public BRAMConfig config() {
        return this.config;
    }

    public Bool en() {
        return this.en;
    }

    public Bits we() {
        return this.we;
    }

    public UInt addr() {
        return this.addr;
    }

    public Bits wrdata() {
        return this.wrdata;
    }

    public Bits rddata() {
        return this.rddata;
    }

    @Override
    public void asMaster() {
        out$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BaseType[]{this.en(), this.we(), this.addr(), this.wrdata()}));
        in$.MODULE$.apply((Data)this.rddata());
    }

    public void $greater$greater(BRAM sink) {
        package$.MODULE$.assert(this.config().addressWidth() >= sink.config().addressWidth(), (Function0 & Serializable & scala.Serializable)() -> "BRAM mismatch width address (slave address is bigger than master address )");
        package$.MODULE$.assert(this.config().dataWidth() == sink.config().dataWidth(), (Function0 & Serializable & scala.Serializable)() -> "BRAM mismatch width data (slave and master doesn't have the same data width)");
        this.rddata().$colon$eq((Data)sink.rddata());
        sink.addr().$colon$eq(this.addr().resized());
        sink.we().$colon$eq((Data)this.we());
        sink.wrdata().$colon$eq((Data)this.wrdata());
        sink.en().$colon$eq((Data)this.en());
    }

    public void $less$less(BRAM sink) {
        sink.$greater$greater(this);
    }

    public BRAM copy(BRAMConfig config) {
        return new BRAM(config);
    }

    public BRAMConfig copy$default$1() {
        return this.config();
    }

    public String productPrefix() {
        return "BRAM";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.config();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BRAM;
    }

    public BRAM(BRAMConfig config) {
        this.config = config;
        IMasterSlave.$init$(this);
        Product.$init$((Product)this);
        package$.MODULE$.assert(config.dataWidth() > 0 & config.dataWidth() % 8 == 0, (Function0 & Serializable & scala.Serializable)() -> "BRAM : dataWidth must be a multiple of 8");
        this.en = (Bool)this.valCallback(package$.MODULE$.Bool(package$.MODULE$.Bool$default$1()), "en");
        this.we = (Bits)this.valCallback(package$.MODULE$.Bits(package.IntBuilder$.MODULE$.bits$extension(package$.MODULE$.IntToBuilder(config.dataWidth() / 8))), "we");
        this.addr = (UInt)this.valCallback(package$.MODULE$.UInt(package.IntBuilder$.MODULE$.bits$extension(package$.MODULE$.IntToBuilder(config.addressWidth()))), "addr");
        this.wrdata = (Bits)this.valCallback(package$.MODULE$.Bits(package.IntBuilder$.MODULE$.bits$extension(package$.MODULE$.IntToBuilder(config.dataWidth()))), "wrdata");
        this.rddata = (Bits)this.valCallback(package$.MODULE$.Bits(package.IntBuilder$.MODULE$.bits$extension(package$.MODULE$.IntToBuilder(config.dataWidth()))), "rddata");
    }
}

