/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.bus.amba4.axi.sim;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import spinal.core.BitVector;
import spinal.core.ClockDomain;
import spinal.core.sim.package$;
import spinal.lib.Stream;
import spinal.lib.bus.amba4.axi.Axi4;
import spinal.lib.bus.amba4.axi.Axi4Ar;
import spinal.lib.bus.amba4.axi.Axi4Aw;
import spinal.lib.bus.amba4.axi.Axi4Ax;
import spinal.lib.bus.amba4.axi.Axi4B;
import spinal.lib.bus.amba4.axi.Axi4R;
import spinal.lib.bus.amba4.axi.Axi4W;
import spinal.lib.bus.amba4.axi.sim.AxiJob;
import spinal.lib.bus.amba4.axi.sim.AxiMemorySim$;
import spinal.lib.bus.amba4.axi.sim.AxiMemorySimConfig;
import spinal.lib.bus.amba4.axi.sim.SparseMemory;
import spinal.sim.SimThread;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001\u0002\u00180\u0001rB\u0001B\r\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0015\"Aq\n\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003R\u0011!A\u0006A!f\u0001\n\u0003I\u0006\u0002\u00030\u0001\u0005#\u0005\u000b\u0011\u0002.\t\u000b}\u0003A\u0011\u00011\t\u000f\u0015\u0004!\u0019!C\u0001M\"1!\u000e\u0001Q\u0001\n\u001dDqa\u001b\u0001C\u0002\u0013\u0005A\u000e\u0003\u0004y\u0001\u0001\u0006I!\u001c\u0005\bs\u0002\u0011\r\u0011\"\u0001m\u0011\u0019Q\b\u0001)A\u0005[\"91\u0010\u0001b\u0001\n\u0003a\bbBA\u0004\u0001\u0001\u0006I! \u0005\n\u0003\u0013\u0001!\u0019!C\u0001\u0003\u0017A\u0001\"a\u0005\u0001A\u0003%\u0011Q\u0002\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!!\r\u0001\t\u0003\tI\u0003C\u0004\u00024\u0001!\t!!\u000b\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013C\u0011\"!%\u0001\u0003\u0003%\t!a%\t\u0013\u0005m\u0005!%A\u0005\u0002\u0005u\u0005\"CAZ\u0001E\u0005I\u0011AA[\u0011%\tI\fAI\u0001\n\u0003\tY\fC\u0005\u0002@\u0002\t\t\u0011\"\u0011\u0002B\"I\u00111\u001b\u0001\u0002\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003+\u0004\u0011\u0011!C\u0001\u0003/D\u0011\"a9\u0001\u0003\u0003%\t%!:\t\u0013\u0005=\b!!A\u0005\u0002\u0005E\b\"CA~\u0001\u0005\u0005I\u0011IA\u007f\u0011%\ty\u0010AA\u0001\n\u0003\u0012\t\u0001C\u0005\u0003\u0004\u0001\t\t\u0011\"\u0011\u0003\u0006\u001dI!\u0011B\u0018\u0002\u0002#\u0005!1\u0002\u0004\t]=\n\t\u0011#\u0001\u0003\u000e!1q\f\u000bC\u0001\u00057A\u0011\"a@)\u0003\u0003%)E!\u0001\t\u0013\tu\u0001&!A\u0005\u0002\n}\u0001\"\u0003B\u0014Q\u0005\u0005I\u0011\u0011B\u0015\u0011%\u0011Y\u0004KA\u0001\n\u0013\u0011iD\u0001\u0007Bq&lU-\\8ssNKWN\u0003\u00021c\u0005\u00191/[7\u000b\u0005I\u001a\u0014aA1yS*\u0011A'N\u0001\u0006C6\u0014\u0017\r\u000e\u0006\u0003m]\n1AY;t\u0015\tA\u0014(A\u0002mS\nT\u0011AO\u0001\u0007gBLg.\u00197\u0004\u0001M!\u0001!P\"G!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0019\te.\u001f*fMB\u0011a\bR\u0005\u0003\u000b~\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002?\u000f&\u0011\u0001j\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u000b\u0002\u0015B\u00111\nT\u0007\u0002c%\u0011Q*\r\u0002\u0005\u0003bLG'\u0001\u0003bq&\u0004\u0013aC2m_\u000e\\Gi\\7bS:,\u0012!\u0015\t\u0003%Vk\u0011a\u0015\u0006\u0003)f\nAaY8sK&\u0011ak\u0015\u0002\f\u00072|7m\u001b#p[\u0006Lg.\u0001\u0007dY>\u001c7\u000eR8nC&t\u0007%\u0001\u0004d_:4\u0017nZ\u000b\u00025B\u00111\fX\u0007\u0002_%\u0011Ql\f\u0002\u0013\u0003bLW*Z7pef\u001c\u0016.\\\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\rqJg.\u001b;?)\u0011\t'm\u00193\u0011\u0005m\u0003\u0001\"\u0002\u001a\b\u0001\u0004Q\u0005\"B(\b\u0001\u0004\t\u0006\"\u0002-\b\u0001\u0004Q\u0016AB7f[>\u0014\u00180F\u0001h!\tY\u0006.\u0003\u0002j_\ta1\u000b]1sg\u0016lU-\\8ss\u00069Q.Z7pef\u0004\u0013!\u00049f]\u0012LgnZ0sK\u0006$7/F\u0001n!\rq7/^\u0007\u0002_*\u0011\u0001/]\u0001\b[V$\u0018M\u00197f\u0015\t\u0011x(\u0001\u0006d_2dWm\u0019;j_:L!\u0001^8\u0003\u000bE+X-^3\u0011\u0005m3\u0018BA<0\u0005\u0019\t\u00050\u001b&pE\u0006q\u0001/\u001a8eS:<wL]3bIN\u0004\u0013A\u00049f]\u0012LgnZ0xe&$Xm]\u0001\u0010a\u0016tG-\u001b8h?^\u0014\u0018\u000e^3tA\u00059A\u000f\u001b:fC\u0012\u001cX#A?\u0011\u00079\u001ch\u0010E\u0002\u0000\u0003\u0007i!!!\u0001\u000b\u0005AJ\u0014\u0002BA\u0003\u0003\u0003\u0011\u0011bU5n)\"\u0014X-\u00193\u0002\u0011QD'/Z1eg\u0002\nABY;t/>\u0014HmV5ei\",\"!!\u0004\u0011\u0007y\ny!C\u0002\u0002\u0012}\u00121!\u00138u\u00035\u0011Wo],pe\u0012<\u0016\u000e\u001a;iA\u0005Ia.Z<Bq&TuN\u0019\u000b\u0006k\u0006e\u00111\u0005\u0005\b\u00037\u0011\u0002\u0019AA\u000f\u0003\u001d\tG\r\u001a:fgN\u00042APA\u0010\u0013\r\t\tc\u0010\u0002\u0005\u0019>tw\rC\u0004\u0002&I\u0001\r!!\u0004\u0002\u0017\t,(o\u001d;MK:<G\u000f[\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003W\u00012APA\u0017\u0013\r\tyc\u0010\u0002\u0005+:LG/\u0001\u0003ti>\u0004\u0018!\u0002:fg\u0016$\u0018\u0001\u00035b]\u0012dW-\u0011:\u0015\t\u0005-\u0012\u0011\b\u0005\b\u0003w1\u0002\u0019AA\u001f\u0003\t\t'\u000f\u0005\u0004\u0002@\u0005\u0005\u0013QI\u0007\u0002o%\u0019\u00111I\u001c\u0003\rM#(/Z1n!\rY\u0015qI\u0005\u0004\u0003\u0013\n$AB!ySR\n%/A\u0004iC:$G.\u001a*\u0015\t\u0005-\u0012q\n\u0005\b\u0003#:\u0002\u0019AA*\u0003\u0005\u0011\bCBA \u0003\u0003\n)\u0006E\u0002L\u0003/J1!!\u00172\u0005\u0015\t\u00050\u001b\u001bS\u0003!A\u0017M\u001c3mK\u0006;H\u0003BA\u0016\u0003?Bq!!\u0019\u0019\u0001\u0004\t\u0019'\u0001\u0002boB1\u0011qHA!\u0003K\u00022aSA4\u0013\r\tI'\r\u0002\u0007\u0003bLG'Q<\u0002\u000f!\fg\u000e\u001a7f/R1\u00111FA8\u0003wBq!!\u001d\u001a\u0001\u0004\t\u0019(A\u0001x!\u0019\ty$!\u0011\u0002vA\u00191*a\u001e\n\u0007\u0005e\u0014GA\u0003Bq&$t\u000bC\u0004\u0002~e\u0001\r!a \u0002\u0003\t\u0004b!a\u0010\u0002B\u0005\u0005\u0005cA&\u0002\u0004&\u0019\u0011QQ\u0019\u0003\u000b\u0005C\u0018\u000e\u000e\"\u0002\u0019!\fg\u000e\u001a7f\u0003^\fe\u000eZ,\u0015\u0011\u0005-\u00121RAG\u0003\u001fCq!!\u001d\u001b\u0001\u0004\t\u0019\bC\u0004\u0002bi\u0001\r!a\u0019\t\u000f\u0005u$\u00041\u0001\u0002\u0000\u0005!1m\u001c9z)\u001d\t\u0017QSAL\u00033CqAM\u000e\u0011\u0002\u0003\u0007!\nC\u0004P7A\u0005\t\u0019A)\t\u000fa[\u0002\u0013!a\u00015\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAPU\rQ\u0015\u0011U\u0016\u0003\u0003G\u0003B!!*\u000206\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+A\u0005v]\u000eDWmY6fI*\u0019\u0011QV \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00022\u0006\u001d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\\U\r\t\u0016\u0011U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tiLK\u0002[\u0003C\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAb!\u0011\t)-a4\u000e\u0005\u0005\u001d'\u0002BAe\u0003\u0017\fA\u0001\\1oO*\u0011\u0011QZ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\u0006\u001d'AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\u0017q\u001c\t\u0004}\u0005m\u0017bAAo\u007f\t\u0019\u0011I\\=\t\u0013\u0005\u0005\u0018%!AA\u0002\u00055\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002hB1\u0011\u0011^Av\u00033l\u0011!]\u0005\u0004\u0003[\f(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a=\u0002zB\u0019a(!>\n\u0007\u0005]xHA\u0004C_>dW-\u00198\t\u0013\u0005\u00058%!AA\u0002\u0005e\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u00055\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002t\n\u001d\u0001\"CAqM\u0005\u0005\t\u0019AAm\u00031\t\u00050['f[>\u0014\u0018pU5n!\tY\u0006f\u0005\u0003)\u0005\u001f1\u0005\u0003\u0003B\t\u0005/Q\u0015KW1\u000e\u0005\tM!b\u0001B\u000b\u007f\u00059!/\u001e8uS6,\u0017\u0002\u0002B\r\u0005'\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u0011Y!A\u0003baBd\u0017\u0010F\u0004b\u0005C\u0011\u0019C!\n\t\u000bIZ\u0003\u0019\u0001&\t\u000b=[\u0003\u0019A)\t\u000ba[\u0003\u0019\u0001.\u0002\u000fUt\u0017\r\u001d9msR!!1\u0006B\u001c!\u0015q$Q\u0006B\u0019\u0013\r\u0011yc\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ry\u0012\u0019DS)[\u0013\r\u0011)d\u0010\u0002\u0007)V\u0004H.Z\u001a\t\u0011\teB&!AA\u0002\u0005\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t}\u0002\u0003BAc\u0005\u0003JAAa\u0011\u0002H\n1qJ\u00196fGR\u0004")
public class AxiMemorySim
implements Product,
scala.Serializable {
    private final Axi4 axi;
    private final ClockDomain clockDomain;
    private final AxiMemorySimConfig config;
    private final SparseMemory memory;
    private final Queue<AxiJob> pending_reads;
    private final Queue<AxiJob> pending_writes;
    private final Queue<SimThread> threads;
    private final int busWordWidth;

    public static Option<Tuple3<Axi4, ClockDomain, AxiMemorySimConfig>> unapply(AxiMemorySim axiMemorySim) {
        return AxiMemorySim$.MODULE$.unapply(axiMemorySim);
    }

    public static AxiMemorySim apply(Axi4 axi4, ClockDomain clockDomain, AxiMemorySimConfig axiMemorySimConfig) {
        return AxiMemorySim$.MODULE$.apply(axi4, clockDomain, axiMemorySimConfig);
    }

    public static Function1<Tuple3<Axi4, ClockDomain, AxiMemorySimConfig>, AxiMemorySim> tupled() {
        return AxiMemorySim$.MODULE$.tupled();
    }

    public static Function1<Axi4, Function1<ClockDomain, Function1<AxiMemorySimConfig, AxiMemorySim>>> curried() {
        return AxiMemorySim$.MODULE$.curried();
    }

    public Axi4 axi() {
        return this.axi;
    }

    public ClockDomain clockDomain() {
        return this.clockDomain;
    }

    public AxiMemorySimConfig config() {
        return this.config;
    }

    public SparseMemory memory() {
        return this.memory;
    }

    public Queue<AxiJob> pending_reads() {
        return this.pending_reads;
    }

    public Queue<AxiJob> pending_writes() {
        return this.pending_writes;
    }

    public Queue<SimThread> threads() {
        return this.threads;
    }

    public int busWordWidth() {
        return this.busWordWidth;
    }

    public AxiJob newAxiJob(long address, int burstLength) {
        return new AxiJob(address, burstLength);
    }

    public void start() {
        this.threads().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.handleAr(this.axi().ar()))}));
        this.threads().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.handleR(this.axi().r()))}));
        if (this.config().useAlteraBehavior()) {
            this.threads().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.handleAwAndW(this.axi().w(), this.axi().aw(), this.axi().b()))}));
        } else {
            this.threads().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.handleAw(this.axi().aw()))}));
            this.threads().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.handleW(this.axi().w(), this.axi().b()))}));
        }
    }

    public void stop() {
        this.threads().map((Function1 & Serializable & scala.Serializable)f -> {
            f.terminate();
            return BoxedUnit.UNIT;
        }, Queue$.MODULE$.canBuildFrom());
    }

    public void reset() {
        this.stop();
        this.pending_reads().clear();
        this.pending_writes().clear();
        this.start();
    }

    public void handleAr(Stream<Axi4Ar> ar) {
        Predef$.MODULE$.println((Object)"Handling AXI4 Master read cmds...");
        package$.MODULE$.SimBoolPimper(ar.ready()).$hash$eq(false);
        while (true) {
            package$.MODULE$.SimBoolPimper(ar.ready()).$hash$eq(true);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(ar.valid()).toBoolean());
            package$.MODULE$.SimBoolPimper(ar.ready()).$hash$eq(false);
            spinal.core.package$.MODULE$.assert(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)ar.payload()).len()).toBigInt().$plus(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)ar.payload()).addr()).toBigInt().$amp(BigInt$.MODULE$.int2bigInt(4095))).$less$eq((Object)BigInt$.MODULE$.int2bigInt(4095)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Read request crossing 4k boundary (addr=").append(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)((Object)((Object)ar.payload()))).addr()).toBigInt().toString(16)).append(", len=").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)((Object)((Object)ar.payload()))).len()).toLong()))).toString());
            this.pending_reads().$plus$eq((Object)this.newAxiJob(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)ar.payload()).addr()).toLong(), package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)ar.payload()).len()).toInt()));
            if (this.pending_reads().length() < this.config().maxOutstandingReads()) continue;
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.pending_reads().length() < this.config().maxOutstandingReads());
        }
    }

    public void handleR(Stream<Axi4R> r) {
        Predef$.MODULE$.println((Object)"Handling AXI4 Master read resp...");
        Random$ random = Random$.MODULE$;
        package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(r.payload().last()).$hash$eq(false);
        while (true) {
            Object object;
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(1);
            if (this.pending_reads().nonEmpty()) {
                AxiJob job = (AxiJob)this.pending_reads().front();
                package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(true);
                int i = 0;
                while (i <= job.burstLength()) {
                    if (this.config().interruptProbability() > random.nextInt(100)) {
                        package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(false);
                        package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(random.nextInt(this.config().interruptMaxDelay() + 1));
                        package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(true);
                        if (i == job.burstLength()) {
                            package$.MODULE$.SimBoolPimper(r.payload().last()).$hash$eq(true);
                        }
                        package$.MODULE$.SimBitVectorPimper((BitVector)r.payload().data()).$hash$eq(this.memory().readBigInt(job.address() + (long)(i * this.busWordWidth()), this.busWordWidth()));
                        package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(r.ready()).toBoolean());
                        ++i;
                        continue;
                    }
                    if (i == job.burstLength()) {
                        package$.MODULE$.SimBoolPimper(r.payload().last()).$hash$eq(true);
                    }
                    package$.MODULE$.SimBitVectorPimper((BitVector)r.payload().data()).$hash$eq(this.memory().readBigInt(job.address() + (long)(i * this.busWordWidth()), this.busWordWidth()));
                    package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(r.ready()).toBoolean());
                    ++i;
                }
                package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(false);
                package$.MODULE$.SimBoolPimper(r.payload().last()).$hash$eq(false);
                object = this.pending_reads().dequeue();
                continue;
            }
            object = BoxedUnit.UNIT;
        }
    }

    public void handleAw(Stream<Axi4Aw> aw) {
        Predef$.MODULE$.println((Object)"Handling AXI4 Master write cmds...");
        package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
        while (true) {
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(true);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(aw.valid()).toBoolean());
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
            spinal.core.package$.MODULE$.assert(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).len()).toBigInt().$plus(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).addr()).toBigInt().$amp(BigInt$.MODULE$.int2bigInt(4095))).$less$eq((Object)BigInt$.MODULE$.int2bigInt(4095)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Write request crossing 4k boundary (addr=").append(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)((Object)((Object)aw.payload()))).addr()).toBigInt().toString(16)).append(", len=").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)((Object)((Object)aw.payload()))).len()).toLong()))).toString());
            this.pending_writes().$plus$eq((Object)this.newAxiJob(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).addr()).toLong(), package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).len()).toInt()));
            if (this.pending_writes().length() < this.config().maxOutstandingWrites()) continue;
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.pending_writes().length() < this.config().maxOutstandingWrites());
        }
    }

    public void handleW(Stream<Axi4W> w, Stream<Axi4B> b) {
        Predef$.MODULE$.println((Object)"Handling AXI4 Master write...");
        package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
        while (true) {
            Object object;
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(10);
            if (this.pending_writes().nonEmpty()) {
                ObjectRef job = ObjectRef.create((Object)((AxiJob)this.pending_writes().front()));
                int count = ((AxiJob)job.elem).burstLength();
                package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(true);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ((AxiJob)job.elem).burstLength()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(w.valid()).toBoolean());
                    this.memory().writeBigInt(((AxiJob)job$1.elem).address() + (long)(i * this.busWordWidth()), package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4W)((Object)((Object)w.payload()))).data()).toBigInt(), this.busWordWidth());
                });
                package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
                package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(this.config().writeResponseDelay());
                package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(true);
                package$.MODULE$.SimBitVectorPimper((BitVector)b.payload().resp()).$hash$eq(0);
                package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(b.ready()).toBoolean());
                package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
                object = this.pending_writes().dequeue();
                continue;
            }
            object = BoxedUnit.UNIT;
        }
    }

    public void handleAwAndW(Stream<Axi4W> w, Stream<Axi4Aw> aw, Stream<Axi4B> b) {
        Predef$.MODULE$.println((Object)"Handling AXI4 Master write cmds and write (Altera/Intel behavior)...");
        Random$ random = Random$.MODULE$;
        package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
        while (true) {
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(aw.valid()).toBoolean() && package$.MODULE$.SimBoolPimper(w.valid()).toBoolean());
            package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(true);
            spinal.core.package$.MODULE$.assert(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).len()).toBigInt().$plus(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).addr()).toBigInt().$amp(BigInt$.MODULE$.int2bigInt(4095))).$less$eq((Object)BigInt$.MODULE$.int2bigInt(4095)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Write request crossing 4k boundary (addr=").append(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)((Object)((Object)aw.payload()))).addr()).toBigInt().toString(16)).append(", len=").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)((Object)((Object)aw.payload()))).len()).toLong()))).toString());
            int i = 0;
            while (i <= package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).len()).toInt()) {
                if (this.config().interruptProbability() > random.nextInt(100)) {
                    package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
                    package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(random.nextInt(this.config().interruptMaxDelay() + 1));
                    package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(true);
                    continue;
                }
                package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(w.valid()).toBoolean());
                this.memory().writeBigInt(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).addr()).toLong() + (long)(i * this.busWordWidth()), package$.MODULE$.SimBitVectorPimper((BitVector)w.payload().data()).toBigInt(), this.busWordWidth());
                ++i;
            }
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(true);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(1);
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
            package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(this.config().writeResponseDelay());
            package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(true);
            package$.MODULE$.SimBitVectorPimper((BitVector)b.payload().resp()).$hash$eq(0);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SimBoolPimper(b.ready()).toBoolean());
            package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
        }
    }

    public AxiMemorySim copy(Axi4 axi, ClockDomain clockDomain, AxiMemorySimConfig config) {
        return new AxiMemorySim(axi, clockDomain, config);
    }

    public Axi4 copy$default$1() {
        return this.axi();
    }

    public ClockDomain copy$default$2() {
        return this.clockDomain();
    }

    public AxiMemorySimConfig copy$default$3() {
        return this.config();
    }

    public String productPrefix() {
        return "AxiMemorySim";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        scala.Serializable serializable;
        int n = x$1;
        switch (n) {
            case 0: {
                serializable = this.axi();
                break;
            }
            case 1: {
                serializable = this.clockDomain();
                break;
            }
            case 2: {
                serializable = this.config();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return serializable;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AxiMemorySim;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AxiMemorySim)) return false;
        boolean bl = true;
        if (!bl) return false;
        AxiMemorySim axiMemorySim = (AxiMemorySim)x$1;
        Axi4 axi4 = this.axi();
        Axi4 axi42 = axiMemorySim.axi();
        if (axi4 == null) {
            if (axi42 != null) {
                return false;
            }
        } else if (!axi4.equals(axi42)) return false;
        ClockDomain clockDomain = this.clockDomain();
        ClockDomain clockDomain2 = axiMemorySim.clockDomain();
        if (clockDomain == null) {
            if (clockDomain2 != null) {
                return false;
            }
        } else if (!clockDomain.equals(clockDomain2)) return false;
        AxiMemorySimConfig axiMemorySimConfig = this.config();
        AxiMemorySimConfig axiMemorySimConfig2 = axiMemorySim.config();
        if (axiMemorySimConfig == null) {
            if (axiMemorySimConfig2 != null) {
                return false;
            }
        } else if (!((Object)axiMemorySimConfig).equals(axiMemorySimConfig2)) return false;
        if (!axiMemorySim.canEqual(this)) return false;
        return true;
    }

    public AxiMemorySim(Axi4 axi, ClockDomain clockDomain, AxiMemorySimConfig config) {
        this.axi = axi;
        this.clockDomain = clockDomain;
        this.config = config;
        Product.$init$((Product)this);
        this.memory = new SparseMemory();
        this.pending_reads = new Queue();
        this.pending_writes = new Queue();
        this.threads = new Queue();
        this.busWordWidth = axi.config().dataWidth() / 8;
    }
}

