/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.bus.amba4.axi.sim;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import spinal.core.BitVector;
import spinal.core.ClockDomain;
import spinal.core.SpinalWarning$;
import spinal.core.log2Up$;
import spinal.lib.DataCarrier$;
import spinal.lib.Stream;
import spinal.lib.bus.amba4.axi.Axi4;
import spinal.lib.bus.amba4.axi.Axi4Ar;
import spinal.lib.bus.amba4.axi.Axi4Ax;
import spinal.lib.bus.amba4.axi.Axi4Config;
import spinal.lib.bus.amba4.axi.Axi4R;
import spinal.lib.bus.amba4.axi.Axi4ReadOnly;
import spinal.lib.sim.StreamDriver;
import spinal.lib.sim.StreamDriver$;
import spinal.lib.sim.StreamMonitor;
import spinal.lib.sim.StreamMonitor$;
import spinal.lib.sim.StreamReadyRandomizer;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001\u0002\r\u001a\u0001\u0019B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%A\bC\u0003C\u0001\u0011\u00051\tC\u0003C\u0001\u0011\u0005\u0011\nC\u0003C\u0001\u0011\u0005q\nC\u0004V\u0001\t\u0007I\u0011\u0001,\t\ri\u0003\u0001\u0015!\u0003X\u0011\u001dY\u0006A1A\u0005\u0002qCa\u0001\u0019\u0001!\u0002\u0013i\u0006bB1\u0001\u0005\u0004%\tA\u0019\u0005\u0007W\u0002\u0001\u000b\u0011B2\t\u000f1\u0004!\u0019!C\u00019\"1Q\u000e\u0001Q\u0001\nuCqA\u001c\u0001C\u0002\u0013\u0005q\u000e\u0003\u0004{\u0001\u0001\u0006I\u0001\u001d\u0005\u0006w\u0002!\t\u0001 \u0005\n\u0003;\u0001!\u0019!C\u0001\u0003?A\u0001\"a\u000b\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0003[\u0001!\u0019!C\u0001\u0003_A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003s\u0001!\u0019!C\u0001\u0003wA\u0001\"a\u0011\u0001A\u0003%\u0011Q\b\u0002\u0017\u0003bLGGU3bI>sG._*mCZ,\u0017iZ3oi*\u0011!dG\u0001\u0004g&l'B\u0001\u000f\u001e\u0003\r\t\u00070\u001b\u0006\u0003=}\tQ!Y7cCRR!\u0001I\u0011\u0002\u0007\t,8O\u0003\u0002#G\u0005\u0019A.\u001b2\u000b\u0003\u0011\naa\u001d9j]\u0006d7\u0001A\n\u0003\u0001\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0017AA1s!\ry\u0003GM\u0007\u0002C%\u0011\u0011'\t\u0002\u0007'R\u0014X-Y7\u0011\u0005M\"T\"A\u000e\n\u0005UZ\"AB!ySR\n%/A\u0001s!\ry\u0003\u0007\u000f\t\u0003geJ!AO\u000e\u0003\u000b\u0005C\u0018\u000e\u000e*\u0002\u0017\rdwnY6E_6\f\u0017N\u001c\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f\r\nAaY8sK&\u0011\u0011I\u0010\u0002\f\u00072|7m\u001b#p[\u0006Lg.\u0001\u0004=S:LGO\u0010\u000b\u0005\t\u001a;\u0005\n\u0005\u0002F\u00015\t\u0011\u0004C\u0003.\t\u0001\u0007a\u0006C\u00037\t\u0001\u0007q\u0007C\u0003<\t\u0001\u0007A\bF\u0002E\u0015:CQ\u0001I\u0003A\u0002-\u0003\"a\r'\n\u00055[\"\u0001D!ySR\u0012V-\u00193P]2L\b\"B\u001e\u0006\u0001\u0004aDc\u0001#Q)\")\u0001E\u0002a\u0001#B\u00111GU\u0005\u0003'n\u0011A!\u0011=ji!)1H\u0002a\u0001y\u0005I!-^:D_:4\u0017nZ\u000b\u0002/B\u00111\u0007W\u0005\u00033n\u0011!\"\u0011=ji\r{gNZ5h\u0003)\u0011Wo]\"p]\u001aLw\rI\u0001\rCJ\fV/Z;f\t\u0016\u0004H\u000f[\u000b\u0002;B\u0011\u0001FX\u0005\u0003?&\u00121!\u00138u\u00035\t'/U;fk\u0016$U\r\u001d;iA\u00059\u0011M])vKV,W#A2\u0011\u0007\u0011LW,D\u0001f\u0015\t1w-A\u0004nkR\f'\r\\3\u000b\u0005!L\u0013AC2pY2,7\r^5p]&\u0011!.\u001a\u0002\u0006#V,W/Z\u0001\tCJ\fV/Z;fA\u00059\u0011\u000eZ\"pk:$\u0018\u0001C5e\u0007>,h\u000e\u001e\u0011\u0002\rI\fV/Z;f+\u0005\u0001\bc\u0001\u0015rg&\u0011!/\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004I&$\bc\u0001\u0015vo&\u0011a/\u000b\u0002\n\rVt7\r^5p]B\u0002\"\u0001\u000b=\n\u0005eL#\u0001B+oSR\fqA])vKV,\u0007%\u0001\u0005sK\u0006$')\u001f;f)\ri\u0018\u0011\u0001\t\u0003QyL!a`\u0015\u0003\t\tKH/\u001a\u0005\b\u0003\u0007\t\u0002\u0019AA\u0003\u0003\u001d\tG\r\u001a:fgN\u0004B!a\u0002\u0002\u00189!\u0011\u0011BA\n\u001d\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\bK\u00051AH]8pizJ\u0011AK\u0005\u0004\u0003+I\u0013a\u00029bG.\fw-Z\u0005\u0005\u00033\tYB\u0001\u0004CS\u001eLe\u000e\u001e\u0006\u0004\u0003+I\u0013!C1s\u001b>t\u0017\u000e^8s+\t\t\t\u0003E\u0003\u0002$\u0005\u001d\"'\u0004\u0002\u0002&)\u0011!$I\u0005\u0005\u0003S\t)CA\u0007TiJ,\u0017-\\'p]&$xN]\u0001\u000bCJluN\\5u_J\u0004\u0013a\u0002:Ee&4XM]\u000b\u0003\u0003c\u0001R!a\t\u00024aJA!!\u000e\u0002&\ta1\u000b\u001e:fC6$%/\u001b<fe\u0006A!\u000f\u0012:jm\u0016\u0014\b%\u0001\u0005be\u0012\u0013\u0018N^3s+\t\ti\u0004E\u0003\u0002$\u0005}\"'\u0003\u0003\u0002B\u0005\u0015\"!F*ue\u0016\fWNU3bIf\u0014\u0016M\u001c3p[&TXM]\u0001\nCJ$%/\u001b<fe\u0002\u0002")
public class Axi4ReadOnlySlaveAgent {
    private final Stream<Axi4R> r;
    private final Axi4Config busConfig;
    private final int arQueueDepth;
    private final Queue<Object> arQueue;
    private final int idCount;
    private final Queue<Function0<BoxedUnit>>[] rQueue;
    private final StreamMonitor<Axi4Ar> arMonitor;
    private final StreamDriver<Axi4R> rDriver;
    private final StreamReadyRandomizer<Axi4Ar> arDriver;

    public Axi4Config busConfig() {
        return this.busConfig;
    }

    public int arQueueDepth() {
        return this.arQueueDepth;
    }

    public Queue<Object> arQueue() {
        return this.arQueue;
    }

    public int idCount() {
        return this.idCount;
    }

    public Queue<Function0<BoxedUnit>>[] rQueue() {
        return this.rQueue;
    }

    public byte readByte(BigInt address) {
        return (byte)Random$.MODULE$.nextInt();
    }

    public StreamMonitor<Axi4Ar> arMonitor() {
        return this.arMonitor;
    }

    public StreamDriver<Axi4R> rDriver() {
        return this.rDriver;
    }

    public StreamReadyRandomizer<Axi4Ar> arDriver() {
        return this.arDriver;
    }

    public static final /* synthetic */ Queue $anonfun$arMonitor$2(Axi4ReadOnlySlaveAgent $this, int burst$3, BigInt addr$1, int bytePerBeat$1, int bytes$1, int id$4, int len$4, int beat) {
        BigInt bigInt;
        int n = burst$3;
        switch (n) {
            case 0: {
                bigInt = addr$1;
                break;
            }
            case 1: {
                bigInt = addr$1.$plus(BigInt$.MODULE$.int2bigInt(bytePerBeat$1 * beat)).$amp(package$.MODULE$.BigInt().apply($this.busConfig().bytePerWord() - 1).unary_$tilde());
                break;
            }
            case 2: {
                BigInt base = addr$1.$amp(package$.MODULE$.BigInt().apply(bytes$1 - 1).unary_$tilde());
                bigInt = base.$plus(addr$1.$plus(BigInt$.MODULE$.int2bigInt(bytePerBeat$1 * beat)).$amp(package$.MODULE$.BigInt().apply(bytes$1 - 1))).$amp(package$.MODULE$.BigInt().apply($this.busConfig().bytePerWord() - 1).unary_$tilde());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        BigInt beatAddress = bigInt;
        return (Queue)$this.rQueue()[id$4].$plus$eq((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block3: {
                if ($this.busConfig().useId()) {
                    spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)DataCarrier$.MODULE$.toImplicit($this.r).id()).$hash$eq(id$4);
                }
                if ($this.busConfig().useResp()) {
                    spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)DataCarrier$.MODULE$.toImplicit($this.r).resp()).$hash$eq(0);
                }
                if ($this.busConfig().useLast()) {
                    spinal.core.sim.package$.MODULE$.SimBoolPimper(DataCarrier$.MODULE$.toImplicit($this.r).last()).$hash$eq(beat == len$4);
                }
                ObjectRef data = ObjectRef.create((Object)package$.MODULE$.BigInt().apply(0));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.busConfig().bytePerWord()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    data$1.elem = ((BigInt)data$1.elem).$bar(package$.MODULE$.BigInt().apply($this.readByte(beatAddress.$plus(BigInt$.MODULE$.int2bigInt(i))) & 0xFF).$less$less(i * 8));
                });
                spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)DataCarrier$.MODULE$.toImplicit($this.r).data()).$hash$eq((BigInt)data.elem);
                if (beat != len$4) break block3;
                $this.arQueue().dequeue();
            }
        });
    }

    public static final /* synthetic */ void $anonfun$arMonitor$1(Axi4ReadOnlySlaveAgent $this, Axi4Ar ar) {
        int size = $this.busConfig().useSize() ? spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)ar.size()).toInt() : log2Up$.MODULE$.apply($this.busConfig().dataWidth() / 8);
        int len = $this.busConfig().useLen() ? spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)ar.len()).toInt() : 0;
        int id = $this.busConfig().useId() ? spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)ar.id()).toInt() : 0;
        int burst = $this.busConfig().useBurst() ? spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)ar.burst()).toInt() : 1;
        BigInt addr = spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)ar.addr()).toBigInt();
        int bytePerBeat = 1 << size;
        int bytes = (len + 1) * bytePerBeat;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable & scala.Serializable)beat -> Axi4ReadOnlySlaveAgent.$anonfun$arMonitor$2($this, burst, addr, bytePerBeat, bytes, id, len, BoxesRunTime.unboxToInt((Object)beat)));
        $this.arQueue().enqueue((Seq)Predef$.MODULE$.wrapIntArray(new int[]{id}));
    }

    public static final /* synthetic */ boolean $anonfun$rDriver$1(Axi4ReadOnlySlaveAgent $this, Axi4R x$10) {
        boolean bl;
        Queue[] queues = (Queue[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.rQueue())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.nonEmpty()));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queues)).nonEmpty()) {
            ((Function0)queues[Random$.MODULE$.nextInt(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queues)).size())].dequeue()).apply$mcV$sp();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public Axi4ReadOnlySlaveAgent(Stream<Axi4Ar> ar2, Stream<Axi4R> r, ClockDomain clockDomain) {
        this.r = r;
        this.busConfig = ((Axi4Ax)DataCarrier$.MODULE$.toImplicit(ar2)).config();
        if (!this.busConfig().useLen()) {
            SpinalWarning$.MODULE$.apply("The Axi4Config with useLen == false is only tested by assigning len = 0, determine the burst length of transcation by last signal should not work.");
        }
        this.arQueueDepth = 1;
        this.arQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.idCount = this.busConfig().useId() ? 1 << this.busConfig().idWidth() : 1;
        this.rQueue = (Queue[])Array$.MODULE$.fill(this.idCount(), (Function0 & Serializable & scala.Serializable)() -> (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$), ClassTag$.MODULE$.apply(Queue.class));
        this.arMonitor = StreamMonitor$.MODULE$.apply(ar2, clockDomain, (Function1 & Serializable & scala.Serializable)ar -> {
            Axi4ReadOnlySlaveAgent.$anonfun$arMonitor$1(this, ar);
            return BoxedUnit.UNIT;
        });
        this.rDriver = StreamDriver$.MODULE$.apply(r, clockDomain, (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Axi4ReadOnlySlaveAgent.$anonfun$rDriver$1(this, x$10)));
        this.arDriver = new StreamReadyRandomizer<Axi4Ar>(ar2, clockDomain, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.arQueue().size() < this.arQueueDepth());
    }

    public Axi4ReadOnlySlaveAgent(Axi4ReadOnly bus, ClockDomain clockDomain) {
        this(bus.ar(), bus.r(), clockDomain);
    }

    public Axi4ReadOnlySlaveAgent(Axi4 bus, ClockDomain clockDomain) {
        this(bus.ar(), bus.r(), clockDomain);
    }
}

