/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.bus.amba4.axi.sim;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import spinal.core.BitVector;
import spinal.core.ClockDomain;
import spinal.core.SpinalWarning$;
import spinal.core.log2Up$;
import spinal.lib.DataCarrier$;
import spinal.lib.Stream;
import spinal.lib.bus.amba4.axi.Axi4;
import spinal.lib.bus.amba4.axi.Axi4Ar;
import spinal.lib.bus.amba4.axi.Axi4Ax;
import spinal.lib.bus.amba4.axi.Axi4Config;
import spinal.lib.bus.amba4.axi.Axi4R;
import spinal.lib.bus.amba4.axi.Axi4ReadOnly;
import spinal.lib.sim.StreamMonitor;
import spinal.lib.sim.StreamMonitor$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb!\u0002\n\u0014\u0003\u0003\u0001\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u0011A\u0002!\u0011!Q\u0001\nEB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006y\u0001!\t!\u0010\u0005\u0006y\u0001!\ta\u0011\u0005\u0006y\u0001!\t!\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001Q\u0011\u0019!\u0006\u0001)A\u0005#\")Q\u000b\u0001D\u0001-\")!\u000f\u0001D\u0001g\"9Q\u000f\u0001b\u0001\n\u00031\bbBA\u0003\u0001\u0001\u0006Ia\u001e\u0005\n\u0003\u000f\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"!\u0006\u0001A\u0003%\u00111\u0002\u0005\n\u0003/\u0001!\u0019!C\u0001\u00033A\u0001\"!\b\u0001A\u0003%\u00111\u0004\u0005\b\u0003?\u0001A\u0011AA\u0011\u0005M\t\u00050\u001b\u001bSK\u0006$wJ\u001c7z\u001b>t\u0017\u000e^8s\u0015\t!R#A\u0002tS6T!AF\f\u0002\u0007\u0005D\u0018N\u0003\u0002\u00193\u0005)\u0011-\u001c2bi)\u0011!dG\u0001\u0004EV\u001c(B\u0001\u000f\u001e\u0003\ra\u0017N\u0019\u0006\u0002=\u000511\u000f]5oC2\u001c\u0001a\u0005\u0002\u0001CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\f!!\u0019:\u0011\u0007%RC&D\u0001\u001c\u0013\tY3D\u0001\u0004TiJ,\u0017-\u001c\t\u0003[9j\u0011!F\u0005\u0003_U\u0011a!\u0011=ji\u0005\u0013\u0018!\u0001:\u0011\u0007%R#\u0007\u0005\u0002.g%\u0011A'\u0006\u0002\u0006\u0003bLGGU\u0001\fG2|7m\u001b#p[\u0006Lg\u000e\u0005\u00028u5\t\u0001H\u0003\u0002:;\u0005!1m\u001c:f\u0013\tY\u0004HA\u0006DY>\u001c7\u000eR8nC&t\u0017A\u0002\u001fj]&$h\b\u0006\u0003?\u0001\u0006\u0013\u0005CA \u0001\u001b\u0005\u0019\u0002\"B\u0014\u0005\u0001\u0004A\u0003\"\u0002\u0019\u0005\u0001\u0004\t\u0004\"B\u001b\u0005\u0001\u00041Dc\u0001 E\u0011\")!$\u0002a\u0001\u000bB\u0011QFR\u0005\u0003\u000fV\u0011A\"\u0011=jiI+\u0017\rZ(oYfDQ!N\u0003A\u0002Y\"2A\u0010&O\u0011\u0015Qb\u00011\u0001L!\tiC*\u0003\u0002N+\t!\u0011\t_55\u0011\u0015)d\u00011\u00017\u0003%\u0011Wo]\"p]\u001aLw-F\u0001R!\ti#+\u0003\u0002T+\tQ\u0011\t_55\u0007>tg-[4\u0002\u0015\t,8oQ8oM&<\u0007%\u0001\u0006p]J+\u0017\r\u001a\"zi\u0016$Ba\u0016.i[B\u0011!\u0005W\u0005\u00033\u000e\u0012A!\u00168ji\")1,\u0003a\u00019\u00069\u0011\r\u001a3sKN\u001c\bCA/f\u001d\tq6M\u0004\u0002`E6\t\u0001M\u0003\u0002b?\u00051AH]8pizJ\u0011\u0001J\u0005\u0003I\u000e\nq\u0001]1dW\u0006<W-\u0003\u0002gO\n1!)[4J]RT!\u0001Z\u0012\t\u000b%L\u0001\u0019\u00016\u0002\t\u0011\fG/\u0019\t\u0003E-L!\u0001\\\u0012\u0003\t\tKH/\u001a\u0005\u0006]&\u0001\ra\\\u0001\u0003S\u0012\u0004\"A\t9\n\u0005E\u001c#aA%oi\u00061qN\u001c'bgR$\"a\u0016;\t\u000b9T\u0001\u0019A8\u0002\rI\fV/Z;f+\u00059\bc\u0001=~\u007f6\t\u0011P\u0003\u0002{w\u00069Q.\u001e;bE2,'B\u0001?$\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003}f\u0014Q!U;fk\u0016\u0004BAIA\u0001/&\u0019\u00111A\u0012\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014a\u0002:Rk\u0016,X\rI\u0001\nCJluN\\5u_J,\"!a\u0003\u0011\u000b\u00055\u0011\u0011\u0003\u0017\u000e\u0005\u0005=!B\u0001\u000b\u001c\u0013\u0011\t\u0019\"a\u0004\u0003\u001bM#(/Z1n\u001b>t\u0017\u000e^8s\u0003)\t'/T8oSR|'\u000fI\u0001\te6{g.\u001b;peV\u0011\u00111\u0004\t\u0006\u0003\u001b\t\tBM\u0001\ne6{g.\u001b;pe\u0002\nQA]3tKR$\u0012a\u0016")
public abstract class Axi4ReadOnlyMonitor {
    private final Stream<Axi4Ar> ar;
    private final Stream<Axi4R> r;
    private final Axi4Config busConfig;
    private final Queue<Function0<BoxedUnit>> rQueue;
    private final StreamMonitor<Axi4Ar> arMonitor;
    private final StreamMonitor<Axi4R> rMonitor;

    public Axi4Config busConfig() {
        return this.busConfig;
    }

    public abstract void onReadByte(BigInt var1, byte var2, int var3);

    public abstract void onLast(int var1);

    public Queue<Function0<BoxedUnit>> rQueue() {
        return this.rQueue;
    }

    public StreamMonitor<Axi4Ar> arMonitor() {
        return this.arMonitor;
    }

    public StreamMonitor<Axi4R> rMonitor() {
        return this.rMonitor;
    }

    public void reset() {
        this.rQueue().clear();
    }

    public static final /* synthetic */ Queue $anonfun$arMonitor$6(Axi4ReadOnlyMonitor $this, int burst$5, BigInt addr$3, int bytePerBeat$3, int bytes$3, int len$6, int id$5, int beat) {
        BigInt bigInt;
        int n = burst$5;
        switch (n) {
            case 0: {
                bigInt = addr$3;
                break;
            }
            case 1: {
                bigInt = addr$3.$plus(BigInt$.MODULE$.int2bigInt(bytePerBeat$3 * beat));
                break;
            }
            case 2: {
                BigInt base = addr$3.$amp(package$.MODULE$.BigInt().apply(bytes$3 - 1).unary_$tilde());
                bigInt = base.$plus(addr$3.$plus(BigInt$.MODULE$.int2bigInt(bytePerBeat$3 * beat)).$amp(package$.MODULE$.BigInt().apply(bytes$3 - 1)));
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        BigInt beatAddress = bigInt;
        BigInt accessAddress = beatAddress.$amp(package$.MODULE$.BigInt().apply($this.busConfig().bytePerWord() - 1).unary_$tilde());
        return (Queue)$this.rQueue().$plus$eq((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block2: {
                if ($this.busConfig().useLast()) {
                    spinal.core.package$.MODULE$.assert(spinal.core.sim.package$.MODULE$.SimBoolPimper(DataCarrier$.MODULE$.toImplicit($this.r).last()).toBoolean() == (beat == len$6));
                }
                if ($this.busConfig().useResp()) {
                    spinal.core.package$.MODULE$.assert(spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)DataCarrier$.MODULE$.toImplicit($this.r).resp()).toInt() == 0);
                }
                BigInt data = spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)DataCarrier$.MODULE$.toImplicit($this.r).data()).toBigInt();
                int start = beatAddress.$amp(package$.MODULE$.BigInt().apply(bytePerBeat$3 - 1).unary_$tilde()).$minus(accessAddress).toInt();
                int end = start + bytePerBeat$3;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> $this.onReadByte(accessAddress.$plus(BigInt$.MODULE$.int2bigInt(i)), (byte)(data.$greater$greater(8 * i).toInt() & 0xFF), id$5));
                if ((!$this.busConfig().useLast() || !spinal.core.sim.package$.MODULE$.SimBoolPimper(DataCarrier$.MODULE$.toImplicit($this.r).last()).toBoolean()) && beat != len$6) break block2;
                $this.onLast(id$5);
            }
        });
    }

    public static final /* synthetic */ void $anonfun$arMonitor$5(Axi4ReadOnlyMonitor $this, Axi4Ar x$13) {
        int size = $this.busConfig().useSize() ? spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).size()).toInt() : log2Up$.MODULE$.apply($this.busConfig().dataWidth() / 8);
        int len = $this.busConfig().useLen() ? spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).len()).toInt() : 0;
        int id = $this.busConfig().useId() ? spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).id()).toInt() : 0;
        int burst = $this.busConfig().useBurst() ? spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).burst()).toInt() : 1;
        BigInt addr = spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).addr()).toBigInt();
        int bytePerBeat = 1 << size;
        int bytes = (len + 1) * bytePerBeat;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable & scala.Serializable)beat -> Axi4ReadOnlyMonitor.$anonfun$arMonitor$6($this, burst, addr, bytePerBeat, bytes, len, id, BoxesRunTime.unboxToInt((Object)beat)));
    }

    public static final /* synthetic */ void $anonfun$rMonitor$1(Axi4ReadOnlyMonitor $this, Axi4R r) {
        ((Function0)$this.rQueue().dequeue()).apply$mcV$sp();
    }

    public Axi4ReadOnlyMonitor(Stream<Axi4Ar> ar, Stream<Axi4R> r2, ClockDomain clockDomain) {
        this.ar = ar;
        this.r = r2;
        this.busConfig = ((Axi4Ax)DataCarrier$.MODULE$.toImplicit(ar)).config();
        if (!this.busConfig().useLen()) {
            SpinalWarning$.MODULE$.apply("The Axi4Config with useLen == false is only tested by assigning len = 0, determine the burst length of transcation by last signal should not work.");
        }
        this.rQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.arMonitor = StreamMonitor$.MODULE$.apply(ar, clockDomain, (Function1 & Serializable & scala.Serializable)x$13 -> {
            Axi4ReadOnlyMonitor.$anonfun$arMonitor$5(this, x$13);
            return BoxedUnit.UNIT;
        });
        this.rMonitor = StreamMonitor$.MODULE$.apply(r2, clockDomain, (Function1 & Serializable & scala.Serializable)r -> {
            Axi4ReadOnlyMonitor.$anonfun$rMonitor$1(this, r);
            return BoxedUnit.UNIT;
        });
    }

    public Axi4ReadOnlyMonitor(Axi4ReadOnly bus, ClockDomain clockDomain) {
        this(bus.ar(), bus.r(), clockDomain);
    }

    public Axi4ReadOnlyMonitor(Axi4 bus, ClockDomain clockDomain) {
        this(bus.ar(), bus.r(), clockDomain);
    }
}

