/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.bus.amba4.axi.sim;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import spinal.core.BitVector;
import spinal.core.ClockDomain;
import spinal.core.SpinalWarning$;
import spinal.core.log2Up$;
import spinal.lib.DataCarrier$;
import spinal.lib.Stream;
import spinal.lib.bus.amba4.axi.Axi4;
import spinal.lib.bus.amba4.axi.Axi4Ar;
import spinal.lib.bus.amba4.axi.Axi4Ax;
import spinal.lib.bus.amba4.axi.Axi4Config;
import spinal.lib.bus.amba4.axi.Axi4R;
import spinal.lib.bus.amba4.axi.Axi4ReadOnly;
import spinal.lib.bus.misc.SizeMapping;
import spinal.lib.sim.StreamDriver;
import spinal.lib.sim.StreamDriver$;
import spinal.lib.sim.StreamMonitor;
import spinal.lib.sim.StreamMonitor$;
import spinal.lib.sim.StreamReadyRandomizer;
import spinal.lib.sim.StreamReadyRandomizer$;

@ScalaSignature(bytes="\u0006\u0001\u0005]f!B\u0014)\u0003\u0003)\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\u0006#\u0002!\tA\u0015\u0005\u0006#\u0002!\t\u0001\u0017\u0005\u0006#\u0002!\tA\u0018\u0005\bI\u0002\u0011\r\u0011\"\u0001f\u0011\u0019I\u0007\u0001)A\u0005M\"9!\u000e\u0001b\u0001\n\u0003Y\u0007BB8\u0001A\u0003%A\u000eC\u0004q\u0001\t\u0007I\u0011A9\t\u000f\u0005\u0005\u0001\u0001)A\u0005e\"A\u00111\u0001\u0001C\u0002\u0013\u0005Q\rC\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u00024\t\u0013\u0005\u001d\u0001A1A\u0005\u0002\u0005%\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0003\t\u0013\u0005M\u0001\u00011A\u0005\u0002\u0005U\u0001\"CA\u000f\u0001\u0001\u0007I\u0011AA\u0010\u0011!\t)\u0003\u0001Q!\n\u0005]\u0001\u0002CA\u0014\u0001\u0001\u0007I\u0011A3\t\u0013\u0005%\u0002\u00011A\u0005\u0002\u0005-\u0002bBA\u0018\u0001\u0001\u0006KA\u001a\u0005\b\u0003c\u0001a\u0011AA\u001a\u0011\u001d\ti\u0005\u0001D\u0001\u0003\u001fBq!!\u0019\u0001\r\u0003\t\u0019\u0007C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005%\u0004bBAB\u0001\u0011\u0005\u0011Q\u0003\u0005\n\u0003\u000b\u0003!\u0019!C\u0001\u0003\u000fC\u0001\"a%\u0001A\u0003%\u0011\u0011\u0012\u0005\b\u0003+\u0003A\u0011AAL\u0011\u001d\tI\n\u0001C\u0001\u00037C\u0011\"!(\u0001\u0005\u0004%\t!a(\t\u0011\u0005\u001d\u0006\u0001)A\u0005\u0003CC\u0011\"!+\u0001\u0005\u0004%\t!a+\t\u0011\u0005M\u0006\u0001)A\u0005\u0003[Cq!!.\u0001\t\u0003\t9JA\fBq&$$+Z1e\u001f:d\u00170T1ti\u0016\u0014\u0018iZ3oi*\u0011\u0011FK\u0001\u0004g&l'BA\u0016-\u0003\r\t\u00070\u001b\u0006\u0003[9\nQ!Y7cCRR!a\f\u0019\u0002\u0007\t,8O\u0003\u00022e\u0005\u0019A.\u001b2\u000b\u0003M\naa\u001d9j]\u0006d7\u0001A\n\u0003\u0001Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012a!\u00118z%\u00164\u0017AA1s!\rqt(Q\u0007\u0002a%\u0011\u0001\t\r\u0002\u0007'R\u0014X-Y7\u0011\u0005\t\u001bU\"\u0001\u0016\n\u0005\u0011S#AB!ySR\n%/A\u0001s!\rqth\u0012\t\u0003\u0005\"K!!\u0013\u0016\u0003\u000b\u0005C\u0018\u000e\u000e*\u0002\u0017\rdwnY6E_6\f\u0017N\u001c\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dJ\nAaY8sK&\u0011\u0001+\u0014\u0002\f\u00072|7m\u001b#p[\u0006Lg.\u0001\u0004=S:LGO\u0010\u000b\u0005'V3v\u000b\u0005\u0002U\u00015\t\u0001\u0006C\u0003=\t\u0001\u0007Q\bC\u0003F\t\u0001\u0007a\tC\u0003K\t\u0001\u00071\nF\u0002T3vCQaL\u0003A\u0002i\u0003\"AQ.\n\u0005qS#\u0001D!ySR\u0012V-\u00193P]2L\b\"\u0002&\u0006\u0001\u0004YEcA*`G\")qF\u0002a\u0001AB\u0011!)Y\u0005\u0003E*\u0012A!\u0011=ji!)!J\u0002a\u0001\u0017\u0006i\u0001/Y4f\u00032LwM\u001c\"jiN,\u0012A\u001a\t\u0003o\u001dL!\u0001\u001b\u001d\u0003\u0007%sG/\u0001\bqC\u001e,\u0017\t\\5h]\nKGo\u001d\u0011\u0002\u0013\t,8oQ8oM&<W#\u00017\u0011\u0005\tk\u0017B\u00018+\u0005)\t\u00050\u001b\u001bD_:4\u0017nZ\u0001\u000bEV\u001c8i\u001c8gS\u001e\u0004\u0013aB1s#V,W/Z\u000b\u0002eB\u00191\u000f\u001f>\u000e\u0003QT!!\u001e<\u0002\u000f5,H/\u00192mK*\u0011q\u000fO\u0001\u000bG>dG.Z2uS>t\u0017BA=u\u0005\u0015\tV/Z;f!\r940`\u0005\u0003yb\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005]r\u0018BA@9\u0005\u0011)f.\u001b;\u0002\u0011\u0005\u0014\u0018+^3vK\u0002\nq!\u001b3D_VtG/\u0001\u0005jI\u000e{WO\u001c;!\u0003\u0019\u0011\u0018+^3vKV\u0011\u00111\u0002\t\u0005o\u00055!/C\u0002\u0002\u0010a\u0012Q!\u0011:sCf\fqA])vKV,\u0007%\u0001\u0005bY2|woR3o+\t\t9\u0002E\u00028\u00033I1!a\u00079\u0005\u001d\u0011un\u001c7fC:\fA\"\u00197m_^<UM\\0%KF$2!`A\u0011\u0011%\t\u0019CEA\u0001\u0002\u0004\t9\"A\u0002yIE\n\u0011\"\u00197m_^<UM\u001c\u0011\u0002\u0015I\u001c\boQ8v]R,'/\u0001\bsgB\u001cu.\u001e8uKJ|F%Z9\u0015\u0007u\fi\u0003\u0003\u0005\u0002$U\t\t\u00111\u0001g\u0003-\u00118\u000f]\"pk:$XM\u001d\u0011\u0002\u0015\u001d,g.\u00113ee\u0016\u001c8\u000f\u0006\u0002\u00026A!\u0011qGA$\u001d\u0011\tI$a\u0011\u000f\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u00105\u0003\u0019a$o\\8u}%\t\u0011(C\u0002\u0002Fa\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002J\u0005-#A\u0002\"jO&sGOC\u0002\u0002Fa\nq\"\\1qa&tw-\u00117m_\u000e\fG/\u001a\u000b\u0005\u0003/\t\t\u0006C\u0004\u0002Ta\u0001\r!!\u0016\u0002\u000f5\f\u0007\u000f]5oOB!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\9\nA!\\5tG&!\u0011qLA-\u0005-\u0019\u0016N_3NCB\u0004\u0018N\\4\u0002\u00175\f\u0007\u000f]5oO\u001a\u0013X-\u001a\u000b\u0004{\u0006\u0015\u0004bBA*3\u0001\u0007\u0011QK\u0001\u0007EV\u00148\u000f^:\u0016\u0005\u0005-\u0004#BA7\u0003g2WBAA8\u0015\r\t\tH^\u0001\nS6lW\u000f^1cY\u0016LA!!\u001e\u0002p\t!A*[:u\u0003\u0015\u0019\u0018N_3t+\t\tY\bE\u0003\u0002~\u0005}dMD\u00028\u0003\u0007JA!!\u001e\u0002L\u0005!A.\u001a8t\u0003\u001d\u0001XM\u001c3j]\u001e\fqA\u001d#sSZ,'/\u0006\u0002\u0002\nB)\u00111RAH\u000f6\u0011\u0011Q\u0012\u0006\u0003SAJA!!%\u0002\u000e\n)2\u000b\u001e:fC6\u0014V-\u00193z%\u0006tGm\\7ju\u0016\u0014\u0018\u0001\u0003:Ee&4XM\u001d\u0011\u0002\r\u001d,gnQ7e)\u0005i\u0018AC7bg.\u0014\u0016M\u001c3p[R\u0011\u0011qC\u0001\tCJ$%/\u001b<feV\u0011\u0011\u0011\u0015\t\u0006\u0003\u0017\u000b\u0019+Q\u0005\u0005\u0003K\u000biI\u0001\u0007TiJ,\u0017-\u001c#sSZ,'/A\u0005be\u0012\u0013\u0018N^3sA\u0005Q!o\u001d9N_:LGo\u001c:\u0016\u0005\u00055\u0006#BAF\u0003_;\u0015\u0002BAY\u0003\u001b\u0013Qb\u0015;sK\u0006lWj\u001c8ji>\u0014\u0018a\u0003:ta6{g.\u001b;pe\u0002\nQA]3tKR\u0004")
public abstract class Axi4ReadOnlyMasterAgent {
    private final Stream<Axi4Ar> ar;
    private final Stream<Axi4R> r;
    private final int pageAlignBits;
    private final Axi4Config busConfig;
    private final Queue<Function0<BoxedUnit>> arQueue;
    private final int idCount;
    private final Queue<Function0<BoxedUnit>>[] rQueue;
    private boolean allowGen;
    private int rspCounter;
    private final StreamReadyRandomizer<Axi4R> rDriver;
    private final StreamDriver<Axi4Ar> arDriver;
    private final StreamMonitor<Axi4R> rspMonitor;

    public int pageAlignBits() {
        return this.pageAlignBits;
    }

    public Axi4Config busConfig() {
        return this.busConfig;
    }

    public Queue<Function0<BoxedUnit>> arQueue() {
        return this.arQueue;
    }

    public int idCount() {
        return this.idCount;
    }

    public Queue<Function0<BoxedUnit>>[] rQueue() {
        return this.rQueue;
    }

    public boolean allowGen() {
        return this.allowGen;
    }

    public void allowGen_$eq(boolean x$1) {
        this.allowGen = x$1;
    }

    public int rspCounter() {
        return this.rspCounter;
    }

    public void rspCounter_$eq(int x$1) {
        this.rspCounter = x$1;
    }

    public abstract BigInt genAddress();

    public abstract boolean mappingAllocate(SizeMapping var1);

    public abstract void mappingFree(SizeMapping var1);

    public List<Object> bursts() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
    }

    public List<Object> sizes() {
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), log2Up$.MODULE$.apply(this.busConfig().bytePerWord())).toList();
    }

    public List<Object> lens() {
        return (List)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 64).toList().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{255})), List$.MODULE$.canBuildFrom());
    }

    public boolean pending() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.rQueue())).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.nonEmpty()));
    }

    public StreamReadyRandomizer<Axi4R> rDriver() {
        return this.rDriver;
    }

    public void genCmd() {
        if (!this.allowGen()) {
            return;
        }
        int region = this.busConfig().useRegion() ? spinal.core.sim.package$.MODULE$.SimBitsPimper(((Axi4Ax)DataCarrier$.MODULE$.toImplicit(this.ar)).region()).randomizedInt() : 0;
        int id = this.busConfig().useId() ? spinal.core.sim.package$.MODULE$.SimUIntPimper(((Axi4Ax)DataCarrier$.MODULE$.toImplicit(this.ar)).id()).randomizedInt() : 0;
        int burst = this.busConfig().useBurst() ? BoxesRunTime.unboxToInt((Object)this.bursts().apply(Random$.MODULE$.nextInt(this.bursts().size()))) : 1;
        IntRef len = IntRef.create((int)0);
        IntRef size = IntRef.create((int)log2Up$.MODULE$.apply(this.busConfig().bytePerWord()));
        int sizeByte = this.busConfig().bytePerWord();
        ObjectRef mapping = ObjectRef.create(null);
        ObjectRef address = ObjectRef.create(null);
        BigInt startAddress = null;
        BigInt endAddress = null;
        boolean addrValid = false;
        do {
            if (this.busConfig().useLen()) {
                int n;
                int n2 = burst;
                switch (n2) {
                    case 0: {
                        n = Random$.MODULE$.nextInt(16);
                        break;
                    }
                    case 1: {
                        n = BoxesRunTime.unboxToInt((Object)this.lens().apply(Random$.MODULE$.nextInt(this.lens().size())));
                        break;
                    }
                    case 2: {
                        n = BoxesRunTime.unboxToInt((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 8, 16})).apply(Random$.MODULE$.nextInt(4))) - 1;
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
                    }
                }
                len.elem = n;
            }
            int lenBeat = len.elem + 1;
            if (this.busConfig().useSize()) {
                size.elem = BoxesRunTime.unboxToInt((Object)this.sizes().apply(Random$.MODULE$.nextInt(this.sizes().size())));
            }
            sizeByte = 1 << size.elem;
            int byteCount = sizeByte * lenBeat;
            address.elem = this.genAddress();
            BigInt boundAddress = ((BigInt)address.elem).$greater$greater(this.pageAlignBits()).$plus(BigInt$.MODULE$.int2bigInt(1)).$less$less(this.pageAlignBits());
            int n = burst;
            switch (n) {
                case 0: {
                    startAddress = (BigInt)address.elem;
                    endAddress = startAddress.$plus(BigInt$.MODULE$.int2bigInt(sizeByte));
                    break;
                }
                case 1: {
                    startAddress = (BigInt)address.elem;
                    endAddress = startAddress.$plus(BigInt$.MODULE$.int2bigInt(byteCount));
                    break;
                }
                case 2: {
                    address.elem = ((BigInt)address.elem).$amp(package$.MODULE$.BigInt().apply(sizeByte - 1).unary_$tilde());
                    startAddress = ((BigInt)address.elem).$amp(BigInt$.MODULE$.int2bigInt(~(byteCount - 1)));
                    endAddress = startAddress.$plus(BigInt$.MODULE$.int2bigInt(byteCount));
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            endAddress = endAddress.$amp(package$.MODULE$.BigInt().apply(sizeByte - 1).unary_$tilde());
            addrValid = endAddress.$less$eq((Object)boundAddress);
            if (!addrValid) continue;
            mapping.elem = new SizeMapping(startAddress, endAddress.$minus(startAddress));
        } while (!addrValid || !this.mappingAllocate((SizeMapping)mapping.elem));
        this.arQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block9: {
                spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).addr()).$hash$eq((BigInt)address$2.elem);
                if (this.busConfig().useId()) {
                    spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).id()).$hash$eq(id);
                }
                if (this.busConfig().useRegion()) {
                    spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).region()).$hash$eq(region);
                }
                if (this.busConfig().useLen()) {
                    spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).len()).$hash$eq(len$2.elem);
                }
                if (this.busConfig().useSize()) {
                    spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).size()).$hash$eq(size$2.elem);
                }
                if (this.busConfig().useBurst()) {
                    spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).burst()).$hash$eq(burst);
                }
                if (this.busConfig().useLock()) {
                    spinal.core.sim.package$.MODULE$.SimBitsPimper(((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).lock()).randomize();
                }
                if (this.busConfig().useCache()) {
                    spinal.core.sim.package$.MODULE$.SimBitsPimper(((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).cache()).randomize();
                }
                if (this.busConfig().useQos()) {
                    spinal.core.sim.package$.MODULE$.SimBitsPimper(((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).qos()).randomize();
                }
                if (this.busConfig().arUserWidth() >= 0) {
                    spinal.core.sim.package$.MODULE$.SimBitsPimper(((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).user()).randomize();
                }
                if (!this.busConfig().useProt()) break block9;
                spinal.core.sim.package$.MODULE$.SimBitsPimper(((Axi4Ax)DataCarrier$.MODULE$.toImplicit($this.ar)).prot()).randomize();
            }
        }}));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), len.elem).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)beat -> this.rQueue()[id].enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block2: {
                if (this.busConfig().useResp()) {
                    spinal.core.package$.MODULE$.assert(spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)DataCarrier$.MODULE$.toImplicit($this.r).resp()).toInt() == 0);
                }
                if (this.busConfig().useLast()) {
                    spinal.core.package$.MODULE$.assert(spinal.core.sim.package$.MODULE$.SimBoolPimper(DataCarrier$.MODULE$.toImplicit($this.r).last()).toBoolean() == (beat == len$2.elem));
                }
                if ((!this.busConfig().useLast() || !spinal.core.sim.package$.MODULE$.SimBoolPimper(DataCarrier$.MODULE$.toImplicit($this.r).last()).toBoolean()) && beat != len$2.elem) break block2;
                this.mappingFree((SizeMapping)mapping$2.elem);
                this.rspCounter_$eq(this.rspCounter() + 1);
            }
        }})));
    }

    public boolean maskRandom() {
        return Random$.MODULE$.nextBoolean();
    }

    public StreamDriver<Axi4Ar> arDriver() {
        return this.arDriver;
    }

    public StreamMonitor<Axi4R> rspMonitor() {
        return this.rspMonitor;
    }

    public void reset() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.rQueue())).map((Function1 & Serializable & scala.Serializable)q -> {
            q.clear();
            return BoxedUnit.UNIT;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
        this.arQueue().clear();
        this.arDriver().reset();
    }

    public static final /* synthetic */ boolean $anonfun$arDriver$1(Axi4ReadOnlyMasterAgent $this, Axi4Ar x$6) {
        boolean bl;
        if ($this.arQueue().isEmpty()) {
            $this.genCmd();
        }
        if ($this.arQueue().nonEmpty()) {
            ((Function0)$this.arQueue().dequeue()).apply$mcV$sp();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$rspMonitor$2(Axi4ReadOnlyMasterAgent $this, Axi4R x$7) {
        int id = $this.busConfig().useId() ? spinal.core.sim.package$.MODULE$.SimBitVectorPimper((BitVector)DataCarrier$.MODULE$.toImplicit($this.r).id()).toInt() : 0;
        ((Function0)$this.rQueue()[id].dequeue()).apply$mcV$sp();
    }

    public Axi4ReadOnlyMasterAgent(Stream<Axi4Ar> ar, Stream<Axi4R> r, ClockDomain clockDomain) {
        this.ar = ar;
        this.r = r;
        this.pageAlignBits = 12;
        this.busConfig = ((Axi4Ax)DataCarrier$.MODULE$.toImplicit(ar)).config();
        if (!this.busConfig().useLen()) {
            SpinalWarning$.MODULE$.apply("The Axi4Config with useLen == false is only tested by assigning len = 0, determine the burst length of transcation by last signal should not work.");
        }
        this.arQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.idCount = this.busConfig().useId() ? 1 << this.busConfig().idWidth() : 1;
        this.rQueue = (Queue[])Array$.MODULE$.fill(this.idCount(), (Function0 & Serializable & scala.Serializable)() -> (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$), ClassTag$.MODULE$.apply(Queue.class));
        this.allowGen = true;
        this.rspCounter = 0;
        this.rDriver = StreamReadyRandomizer$.MODULE$.apply(r, clockDomain);
        this.arDriver = StreamDriver$.MODULE$.apply(ar, clockDomain, (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Axi4ReadOnlyMasterAgent.$anonfun$arDriver$1(this, x$6)));
        this.rspMonitor = StreamMonitor$.MODULE$.apply(r, clockDomain, (Function1 & Serializable & scala.Serializable)x$7 -> {
            Axi4ReadOnlyMasterAgent.$anonfun$rspMonitor$2(this, x$7);
            return BoxedUnit.UNIT;
        });
    }

    public Axi4ReadOnlyMasterAgent(Axi4ReadOnly bus, ClockDomain clockDomain) {
        this(bus.ar(), bus.r(), clockDomain);
    }

    public Axi4ReadOnlyMasterAgent(Axi4 bus, ClockDomain clockDomain) {
        this(bus.ar(), bus.r(), clockDomain);
    }
}

