/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.memory.sdram.sdr.sim;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import spinal.core.BitVector;
import spinal.core.ClockDomain;
import spinal.core.package;
import spinal.core.sim.package$;
import spinal.lib.memory.sdram.SdramLayout;
import spinal.lib.memory.sdram.sdr.SdramInterface;
import spinal.lib.memory.sdram.sdr.sim.SdramModel$;

@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u001d;\u0001\u001eC\u0001\u0002\u0016\u0001\u0003\u0016\u0004%\t!\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005-\"A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005b\u0001\tE\t\u0015!\u0003^\u0011!\u0011\u0007A!f\u0001\n\u0003\u0019\u0007\u0002\u00036\u0001\u0005#\u0005\u000b\u0011\u00023\t\u000b-\u0004A\u0011\u00017\t\u000fI\u0004\u0001\u0019!C\u0001g\"9q\u000f\u0001a\u0001\n\u0003A\bB\u0002@\u0001A\u0003&A\u000fC\u0004\u0000\u0001\u0001\u0007I\u0011A:\t\u0013\u0005\u0005\u0001\u00011A\u0005\u0002\u0005\r\u0001bBA\u0004\u0001\u0001\u0006K\u0001\u001e\u0005\n\u0003\u0013\u0001!\u0019!C\u0001\u0003\u0017A\u0001\"!\u001b\u0001A\u0003%\u0011Q\u0002\u0005\n\u0003W\u0002\u0001\u0019!C\u0001\u0003[A\u0011\"!\u001c\u0001\u0001\u0004%\t!a\u001c\t\u0011\u0005M\u0004\u0001)Q\u0005\u0003_A\u0011\"!\u001e\u0001\u0005\u0004%\t!a\b\t\u0011\u0005]\u0004\u0001)A\u0005\u0003CAq!a\u0015\u0001\t\u0003\tI\bC\u0004\u0002\u0002\u0002!\t!a!\u0007\r\u0005]\u0001\u0001AA\r\u0011\u0019Yw\u0003\"\u0001\u0002\u001c!I\u0011QD\fC\u0002\u0013\u0005\u0011q\u0004\u0005\t\u0003S9\u0002\u0015!\u0003\u0002\"!I\u00111F\fA\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003k9\u0002\u0019!C\u0001\u0003oA\u0001\"a\u000f\u0018A\u0003&\u0011q\u0006\u0005\t\u0003{9\u0002\u0019!C\u0001g\"I\u0011qH\fA\u0002\u0013\u0005\u0011\u0011\t\u0005\b\u0003\u000b:\u0002\u0015)\u0003u\u0011\u001d\t9e\u0006C\u0001\u0003\u0013Bq!a\u0014\u0018\t\u0003\t\t\u0006C\u0004\u0002T]!\t!!\u0016\t\u000f\u0005\u0005t\u0003\"\u0001\u0002d!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006\"CAU\u0001\u0005\u0005I\u0011AAV\u0011%\t\u0019\fAI\u0001\n\u0003\t)\fC\u0005\u0002L\u0002\t\n\u0011\"\u0001\u0002N\"I\u0011\u0011\u001b\u0001\u0012\u0002\u0013\u0005\u00111\u001b\u0005\n\u0003/\u0004\u0011\u0011!C!\u00033D\u0001\"!;\u0001\u0003\u0003%\ta\u001d\u0005\n\u0003W\u0004\u0011\u0011!C\u0001\u0003[D\u0011\"a>\u0001\u0003\u0003%\t%!?\t\u0013\t\u001d\u0001!!A\u0005\u0002\t%\u0001\"\u0003B\u0007\u0001\u0005\u0005I\u0011\tB\b\u0011%\u0011\t\u0002AA\u0001\n\u0003\u0012\u0019\u0002C\u0005\u0003\u0016\u0001\t\t\u0011\"\u0011\u0003\u0018\u001dI!1\u0004\u001e\u0002\u0002#\u0005!Q\u0004\u0004\tsi\n\t\u0011#\u0001\u0003 !11n\rC\u0001\u0005[A\u0011B!\u00054\u0003\u0003%)Ea\u0005\t\u0013\t=2'!A\u0005\u0002\nE\u0002\"\u0003B\u001dg\u0005\u0005I\u0011\u0011B\u001e\u0011%\u0011ieMA\u0001\n\u0013\u0011yE\u0001\u0006TIJ\fW.T8eK2T!a\u000f\u001f\u0002\u0007MLWN\u0003\u0002>}\u0005\u00191\u000f\u001a:\u000b\u0005}\u0002\u0015!B:ee\u0006l'BA!C\u0003\u0019iW-\\8ss*\u00111\tR\u0001\u0004Y&\u0014'\"A#\u0002\rM\u0004\u0018N\\1m\u0007\u0001\u0019B\u0001\u0001%O#B\u0011\u0011\nT\u0007\u0002\u0015*\t1*A\u0003tG\u0006d\u0017-\u0003\u0002N\u0015\n1\u0011I\\=SK\u001a\u0004\"!S(\n\u0005AS%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0013JK!a\u0015&\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0005%|W#\u0001,\u0011\u0005]CV\"\u0001\u001f\n\u0005ec$AD*ee\u0006l\u0017J\u001c;fe\u001a\f7-Z\u0001\u0004S>\u0004\u0013A\u00027bs>,H/F\u0001^!\tqv,D\u0001?\u0013\t\u0001gHA\u0006TIJ\fW\u000eT1z_V$\u0018a\u00027bs>,H\u000fI\u0001\fG2|7m\u001b#p[\u0006Lg.F\u0001e!\t)\u0007.D\u0001g\u0015\t9G)\u0001\u0003d_J,\u0017BA5g\u0005-\u0019En\\2l\t>l\u0017-\u001b8\u0002\u0019\rdwnY6E_6\f\u0017N\u001c\u0011\u0002\rqJg.\u001b;?)\u0011iw\u000e]9\u0011\u00059\u0004Q\"\u0001\u001e\t\u000bQ;\u0001\u0019\u0001,\t\u000bm;\u0001\u0019A/\t\u000b\t<\u0001\u0019\u00013\u0002\u0007\r\u000b5+F\u0001u!\tIU/\u0003\u0002w\u0015\n\u0019\u0011J\u001c;\u0002\u000f\r\u000b5k\u0018\u0013fcR\u0011\u0011\u0010 \t\u0003\u0013jL!a\u001f&\u0003\tUs\u0017\u000e\u001e\u0005\b{&\t\t\u00111\u0001u\u0003\rAH%M\u0001\u0005\u0007\u0006\u001b\u0006%A\u0006ckJ\u001cH\u000fT3oORD\u0017a\u00042veN$H*\u001a8hi\"|F%Z9\u0015\u0007e\f)\u0001C\u0004~\u0019\u0005\u0005\t\u0019\u0001;\u0002\u0019\t,(o\u001d;MK:<G\u000f\u001b\u0011\u0002\u000b\t\fgn[:\u0016\u0005\u00055\u0001#B%\u0002\u0010\u0005M\u0011bAA\t\u0015\n)\u0011I\u001d:bsB\u0019\u0011QC\f\u000e\u0003\u0001\u0011AAQ1oWN\u0011q\u0003\u0013\u000b\u0003\u0003'\tA\u0001Z1uCV\u0011\u0011\u0011\u0005\t\u0006\u0013\u0006=\u00111\u0005\t\u0004\u0013\u0006\u0015\u0012bAA\u0014\u0015\n!!)\u001f;f\u0003\u0015!\u0017\r^1!\u0003\u0019y\u0007/\u001a8fIV\u0011\u0011q\u0006\t\u0004\u0013\u0006E\u0012bAA\u001a\u0015\n9!i\\8mK\u0006t\u0017AC8qK:,Gm\u0018\u0013fcR\u0019\u00110!\u000f\t\u0011ud\u0012\u0011!a\u0001\u0003_\tqa\u001c9f]\u0016$\u0007%A\u0005pa\u0016tW\r\u001a*po\u0006iq\u000e]3oK\u0012\u0014vn^0%KF$2!_A\"\u0011\u001dix$!AA\u0002Q\f!b\u001c9f]\u0016$'k\\<!\u0003!\t7\r^5wCR,GcA=\u0002L!1\u0011QJ\u0011A\u0002Q\f1A]8x\u0003%\u0001(/Z2iCJ<W\rF\u0001z\u0003\u00159(/\u001b;f)\u001dI\u0018qKA.\u0003?Ba!!\u0017$\u0001\u0004!\u0018AB2pYVlg\u000e\u0003\u0004\u0002^\r\u0002\r\u0001^\u0001\u0007Ef$X-\u00133\t\u000f\u0005u1\u00051\u0001\u0002$\u0005!!/Z1e)\u0019\t\u0019#!\u001a\u0002h!1\u0011\u0011\f\u0013A\u0002QDa!!\u0018%\u0001\u0004!\u0018A\u00022b].\u001c\b%A\u0004dW\u0016d\u0015m\u001d;\u0002\u0017\r\\W\rT1ti~#S-\u001d\u000b\u0004s\u0006E\u0004\u0002C?\u0012\u0003\u0003\u0005\r!a\f\u0002\u0011\r\\W\rT1ti\u0002\n1B]3bINC\u0017N\u001a;fe\u0006a!/Z1e'\"Lg\r^3sAQ)\u00110a\u001f\u0002\u0000!1\u0011QP\u000bA\u0002Q\fq!\u00193ee\u0016\u001c8\u000fC\u0004\u0002\u001eU\u0001\r!a\t\u0002\u000f1|\u0017\r\u001a\"j]R)\u00110!\"\u0002\b\"1\u0011Q\u0010\fA\u0002QDq!!#\u0017\u0001\u0004\tY)\u0001\u0003qCRD\u0007\u0003BAG\u00037sA!a$\u0002\u0018B\u0019\u0011\u0011\u0013&\u000e\u0005\u0005M%bAAK\r\u00061AH]8pizJ1!!'K\u0003\u0019\u0001&/\u001a3fM&!\u0011QTAP\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0014&\u0002\rI,\u0007o\u001c:u)\rI\u0018Q\u0015\u0005\b\u0003O+\u0003\u0019AAF\u0003\ri7oZ\u0001\u0005G>\u0004\u0018\u0010F\u0004n\u0003[\u000by+!-\t\u000fQ3\u0003\u0013!a\u0001-\"91L\nI\u0001\u0002\u0004i\u0006b\u00022'!\u0003\u0005\r\u0001Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9LK\u0002W\u0003s[#!a/\u0011\t\u0005u\u0016qY\u0007\u0003\u0003\u007fSA!!1\u0002D\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000bT\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011ZA`\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyMK\u0002^\u0003s\u000babY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002V*\u001aA-!/\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u000e\u0005\u0003\u0002^\u0006\u001dXBAAp\u0015\u0011\t\t/a9\u0002\t1\fgn\u001a\u0006\u0003\u0003K\fAA[1wC&!\u0011QTAp\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a<\u0002vB\u0019\u0011*!=\n\u0007\u0005M(JA\u0002B]fDq! \u0017\u0002\u0002\u0003\u0007A/A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u0010\u0005\u0004\u0002~\n\r\u0011q^\u0007\u0003\u0003\u007fT1A!\u0001K\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000b\tyP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0018\u0005\u0017A\u0001\" \u0018\u0002\u0002\u0003\u0007\u0011q^\u0001\tQ\u0006\u001c\bnQ8eKR\tA/\u0001\u0005u_N#(/\u001b8h)\t\tY.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003_\u0011I\u0002\u0003\u0005~c\u0005\u0005\t\u0019AAx\u0003)\u0019FM]1n\u001b>$W\r\u001c\t\u0003]N\u001aBa\rB\u0011#BA!1\u0005B\u0015-v#W.\u0004\u0002\u0003&)\u0019!q\u0005&\u0002\u000fI,h\u000e^5nK&!!1\u0006B\u0013\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005;\tQ!\u00199qYf$r!\u001cB\u001a\u0005k\u00119\u0004C\u0003Um\u0001\u0007a\u000bC\u0003\\m\u0001\u0007Q\fC\u0003cm\u0001\u0007A-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu\"\u0011\n\t\u0006\u0013\n}\"1I\u0005\u0004\u0005\u0003R%AB(qi&|g\u000e\u0005\u0004J\u0005\u000b2V\fZ\u0005\u0004\u0005\u000fR%A\u0002+va2,7\u0007\u0003\u0005\u0003L]\n\t\u00111\u0001n\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003RA!\u0011Q\u001cB*\u0013\u0011\u0011)&a8\u0003\r=\u0013'.Z2u\u0001")
public class SdramModel
implements Product,
scala.Serializable {
    private final SdramInterface io;
    private final SdramLayout layout;
    private final ClockDomain clockDomain;
    private int CAS;
    private int burstLength;
    private final Bank[] banks;
    private boolean ckeLast;
    private final byte[] readShifter;

    public static Option<Tuple3<SdramInterface, SdramLayout, ClockDomain>> unapply(SdramModel sdramModel) {
        return SdramModel$.MODULE$.unapply(sdramModel);
    }

    public static SdramModel apply(SdramInterface sdramInterface, SdramLayout sdramLayout, ClockDomain clockDomain) {
        return SdramModel$.MODULE$.apply(sdramInterface, sdramLayout, clockDomain);
    }

    public static Function1<Tuple3<SdramInterface, SdramLayout, ClockDomain>, SdramModel> tupled() {
        return SdramModel$.MODULE$.tupled();
    }

    public static Function1<SdramInterface, Function1<SdramLayout, Function1<ClockDomain, SdramModel>>> curried() {
        return SdramModel$.MODULE$.curried();
    }

    public SdramInterface io() {
        return this.io;
    }

    public SdramLayout layout() {
        return this.layout;
    }

    public ClockDomain clockDomain() {
        return this.clockDomain;
    }

    public int CAS() {
        return this.CAS;
    }

    public void CAS_$eq(int x$1) {
        this.CAS = x$1;
    }

    public int burstLength() {
        return this.burstLength;
    }

    public void burstLength_$eq(int x$1) {
        this.burstLength = x$1;
    }

    public Bank[] banks() {
        return this.banks;
    }

    public boolean ckeLast() {
        return this.ckeLast;
    }

    public void ckeLast_$eq(boolean x$1) {
        this.ckeLast = x$1;
    }

    public byte[] readShifter() {
        return this.readShifter;
    }

    public void write(int address, byte data) {
        int byteId = address & this.layout().bytePerWord() - 1;
        int word = address / this.layout().bytePerWord();
        int row = word >> this.layout().columnWidth() + this.layout().bankWidth();
        int bank = word >> this.layout().columnWidth() & this.layout().bankCount() - 1;
        int col = word & this.layout().columnSize() - 1;
        this.banks()[bank].data()[(col + row * this.layout().columnSize()) * this.layout().bytePerWord() + byteId] = data;
    }

    public void loadBin(int address, String path) {
        byte[] bin = Files.readAllBytes(Paths.get(path, new String[0]));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bin)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SdramModel.$anonfun$loadBin$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            SdramModel.$anonfun$loadBin$2(this, address, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void report(String msg) {
        Predef$.MODULE$.println((Object)new StringBuilder(1).append(package$.MODULE$.simTime()).append(" ").append(msg).toString());
    }

    public SdramModel copy(SdramInterface io, SdramLayout layout, ClockDomain clockDomain) {
        return new SdramModel(io, layout, clockDomain);
    }

    public SdramInterface copy$default$1() {
        return this.io();
    }

    public SdramLayout copy$default$2() {
        return this.layout();
    }

    public ClockDomain copy$default$3() {
        return this.clockDomain();
    }

    public String productPrefix() {
        return "SdramModel";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Product product;
        int n = x$1;
        switch (n) {
            case 0: {
                product = this.io();
                break;
            }
            case 1: {
                product = this.layout();
                break;
            }
            case 2: {
                product = this.clockDomain();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return product;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SdramModel;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SdramModel)) return false;
        boolean bl = true;
        if (!bl) return false;
        SdramModel sdramModel = (SdramModel)x$1;
        SdramInterface sdramInterface = this.io();
        SdramInterface sdramInterface2 = sdramModel.io();
        if (sdramInterface == null) {
            if (sdramInterface2 != null) {
                return false;
            }
        } else if (!sdramInterface.equals(sdramInterface2)) return false;
        SdramLayout sdramLayout = this.layout();
        SdramLayout sdramLayout2 = sdramModel.layout();
        if (sdramLayout == null) {
            if (sdramLayout2 != null) {
                return false;
            }
        } else if (!((Object)sdramLayout).equals(sdramLayout2)) return false;
        ClockDomain clockDomain = this.clockDomain();
        ClockDomain clockDomain2 = sdramModel.clockDomain();
        if (clockDomain == null) {
            if (clockDomain2 != null) {
                return false;
            }
        } else if (!clockDomain.equals(clockDomain2)) return false;
        if (!sdramModel.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$loadBin$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$loadBin$2(SdramModel $this, int address$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte v = BoxesRunTime.unboxToByte((Object)tuple2._1());
        int i = tuple2._2$mcI$sp();
        $this.write(i + address$1, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SdramModel(SdramInterface io, SdramLayout layout, ClockDomain clockDomain) {
        this.io = io;
        this.layout = layout;
        this.clockDomain = clockDomain;
        Product.$init$((Product)this);
        this.CAS = 0;
        this.burstLength = 0;
        this.banks = (Bank[])Array$.MODULE$.fill(layout.bankCount(), (Function0 & Serializable & scala.Serializable)() -> new Bank(), ClassTag$.MODULE$.apply(Bank.class));
        this.ckeLast = false;
        this.readShifter = new byte[layout.bankCount() * 3];
        package$.MODULE$.SimClockDomainPimper(clockDomain).onSamplings((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block16: {
                if (!package$.MODULE$.SimBoolPimper(this.io().CSn()).toBoolean() && this.ckeLast()) {
                    int code = (package$.MODULE$.SimBoolPimper(this.io().RASn()).toBoolean() ? 4 : 0) | (package$.MODULE$.SimBoolPimper(this.io().CASn()).toBoolean() ? 2 : 0) | (package$.MODULE$.SimBoolPimper(this.io().WEn()).toBoolean() ? 1 : 0);
                    int ba = package$.MODULE$.SimBitVectorPimper((BitVector)this.io().BA()).toInt();
                    int addr = package$.MODULE$.SimBitVectorPimper((BitVector)this.io().ADDR()).toInt();
                    int n = code;
                    switch (n) {
                        case 0: {
                            if (ba != 0 || (addr & 0x400) != 0) break;
                            this.CAS_$eq(addr >> 4 & 7);
                            this.burstLength_$eq(addr >> 0 & 7);
                            if ((addr & 0x388) != 0) {
                                this.report("SDRAM : ???");
                            }
                            Predef$.MODULE$.printf("SDRAM : MODE REGISTER DEFINITION CAS=%d burstLength=%d\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.CAS()), BoxesRunTime.boxToInteger((int)this.burstLength())}));
                            break;
                        }
                        case 2: {
                            if ((addr & 0x400) != 0) {
                                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.layout().bankCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bankId -> this.banks()[bankId].precharge());
                                break;
                            }
                            this.banks()[ba].precharge();
                            break;
                        }
                        case 3: {
                            this.banks()[ba].activate(addr);
                            break;
                        }
                        case 4: {
                            if ((addr & 0x400) != 0) {
                                this.report("SDRAM : Write autoprecharge not supported");
                            }
                            if (package$.MODULE$.SimBitVectorPimper((BitVector)this.io().DQ().writeEnable()).toLong() == 0L) {
                                this.report("SDRAM : Write Wrong DQ direction");
                            }
                            long dqWrite = package$.MODULE$.SimBitVectorPimper((BitVector)this.io().DQ().write()).toLong();
                            int dqm = package$.MODULE$.SimBitVectorPimper((BitVector)this.io().DQM()).toInt();
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.layout().bytePerWord()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)byteId -> {
                                block0: {
                                    if ((dqm >> byteId & 1) != 0) break block0;
                                    this.banks()[ba].write(addr, byteId, (byte)(dqWrite >> byteId * 8));
                                }
                            });
                            break;
                        }
                        case 5: {
                            if ((addr & 0x400) != 0) {
                                this.report("SDRAM : READ autoprecharge not supported");
                            }
                            if (package$.MODULE$.SimBitVectorPimper((BitVector)this.io().DQ().writeEnable()).toLong() != 0L) {
                                this.report("SDRAM : READ Wrong DQ direction");
                            }
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.layout().bytePerWord()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)byteId -> {
                                $this.readShifter()[byteId] = this.banks()[ba].read(addr, byteId);
                            });
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 7: {
                            break;
                        }
                        default: {
                            this.report("SDRAM : unknown code");
                            break;
                        }
                    }
                }
                this.ckeLast_$eq(package$.MODULE$.SimBoolPimper(this.io().CKE()).toBoolean());
                if (this.CAS() < 2 || this.CAS() > 3) break block16;
                LongRef readData = LongRef.create((long)0L);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.layout().bankCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)byteId -> readData$1.elem |= (long)(this.readShifter()[byteId + (this.CAS() - 1) * this.layout().bytePerWord()] & 0xFF) << byteId * 8);
                package$.MODULE$.SimBitVectorPimper((BitVector)this.io().DQ().read()).$hash$eq(readData.elem);
                package.IntBuilder$.MODULE$.downto$extension(spinal.core.package$.MODULE$.IntToBuilder(this.CAS() - 1), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)latency -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.layout().bytePerWord()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)byteId -> {
                    $this.readShifter()[byteId + latency$1 * $this.layout().bytePerWord()] = this.readShifter()[byteId + (latency - 1) * this.layout().bytePerWord()];
                }));
            }
        });
    }

    public class Bank {
        private final byte[] data;
        private boolean opened;
        private int openedRow;

        public byte[] data() {
            return this.data;
        }

        public boolean opened() {
            return this.opened;
        }

        public void opened_$eq(boolean x$1) {
            this.opened = x$1;
        }

        public int openedRow() {
            return this.openedRow;
        }

        public void openedRow_$eq(int x$1) {
            this.openedRow = x$1;
        }

        public void activate(int row) {
            if (this.opened()) {
                this.spinal$lib$memory$sdram$sdr$sim$SdramModel$Bank$$$outer().report("SDRAM error open unclosed bank");
            }
            this.openedRow_$eq(row);
            this.opened_$eq(true);
        }

        public void precharge() {
            this.opened_$eq(false);
        }

        public void write(int column, int byteId, byte data) {
            if (!this.opened()) {
                this.spinal$lib$memory$sdram$sdr$sim$SdramModel$Bank$$$outer().report("SDRAM : write in closed bank");
            }
            int addr = byteId + (column + this.openedRow() * this.spinal$lib$memory$sdram$sdr$sim$SdramModel$Bank$$$outer().layout().columnSize()) * this.spinal$lib$memory$sdram$sdr$sim$SdramModel$Bank$$$outer().layout().bytePerWord();
            this.data()[addr] = data;
        }

        public byte read(int column, int byteId) {
            if (!this.opened()) {
                this.spinal$lib$memory$sdram$sdr$sim$SdramModel$Bank$$$outer().report("SDRAM : read in closed bank");
            }
            int addr = byteId + (column + this.openedRow() * this.spinal$lib$memory$sdram$sdr$sim$SdramModel$Bank$$$outer().layout().columnSize()) * this.spinal$lib$memory$sdram$sdr$sim$SdramModel$Bank$$$outer().layout().bytePerWord();
            return this.data()[addr];
        }

        public /* synthetic */ SdramModel spinal$lib$memory$sdram$sdr$sim$SdramModel$Bank$$$outer() {
            return SdramModel.this;
        }

        public Bank() {
            if (SdramModel.this == null) {
                throw null;
            }
            this.data = new byte[SdramModel.this.layout().capacity().toInt() / SdramModel.this.layout().bankCount()];
            this.opened = false;
            this.openedRow = 0;
        }
    }
}

