/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.eda.xilinx;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.BigDecimal$;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;
import scala.util.matching.Regex;
import spinal.core.HertzNumber;
import spinal.core.TimeNumber;
import spinal.core.package;
import spinal.core.package$;
import spinal.lib.eda.bench.Report;

public final class VivadoFlow$ {
    public static VivadoFlow$ MODULE$;
    private final boolean isWindows;

    static {
        new VivadoFlow$();
    }

    public void doCmd(String cmd) {
        Predef$.MODULE$.println((Object)cmd);
        if (this.isWindows()) {
            Process$.MODULE$.apply(new StringBuilder(7).append("cmd /C ").append(cmd).toString()).$bang();
        } else {
            Process$.MODULE$.apply(cmd).$bang();
        }
    }

    public void doCmd(String cmd, String path) {
        Predef$.MODULE$.println((Object)cmd);
        if (this.isWindows()) {
            Process$.MODULE$.apply(new StringBuilder(7).append("cmd /C ").append(cmd).toString(), new File(path), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        } else {
            Process$.MODULE$.apply(cmd, new File(path), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang();
        }
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public Report apply(String vivadoPath, String workspacePath, String toplevelPath, String family, String device, HertzNumber frequencyTarget, int processorCount) {
        String projectName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toplevelPath.split("/"))).last()).split("[.]"))).head();
        TimeNumber targetPeriod = (frequencyTarget != null ? frequencyTarget : package.IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(400))).toTime();
        File workspacePathFile = new File(workspacePath);
        FileUtils.deleteDirectory((File)workspacePathFile);
        workspacePathFile.mkdir();
        FileUtils.copyFileToDirectory((File)new File(toplevelPath), (File)workspacePathFile);
        boolean isVhdl = toplevelPath.endsWith(".vhd") || toplevelPath.endsWith(".vhdl");
        FileWriter tcl = new FileWriter(Paths.get(workspacePath, "doit.tcl").toFile());
        tcl.write(new StringBuilder(122).append("read_").append((Object)(isVhdl ? "vhdl" : "verilog")).append(" ").append(toplevelPath).append("\nread_xdc doit.xdc\n\nsynth_design -part ").append(device).append(" -top ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toplevelPath.split("\\."))).head()).append("\nopt_design\nplace_design\nroute_design\n\nreport_utilization\nreport_timing").toString());
        tcl.flush();
        tcl.close();
        FileWriter xdc = new FileWriter(Paths.get(workspacePath, "doit.xdc").toFile());
        xdc.write(new StringBuilder(37).append("create_clock -period ").append(targetPeriod.$times(BigDecimal$.MODULE$.double2bigDecimal(1.0E9)).toBigDecimal()).append(" [get_ports clk]").toString());
        xdc.flush();
        xdc.close();
        this.doCmd(new StringBuilder(61).append(vivadoPath).append("/vivado -nojournal -log doit.log -mode batch -source doit.tcl").toString(), workspacePath);
        return new Report(workspacePath, family, targetPeriod){
            private final String workspacePath$1;
            private final String family$1;
            private final TimeNumber targetPeriod$1;

            public String toString() {
                return Report.toString$(this);
            }

            public double getFMax() {
                double d;
                String report = Source$.MODULE$.fromFile(Paths.get(this.workspacePath$1, "doit.log").toFile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
                Regex intFind = new StringOps(Predef$.MODULE$.augmentString("-?(\\d+\\.?)+")).r();
                try {
                    String string = this.family$1;
                    if (!"Artix 7".equals(string)) {
                        throw new MatchError((Object)string);
                    }
                    String string2 = (String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("-?(\\d+.?)+ns  \\(required time - arrival time\\)")).r().findFirstIn((CharSequence)report).get()).get();
                    d = new StringOps(Predef$.MODULE$.augmentString(string2)).toDouble();
                }
                catch (Exception e) {
                    d = -1.0;
                }
                double slack = d;
                return 1.0 / (this.targetPeriod$1.toDouble() - slack * 1.0E-9);
            }

            public String getArea() {
                String string;
                String report = Source$.MODULE$.fromFile(Paths.get(this.workspacePath$1, "doit.log").toFile(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
                Regex intFind = new StringOps(Predef$.MODULE$.augmentString("(\\d+,?)+")).r();
                try {
                    String string2 = this.family$1;
                    if (!"Artix 7".equals(string2)) {
                        throw new MatchError((Object)string2);
                    }
                    String string3 = new StringBuilder(9).append((String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("Slice LUTs[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)report).get()).get()).append(" LUT ").append(intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("Slice Registers[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)report).get()).get()).append(" FF ").toString();
                    string = string3;
                }
                catch (Exception e) {
                    string = "???";
                }
                String leArea = string;
                return leArea;
            }
            {
                this.workspacePath$1 = workspacePath$1;
                this.family$1 = family$1;
                this.targetPeriod$1 = targetPeriod$1;
                Report.$init$(this);
            }
        };
    }

    public HertzNumber apply$default$6() {
        return null;
    }

    public int apply$default$7() {
        return 1;
    }

    public void main(String[] args) {
        Report report = this.apply("/eda/Xilinx/Vivado/2017.2/bin", "/home/spinalvm/tmp", "TopLevel.vhd", "Artix 7", "xc7k70t-fbg676-3", package.IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(1)), this.apply$default$7());
        Predef$.MODULE$.println((Object)report.getArea());
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToDouble((double)report.getFMax()));
    }

    private VivadoFlow$() {
        MODULE$ = this;
        this.isWindows = System.getProperty("os.name").toLowerCase().contains("win");
    }
}

