/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.eda.altera;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction2;
import scala.sys.process.Process$;
import scala.util.matching.Regex;
import spinal.core.HertzNumber;
import spinal.core.TimeNumber;
import spinal.core.package;
import spinal.core.package$;
import spinal.lib.eda.bench.Report;

public final class QuartusFlow$ {
    public static QuartusFlow$ MODULE$;
    private final boolean isWindows;

    static {
        new QuartusFlow$();
    }

    public void doCmd(String cmd) {
        Predef$.MODULE$.println((Object)cmd);
        if (this.isWindows()) {
            Process$.MODULE$.apply("cmd /C " + cmd).$bang();
        } else {
            Process$.MODULE$.apply(cmd).$bang();
        }
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public double getFMax(String staReportPath) {
        IntRef fmaxLineCounter = IntRef.create((int)-1);
        DoubleRef fMax = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        Regex fMaxReg = new StringOps(Predef$.MODULE$.augmentString("[-+]?(\\d*[.])?\\d+")).r();
        Source$.MODULE$.fromFile(staReportPath, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            QuartusFlow$.$anonfun$getFMax$1(fmaxLineCounter, fMax, fMaxReg, line);
            return BoxedUnit.UNIT;
        });
        return fMax.elem * 1000000.0;
    }

    public String getArea(String reportPath, String family) {
        String string;
        String report = Source$.MODULE$.fromFile(reportPath, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        Regex intFind = new StringOps(Predef$.MODULE$.augmentString("(\\d+,?)+")).r();
        try {
            String string2;
            String string3 = family;
            if ("Cyclone V".equals(string3)) {
                string2 = (String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("Logic utilization \\(in ALMs\\)[ ]*;[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)report).get()).get() + " ALMs";
            } else {
                boolean bl = "Cyclone IV".equals(string3) ? true : "Cyclone II".equals(string3);
                if (bl) {
                    string2 = (String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("Total combinational functions[ ]*;[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)report).get()).get() + " LUT " + intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("Dedicated logic registers[ ]*;[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)report).get()).get() + " FF ";
                } else {
                    throw new MatchError((Object)string3);
                }
            }
            string = string2;
        }
        catch (Exception e) {
            string = "???";
        }
        String leArea = string;
        return leArea;
    }

    public Report apply(String quartusPath, String workspacePath, String toplevelPath, String family, String device, HertzNumber frequencyTarget, int processorCount) {
        String projectName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toplevelPath.split("/"))).last()).split("[.]"))).head();
        TimeNumber targetPeriod = (frequencyTarget != null ? frequencyTarget : package.IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(400))).toTime();
        File workspacePathFile = new File(workspacePath);
        FileUtils.deleteDirectory((File)workspacePathFile);
        workspacePathFile.mkdir();
        FileUtils.copyFileToDirectory((File)new File(toplevelPath), (File)workspacePathFile);
        this.doCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " --family=\"", "\" --part=", " --source=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Paths.get(quartusPath, "quartus_map"), Paths.get(workspacePath, projectName), family, device, Paths.get(workspacePath, toplevelPath)})));
        this.doCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " --parallel=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Paths.get(quartusPath, "quartus_fit"), Paths.get(workspacePath, projectName), BoxesRunTime.boxToInteger((int)processorCount)})));
        this.doCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Paths.get(quartusPath, "quartus_sta"), Paths.get(workspacePath, projectName)})));
        return new Report(workspacePath, family, projectName){
            private final String workspacePath$1;
            private final String family$1;
            private final String projectName$1;

            public String toString() {
                return Report.toString$(this);
            }

            public double getFMax() {
                return QuartusFlow$.MODULE$.getFMax(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Paths.get(this.workspacePath$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".sta.rpt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.projectName$1})))})));
            }

            public String getArea() {
                return QuartusFlow$.MODULE$.getArea(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Paths.get(this.workspacePath$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".flow.rpt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.projectName$1})))})), this.family$1);
            }
            {
                this.workspacePath$1 = workspacePath$1;
                this.family$1 = family$1;
                this.projectName$1 = projectName$1;
                Report.$init$(this);
            }
        };
    }

    public HertzNumber apply$default$6() {
        return null;
    }

    public int apply$default$7() {
        return 1;
    }

    public void main(String[] args) {
        Report report = this.apply("/eda/intelFPGA_lite/17.0/quartus/bin/", "/home/spinalvm/tmp", "TopLevel.vhd", "Cyclone V", "5CSEMA5F31C6", package.IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(1)), this.apply$default$7());
        Predef$.MODULE$.println((Object)report);
    }

    public static final /* synthetic */ double $anonfun$getFMax$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
    }

    public static final /* synthetic */ void $anonfun$getFMax$1(IntRef fmaxLineCounter$1, DoubleRef fMax$1, Regex fMaxReg$1, String line) {
        if (line.contains("; Fmax")) {
            fmaxLineCounter$1.elem = 2;
        }
        int n = fmaxLineCounter$1.elem--;
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                fmaxLineCounter$1.elem = -1;
                Regex.MatchIterator nums = fMaxReg$1.findAllIn((CharSequence)line);
                double lineFMax = BoxesRunTime.unboxToDouble((Object)nums.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)QuartusFlow$.$anonfun$getFMax$2(x$1))).reduce((Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$2, x$3) -> Math.min(x$2, x$3)));
                fMax$1.elem = Math.min(fMax$1.elem, lineFMax);
                break;
            }
        }
    }

    private QuartusFlow$() {
        MODULE$ = this;
        this.isWindows = System.getProperty("os.name").toLowerCase().contains("win");
    }
}

