/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.eda.xilinx;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.BigDecimal$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import spinal.core.HertzNumber;
import spinal.core.TimeNumber;
import spinal.core.package;
import spinal.core.package$;
import spinal.lib.DoCmd$;
import spinal.lib.eda.bench.Report;
import spinal.lib.eda.bench.Report$class;
import spinal.lib.eda.bench.Rtl;

public final class VivadoFlow$ {
    public static final VivadoFlow$ MODULE$;

    static {
        new VivadoFlow$();
    }

    public Report apply(String vivadoPath, String workspacePath, Rtl rtl, String family, String device, HertzNumber frequencyTarget, int processorCount) {
        TimeNumber targetPeriod = (frequencyTarget == null ? package.IntBuilder$.MODULE$.MHz$extension(package$.MODULE$.IntToBuilder(400)) : frequencyTarget).toTime();
        File workspacePathFile = new File(workspacePath);
        FileUtils.deleteDirectory((File)workspacePathFile);
        workspacePathFile.mkdir();
        rtl.getRtlPaths().foreach((Function1)new Serializable(workspacePathFile){
            public static final long serialVersionUID = 0L;
            private final File workspacePathFile$1;

            public final void apply(String file) {
                FileUtils.copyFileToDirectory((File)new File(file), (File)this.workspacePathFile$1);
            }
            {
                this.workspacePathFile$1 = workspacePathFile$1;
            }
        });
        Serializable isVhdl = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String file) {
                return file.endsWith(".vhd") || file.endsWith(".vhdl");
            }
        };
        String readRtl = ((TraversableOnce)rtl.getRtlPaths().map((Function1)new Serializable((Function1)isVhdl){
            public static final long serialVersionUID = 0L;
            private final Function1 isVhdl$1;

            public final String apply(String file) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read_", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.unboxToBoolean((Object)this.isVhdl$1.apply((Object)file)) ? "vhdl" : "verilog", Paths.get(file, new String[0]).getFileName()}));
            }
            {
                this.isVhdl$1 = isVhdl$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        FileWriter tcl = new FileWriter(Paths.get(workspacePath, "doit.tcl").toFile());
        tcl.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\nread_xdc doit.xdc\n\nsynth_design -part ", " -top ", "\nopt_design\nplace_design\nroute_design\n\nreport_utilization\nreport_timing"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{readRtl, device, rtl.getTopModuleName()})));
        tcl.flush();
        tcl.close();
        FileWriter xdc = new FileWriter(Paths.get(workspacePath, "doit.xdc").toFile());
        xdc.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create_clock -period ", " [get_ports clk]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPeriod.$times(BigDecimal$.MODULE$.double2bigDecimal(1.0E9)).toBigDecimal()})));
        xdc.flush();
        xdc.close();
        DoCmd$.MODULE$.doCmd(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/vivado -nojournal -log doit.log -mode batch -source doit.tcl"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vivadoPath})), workspacePath);
        BufferedSource log = Source$.MODULE$.fromFile(Paths.get(workspacePath, "doit.log").toFile(), Codec$.MODULE$.fallbackSystemCodec());
        String report = log.getLines().mkString();
        return new Report(family, targetPeriod, report){
            private final String family$1;
            private final TimeNumber targetPeriod$1;
            private final String report$1;

            public String toString() {
                return Report$class.toString(this);
            }

            public double getFMax() {
                double d;
                Regex intFind = new StringOps(Predef$.MODULE$.augmentString("-?(\\d+\\.?)+")).r();
                try {
                    String string = this.family$1;
                    boolean bl = "Artix 7".equals(string) ? true : ("Kintex 7".equals(string) ? true : ("Kintex UltraScale".equals(string) ? true : ("Kintex UltraScale+".equals(string) ? true : "Virtex UltraScale+".equals(string))));
                    if (!bl) {
                        throw new MatchError((Object)string);
                    }
                    String string2 = (String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("-?(\\d+.?)+ns  \\(required time - arrival time\\)")).r().findFirstIn((CharSequence)this.report$1).get()).get();
                    d = new StringOps(Predef$.MODULE$.augmentString(string2)).toDouble();
                }
                catch (Exception exception) {
                    d = -100000.0;
                }
                double slack = d;
                return 1.0 / (this.targetPeriod$1.toDouble() - slack * 1.0E-9);
            }

            public String getArea() {
                String string;
                Regex intFind = new StringOps(Predef$.MODULE$.augmentString("(\\d+,?)+")).r();
                try {
                    String string2;
                    String string3 = this.family$1;
                    boolean bl = "Artix 7".equals(string3) ? true : "Kintex 7".equals(string3);
                    if (bl) {
                        string2 = new StringBuilder().append((Object)((String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("Slice LUTs[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)this.report$1).get()).get())).append((Object)" LUT ").append(intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("Slice Registers[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)this.report$1).get()).get()).append((Object)" FF ").toString();
                    } else {
                        boolean bl2 = "Kintex UltraScale".equals(string3) ? true : ("Kintex UltraScale+".equals(string3) ? true : "Virtex UltraScale+".equals(string3));
                        if (bl2) {
                            string2 = new StringBuilder().append((Object)((String)intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("CLB LUTs[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)this.report$1).get()).get())).append((Object)" LUT ").append(intFind.findFirstIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString("CLB Registers[ ]*\\|[ ]*(\\d+,?)+")).r().findFirstIn((CharSequence)this.report$1).get()).get()).append((Object)" FF ").toString();
                        } else {
                            throw new MatchError((Object)string3);
                        }
                    }
                    string = string2;
                }
                catch (Exception exception) {
                    string = "???";
                }
                String leArea = string;
                return leArea;
            }
            {
                this.family$1 = family$1;
                this.targetPeriod$1 = targetPeriod$1;
                this.report$1 = report$1;
                Report$class.$init$(this);
            }
        };
    }

    public HertzNumber apply$default$6() {
        return null;
    }

    public int apply$default$7() {
        return 1;
    }

    private VivadoFlow$() {
        MODULE$ = this;
    }
}

