/*
 * Decompiled with CFR 0.152.
 */
package spinal.lib.bus.amba4.axi.sim;

import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;
import spinal.core.BitVector;
import spinal.core.ClockDomain;
import spinal.core.log2Up$;
import spinal.core.sim.package$;
import spinal.idslplugin.Location;
import spinal.lib.DataCarrier$;
import spinal.lib.Stream;
import spinal.lib.bus.amba4.axi.Axi4;
import spinal.lib.bus.amba4.axi.Axi4Ar;
import spinal.lib.bus.amba4.axi.Axi4Aw;
import spinal.lib.bus.amba4.axi.Axi4Ax;
import spinal.lib.bus.amba4.axi.Axi4B;
import spinal.lib.bus.amba4.axi.Axi4R;
import spinal.lib.bus.amba4.axi.Axi4W;
import spinal.lib.bus.amba4.axi.sim.AxiJob;
import spinal.lib.bus.amba4.axi.sim.AxiMemorySim$;
import spinal.lib.bus.amba4.axi.sim.AxiMemorySimConfig;
import spinal.lib.bus.amba4.axi.sim.SparseMemory;
import spinal.sim.SimThread;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0001\u0003\u0001>\u0011A\"\u0011=j\u001b\u0016lwN]=TS6T!a\u0001\u0003\u0002\u0007MLWN\u0003\u0002\u0006\r\u0005\u0019\u0011\r_5\u000b\u0005\u001dA\u0011!B1nE\u0006$$BA\u0005\u000b\u0003\r\u0011Wo\u001d\u0006\u0003\u00171\t1\u0001\\5c\u0015\u0005i\u0011AB:qS:\fGn\u0001\u0001\u0014\t\u0001\u0001b#\u0007\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E9\u0012B\u0001\r\u0013\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u0005\u000e\n\u0005m\u0011\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0003\u0001\u0005+\u0007I\u0011A\u000f\u0016\u0003y\u0001\"a\b\u0011\u000e\u0003\u0011I!!\t\u0003\u0003\t\u0005C\u0018\u000e\u000e\u0005\tG\u0001\u0011\t\u0012)A\u0005=\u0005!\u0011\r_5!\u0011!)\u0003A!f\u0001\n\u00031\u0013aC2m_\u000e\\Gi\\7bS:,\u0012a\n\t\u0003Q-j\u0011!\u000b\u0006\u0003U1\tAaY8sK&\u0011A&\u000b\u0002\f\u00072|7m\u001b#p[\u0006Lg\u000e\u0003\u0005/\u0001\tE\t\u0015!\u0003(\u00031\u0019Gn\\2l\t>l\u0017-\u001b8!\u0011!\u0001\u0004A!f\u0001\n\u0003\t\u0014AB2p]\u001aLw-F\u00013!\t\u0019D'D\u0001\u0003\u0013\t)$A\u0001\nBq&lU-\\8ssNKWnQ8oM&<\u0007\u0002C\u001c\u0001\u0005#\u0005\u000b\u0011\u0002\u001a\u0002\u000f\r|gNZ5hA!)\u0011\b\u0001C\u0001u\u00051A(\u001b8jiz\"Ba\u000f\u001f>}A\u00111\u0007\u0001\u0005\u0006\u000ba\u0002\rA\b\u0005\u0006Ka\u0002\ra\n\u0005\u0006aa\u0002\rA\r\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0003\u0019iW-\\8ssV\t!\t\u0005\u00024\u0007&\u0011AI\u0001\u0002\r'B\f'o]3NK6|'/\u001f\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\"\u0002\u000f5,Wn\u001c:zA!9\u0001\n\u0001b\u0001\n\u0003I\u0015!\u00049f]\u0012LgnZ0sK\u0006$7/F\u0001K!\rY\u0005KU\u0007\u0002\u0019*\u0011QJT\u0001\b[V$\u0018M\u00197f\u0015\ty%#\u0001\u0006d_2dWm\u0019;j_:L!!\u0015'\u0003\u000bE+X-^3\u0011\u0005M\u001a\u0016B\u0001+\u0003\u0005\u0019\t\u00050\u001b&pE\"1a\u000b\u0001Q\u0001\n)\u000ba\u0002]3oI&twm\u0018:fC\u0012\u001c\b\u0005C\u0004Y\u0001\t\u0007I\u0011A%\u0002\u001dA,g\u000eZ5oO~;(/\u001b;fg\"1!\f\u0001Q\u0001\n)\u000bq\u0002]3oI&twmX<sSR,7\u000f\t\u0005\b9\u0002\u0011\r\u0011\"\u0001^\u0003\u001d!\bN]3bIN,\u0012A\u0018\t\u0004\u0017B{\u0006C\u00011c\u001b\u0005\t'BA\u0002\r\u0013\t\u0019\u0017MA\u0005TS6$\u0006N]3bI\"1Q\r\u0001Q\u0001\ny\u000b\u0001\u0002\u001e5sK\u0006$7\u000f\t\u0005\bO\u0002\u0011\r\u0011\"\u0001i\u00031\u0011Wo],pe\u0012<\u0016\u000e\u001a;i+\u0005I\u0007CA\tk\u0013\tY'CA\u0002J]RDa!\u001c\u0001!\u0002\u0013I\u0017!\u00042vg^{'\u000fZ,jIRD\u0007\u0005C\u0004p\u0001\t\u0007I\u0011\u00015\u0002\u00195\f\u0007PQ;sgR\u001c\u0016N_3\t\rE\u0004\u0001\u0015!\u0003j\u00035i\u0017\r\u001f\"veN$8+\u001b>fA!)1\u000f\u0001C\u0001i\u0006Ia.Z<Bq&TuN\u0019\u000b\b%VTHP`A\u0001\u0011\u00151(\u000f1\u0001x\u0003\u001d\tG\r\u001a:fgN\u0004\"!\u0005=\n\u0005e\u0014\"\u0001\u0002'p]\u001eDQa\u001f:A\u0002%\f1BY;sgRdUM\\4uQ\")QP\u001da\u0001S\u0006I!-\u001e:tiNK'0\u001a\u0005\u0006\u007fJ\u0004\r![\u0001\nEV\u00148\u000f\u001e+za\u0016Da!a\u0001s\u0001\u00049\u0018AA5e\u0011\u0019\u0019\b\u0001\"\u0001\u0002\bQ\u0019!+!\u0003\t\u0011\u0005-\u0011Q\u0001a\u0001\u0003\u001b\t!!\u0019=\u0011\u0007}\ty!C\u0002\u0002\u0012\u0011\u0011a!\u0011=ji\u0005C\bbBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u00033\u00012!EA\u000e\u0013\r\tiB\u0005\u0002\u0005+:LG\u000fC\u0004\u0002\"\u0001!\t!a\u0006\u0002\tM$x\u000e\u001d\u0005\b\u0003K\u0001A\u0011AA\f\u0003\u0015\u0011Xm]3u\u0011\u001d\tI\u0003\u0001C\u0001\u0003W\taaZ3u\u0019\u0016tGcA5\u0002.!A\u00111BA\u0014\u0001\u0004\ti\u0001C\u0004\u00022\u0001!\t!a\r\u0002\u000f\u001d,GoU5{KR\u0019\u0011.!\u000e\t\u0011\u0005-\u0011q\u0006a\u0001\u0003\u001bAq!!\u000f\u0001\t\u0003\tY$A\bhKR\u001c\u0016N_3B]\u0012\u001c\u0005.Z2l)\rI\u0017Q\b\u0005\t\u0003\u0017\t9\u00041\u0001\u0002\u000e!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0013!B4fi&#GcA<\u0002F!A\u00111BA \u0001\u0004\ti\u0001C\u0004\u0002J\u0001!\t!a\u0013\u0002\u0011\u001d,GOQ;sgR$2![A'\u0011!\tY!a\u0012A\u0002\u00055\u0001bBA)\u0001\u0011\u0005\u00111K\u0001\bO\u0016$8\u000b\u001e:c)\u0011\t)&!\u001c\u0011\t\u0005]\u0013q\r\b\u0005\u00033\n\u0019G\u0004\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyFD\u0001\u0007yI|w\u000e\u001e \n\u0003MI1!!\u001a\u0013\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001b\u0002l\t1!)[4J]RT1!!\u001a\u0013\u0011!\ty'a\u0014A\u0002\u0005E\u0014!A<\u0011\u0007}\t\u0019(C\u0002\u0002v\u0011\u0011Q!\u0011=ji]Cq!!\u001f\u0001\t\u0003\tY(A\u0004tKRd\u0015m\u001d;\u0015\r\u0005e\u0011QPAD\u0011!\ty(a\u001eA\u0002\u0005\u0005\u0015!\u0001:\u0011\u0007}\t\u0019)C\u0002\u0002\u0006\u0012\u0011Q!\u0011=jiIC\u0001\"!#\u0002x\u0001\u0007\u00111R\u0001\u0005Y\u0006\u001cH\u000fE\u0002\u0012\u0003\u001bK1!a$\u0013\u0005\u001d\u0011un\u001c7fC:Dq!a%\u0001\t\u0003\t)*\u0001\u0005iC:$G.Z!s)\u0011\tI\"a&\t\u0011\u0005e\u0015\u0011\u0013a\u0001\u00037\u000b!!\u0019:\u0011\r\u0005u\u0015qTAR\u001b\u0005Q\u0011bAAQ\u0015\t11\u000b\u001e:fC6\u00042aHAS\u0013\r\t9\u000b\u0002\u0002\u0007\u0003bLG'\u0011:\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\u00069\u0001.\u00198eY\u0016\u0014F\u0003BA\r\u0003_C\u0001\"a \u0002*\u0002\u0007\u0011\u0011\u0017\t\u0007\u0003;\u000by*!!\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\u0006A\u0001.\u00198eY\u0016\fu\u000f\u0006\u0003\u0002\u001a\u0005e\u0006\u0002CA^\u0003g\u0003\r!!0\u0002\u0005\u0005<\bCBAO\u0003?\u000by\fE\u0002 \u0003\u0003L1!a1\u0005\u0005\u0019\t\u00050\u001b\u001bBo\"9\u0011q\u0019\u0001\u0005\u0002\u0005%\u0017a\u00025b]\u0012dWm\u0016\u000b\u0007\u00033\tY-a4\t\u0011\u0005=\u0014Q\u0019a\u0001\u0003\u001b\u0004b!!(\u0002 \u0006E\u0004\u0002CAi\u0003\u000b\u0004\r!a5\u0002\u0003\t\u0004b!!(\u0002 \u0006U\u0007cA\u0010\u0002X&\u0019\u0011\u0011\u001c\u0003\u0003\u000b\u0005C\u0018\u000e\u000e\"\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u0006a\u0001.\u00198eY\u0016\fu/\u00118e/RA\u0011\u0011DAq\u0003G\f)\u000f\u0003\u0005\u0002p\u0005m\u0007\u0019AAg\u0011!\tY,a7A\u0002\u0005u\u0006\u0002CAi\u00037\u0004\r!a5\t\u0013\u0005%\b!!A\u0005\u0002\u0005-\u0018\u0001B2paf$raOAw\u0003_\f\t\u0010\u0003\u0005\u0006\u0003O\u0004\n\u00111\u0001\u001f\u0011!)\u0013q\u001dI\u0001\u0002\u00049\u0003\u0002\u0003\u0019\u0002hB\u0005\t\u0019\u0001\u001a\t\u0013\u0005U\b!%A\u0005\u0002\u0005]\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003sT3AHA~W\t\ti\u0010\u0005\u0003\u0002\u0000\n%QB\u0001B\u0001\u0015\u0011\u0011\u0019A!\u0002\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0004%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-!\u0011\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B\b\u0001E\u0005I\u0011\u0001B\t\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0005+\u0007\u001d\nY\u0010C\u0005\u0003\u0018\u0001\t\n\u0011\"\u0001\u0003\u001a\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u000eU\r\u0011\u00141 \u0005\n\u0005?\u0001\u0011\u0011!C!\u0005C\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0012!\u0011\u0011)Ca\f\u000e\u0005\t\u001d\"\u0002\u0002B\u0015\u0005W\tA\u0001\\1oO*\u0011!QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00032\t\u001d\"AB*ue&tw\r\u0003\u0005\u00036\u0001\t\t\u0011\"\u0001i\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\u0011I\u0004AA\u0001\n\u0003\u0011Y$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tu\"1\t\t\u0004#\t}\u0012b\u0001B!%\t\u0019\u0011I\\=\t\u0013\t\u0015#qGA\u0001\u0002\u0004I\u0017a\u0001=%c!I!\u0011\n\u0001\u0002\u0002\u0013\u0005#1J\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\n\t\u0007\u0005\u001f\u0012\tF!\u0010\u000e\u00039K1Aa\u0015O\u0005!IE/\u001a:bi>\u0014\b\"\u0003B,\u0001\u0005\u0005I\u0011\u0001B-\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAF\u00057B!B!\u0012\u0003V\u0005\u0005\t\u0019\u0001B\u001f\u0011%\u0011y\u0006AA\u0001\n\u0003\u0012\t'\u0001\u0005iCND7i\u001c3f)\u0005I\u0007\"\u0003B3\u0001\u0005\u0005I\u0011\tB4\u0003!!xn\u0015;sS:<GC\u0001B\u0012\u0011%\u0011Y\u0007AA\u0001\n\u0003\u0012i'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0017\u0013y\u0007\u0003\u0006\u0003F\t%\u0014\u0011!a\u0001\u0005{9\u0011Ba\u001d\u0003\u0003\u0003E\tA!\u001e\u0002\u0019\u0005C\u0018.T3n_JL8+[7\u0011\u0007M\u00129H\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B='\u0015\u00119Ha\u001f\u001a!!\u0011iHa!\u001fOIZTB\u0001B@\u0015\r\u0011\tIE\u0001\beVtG/[7f\u0013\u0011\u0011)Ia \u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004:\u0005o\"\tA!#\u0015\u0005\tU\u0004B\u0003B3\u0005o\n\t\u0011\"\u0012\u0003h!Q!q\u0012B<\u0003\u0003%\tI!%\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fm\u0012\u0019J!&\u0003\u0018\"1QA!$A\u0002yAa!\nBG\u0001\u00049\u0003B\u0002\u0019\u0003\u000e\u0002\u0007!\u0007\u0003\u0006\u0003\u001c\n]\u0014\u0011!CA\u0005;\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003 \n-\u0006#B\t\u0003\"\n\u0015\u0016b\u0001BR%\t1q\n\u001d;j_:\u0004b!\u0005BT=\u001d\u0012\u0014b\u0001BU%\t1A+\u001e9mKNB\u0011B!,\u0003\u001a\u0006\u0005\t\u0019A\u001e\u0002\u0007a$\u0003\u0007\u0003\u0006\u00032\n]\u0014\u0011!C\u0005\u0005g\u000b1B]3bIJ+7o\u001c7wKR\u0011!Q\u0017\t\u0005\u0005K\u00119,\u0003\u0003\u0003:\n\u001d\"AB(cU\u0016\u001cG\u000f")
public class AxiMemorySim
implements Product,
Serializable {
    private final Axi4 axi;
    private final ClockDomain clockDomain;
    private final AxiMemorySimConfig config;
    private final SparseMemory memory;
    private final Queue<AxiJob> pending_reads;
    private final Queue<AxiJob> pending_writes;
    private final Queue<SimThread> threads;
    private final int busWordWidth;
    private final int maxBurstSize;

    public static Option<Tuple3<Axi4, ClockDomain, AxiMemorySimConfig>> unapply(AxiMemorySim axiMemorySim) {
        return AxiMemorySim$.MODULE$.unapply(axiMemorySim);
    }

    public static AxiMemorySim apply(Axi4 axi4, ClockDomain clockDomain, AxiMemorySimConfig axiMemorySimConfig) {
        return AxiMemorySim$.MODULE$.apply(axi4, clockDomain, axiMemorySimConfig);
    }

    public static Function1<Tuple3<Axi4, ClockDomain, AxiMemorySimConfig>, AxiMemorySim> tupled() {
        return AxiMemorySim$.MODULE$.tupled();
    }

    public static Function1<Axi4, Function1<ClockDomain, Function1<AxiMemorySimConfig, AxiMemorySim>>> curried() {
        return AxiMemorySim$.MODULE$.curried();
    }

    public Axi4 axi() {
        return this.axi;
    }

    public ClockDomain clockDomain() {
        return this.clockDomain;
    }

    public AxiMemorySimConfig config() {
        return this.config;
    }

    public SparseMemory memory() {
        return this.memory;
    }

    public Queue<AxiJob> pending_reads() {
        return this.pending_reads;
    }

    public Queue<AxiJob> pending_writes() {
        return this.pending_writes;
    }

    public Queue<SimThread> threads() {
        return this.threads;
    }

    public int busWordWidth() {
        return this.busWordWidth;
    }

    public int maxBurstSize() {
        return this.maxBurstSize;
    }

    public AxiJob newAxiJob(long address, int burstLength, int burstSize, int burstType, long id) {
        return new AxiJob(address, burstLength, burstSize, burstType, id);
    }

    public AxiJob newAxiJob(Axi4Ax ax) {
        return this.newAxiJob(package$.MODULE$.SimBitVectorPimper((BitVector)ax.addr()).toLong(), this.getLen(ax), this.getSizeAndCheck(ax), this.getBurst(ax), this.getId(ax));
    }

    public void start() {
        this.threads().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AxiMemorySim $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.handleAr(this.$outer.axi().ar());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })}));
        this.threads().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AxiMemorySim $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.handleR(this.$outer.axi().r());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })}));
        if (this.config().useAlteraBehavior()) {
            this.threads().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AxiMemorySim $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.handleAwAndW(this.$outer.axi().w(), this.$outer.axi().aw(), this.$outer.axi().b());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })}));
        } else {
            this.threads().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AxiMemorySim $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.handleAw(this.$outer.axi().aw());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })}));
            this.threads().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimThread[]{package$.MODULE$.fork((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AxiMemorySim $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.handleW(this.$outer.axi().w(), this.$outer.axi().b());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })}));
        }
    }

    public void stop() {
        this.threads().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SimThread f) {
                f.terminate();
            }
        }, Queue$.MODULE$.canBuildFrom());
    }

    public void reset() {
        this.stop();
        this.pending_reads().clear();
        this.pending_writes().clear();
        this.start();
    }

    public int getLen(Axi4Ax ax) {
        return ax.config().useLen() ? package$.MODULE$.SimBitVectorPimper((BitVector)ax.len()).toInt() : 0;
    }

    public int getSize(Axi4Ax ax) {
        return ax.config().useSize() ? package$.MODULE$.SimBitVectorPimper((BitVector)ax.size()).toInt() : this.maxBurstSize();
    }

    /*
     * WARNING - void declaration
     */
    public int getSizeAndCheck(Axi4Ax ax) {
        void var2_2;
        int burstSize = this.getSize(ax);
        spinal.core.package$.MODULE$.assert(burstSize <= this.maxBurstSize());
        return (int)var2_2;
    }

    public long getId(Axi4Ax ax) {
        return ax.config().useId() ? package$.MODULE$.SimBitVectorPimper((BitVector)ax.id()).toLong() : 0L;
    }

    public int getBurst(Axi4Ax ax) {
        return ax.config().useBurst() ? package$.MODULE$.SimBitVectorPimper((BitVector)ax.burst()).toInt() : this.config().defaultBurstType();
    }

    public BigInt getStrb(Axi4W w) {
        return w.config().useStrb() ? package$.MODULE$.SimBitVectorPimper((BitVector)w.strb()).toBigInt() : null;
    }

    public void setLast(Axi4R r, boolean last2) {
        if (r.config().useLast()) {
            package$.MODULE$.SimBoolPimper(r.last()).$hash$eq(last2);
        }
    }

    public void handleAr(Stream<Axi4Ar> ar) {
        Predef$.MODULE$.println((Object)"Handling AXI4 Master read cmds...");
        package$.MODULE$.SimBoolPimper(ar.ready()).$hash$eq(false);
        while (true) {
            package$.MODULE$.SimBoolPimper(ar.ready()).$hash$eq(true);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)new Serializable(this, ar){
                public static final long serialVersionUID = 0L;
                private final Stream ar$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return package$.MODULE$.SimBoolPimper(this.ar$1.valid()).toBoolean();
                }
                {
                    this.ar$1 = ar$1;
                }
            });
            package$.MODULE$.SimBoolPimper(ar.ready()).$hash$eq(false);
            this.pending_reads().$plus$eq((Object)this.newAxiJob(ar.payload()));
            if (this.pending_reads().length() < this.config().maxOutstandingReads()) continue;
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AxiMemorySim $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.pending_reads().length() < this.$outer.config().maxOutstandingReads();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public void handleR(Stream<Axi4R> r) {
        Predef$.MODULE$.println((Object)"Handling AXI4 Master read resp...");
        Random$ random2 = Random$.MODULE$;
        package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(false);
        this.setLast(r.payload(), false);
        while (true) {
            Object object;
            if (this.pending_reads().nonEmpty()) {
                AxiJob job = (AxiJob)this.pending_reads().front();
                package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(true);
                for (int i = 0; i <= job.burstLength(); ++i) {
                    if (this.config().interruptProbability() > random2.nextInt(100)) {
                        package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(false);
                        package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(random2.nextInt(this.config().interruptMaxDelay() + 1));
                        package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(true);
                    }
                    if (i == job.burstLength()) {
                        this.setLast(r.payload(), true);
                    }
                    if (DataCarrier$.MODULE$.toImplicit(r).config().useId()) {
                        package$.MODULE$.SimBitVectorPimper((BitVector)r.payload().id()).$hash$eq(job.id());
                    }
                    if (DataCarrier$.MODULE$.toImplicit(r).config().useResp()) {
                        package$.MODULE$.SimBitVectorPimper((BitVector)r.payload().resp()).$hash$eq(0);
                    }
                    package$.MODULE$.SimBitVectorPimper((BitVector)r.payload().data()).$hash$eq(this.memory().readBigInt(job.alignedBurstAddress(i, this.maxBurstSize()), this.busWordWidth()));
                    package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)new Serializable(this, r){
                        public static final long serialVersionUID = 0L;
                        private final Stream r$1;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return package$.MODULE$.SimBoolPimper(this.r$1.ready()).toBoolean();
                        }
                        {
                            this.r$1 = r$1;
                        }
                    });
                }
                package$.MODULE$.SimBoolPimper(r.valid()).$hash$eq(false);
                this.setLast(r.payload(), false);
                object = this.pending_reads().dequeue();
                continue;
            }
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(1);
            object = BoxedUnit.UNIT;
        }
    }

    public void handleAw(Stream<Axi4Aw> aw) {
        Predef$.MODULE$.println((Object)"Handling AXI4 Master write cmds...");
        package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
        while (true) {
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(true);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)new Serializable(this, aw){
                public static final long serialVersionUID = 0L;
                private final Stream aw$2;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return package$.MODULE$.SimBoolPimper(this.aw$2.valid()).toBoolean();
                }
                {
                    this.aw$2 = aw$2;
                }
            });
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
            this.pending_writes().$plus$eq((Object)this.newAxiJob(aw.payload()));
            if (this.pending_writes().length() < this.config().maxOutstandingWrites()) continue;
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AxiMemorySim $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.pending_writes().length() < this.$outer.config().maxOutstandingWrites();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public void handleW(Stream<Axi4W> w, Stream<Axi4B> b) {
        Predef$.MODULE$.println((Object)"Handling AXI4 Master write...");
        package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
        while (true) {
            Object object;
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(10);
            if (this.pending_writes().nonEmpty()) {
                ObjectRef job = ObjectRef.create((Object)((AxiJob)this.pending_writes().front()));
                int count = ((AxiJob)job.elem).burstLength();
                package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(true);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ((AxiJob)job.elem).burstLength()).foreach$mVc$sp((Function1)new Serializable(this, w, job){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AxiMemorySim $outer;
                    public final Stream w$2;
                    private final ObjectRef job$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        package$.MODULE$.SimClockDomainPimper(this.$outer.clockDomain()).waitSamplingWhere((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$handleW$1 $outer;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return package$.MODULE$.SimBoolPimper(this.$outer.w$2.valid()).toBoolean();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.$outer.memory().writeBigInt(((AxiJob)this.job$1.elem).alignedBurstAddress(i, this.$outer.maxBurstSize()), package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4W)((Object)this.w$2.payload())).data()).toBigInt(), this.$outer.busWordWidth(), this.$outer.getStrb((Axi4W)((Object)this.w$2.payload())));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.w$2 = w$2;
                        this.job$1 = job$1;
                    }
                });
                package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
                package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(this.config().writeResponseDelay());
                package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(true);
                if (DataCarrier$.MODULE$.toImplicit(b).config().useId()) {
                    package$.MODULE$.SimBitVectorPimper((BitVector)b.payload().id()).$hash$eq(((AxiJob)job.elem).id());
                }
                if (DataCarrier$.MODULE$.toImplicit(b).config().useResp()) {
                    package$.MODULE$.SimBitVectorPimper((BitVector)b.payload().resp()).$hash$eq(0);
                }
                package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)new Serializable(this, b){
                    public static final long serialVersionUID = 0L;
                    private final Stream b$2;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return package$.MODULE$.SimBoolPimper(this.b$2.ready()).toBoolean();
                    }
                    {
                        this.b$2 = b$2;
                    }
                });
                package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
                object = this.pending_writes().dequeue();
                continue;
            }
            object = BoxedUnit.UNIT;
        }
    }

    public void handleAwAndW(Stream<Axi4W> w, Stream<Axi4Aw> aw, Stream<Axi4B> b) {
        Predef$.MODULE$.println((Object)"Handling AXI4 Master write cmds and write (Altera/Intel behavior)...");
        Random$ random2 = Random$.MODULE$;
        package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
        package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
        while (true) {
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)new Serializable(this, w, aw){
                public static final long serialVersionUID = 0L;
                private final Stream w$1;
                private final Stream aw$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return package$.MODULE$.SimBoolPimper(this.aw$1.valid()).toBoolean() && package$.MODULE$.SimBoolPimper(this.w$1.valid()).toBoolean();
                }
                {
                    this.w$1 = w$1;
                    this.aw$1 = aw$1;
                }
            });
            package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(true);
            spinal.core.package$.MODULE$.assert(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).len()).toBigInt().$plus(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).addr()).toBigInt().$amp(BigInt$.MODULE$.int2bigInt(4095))).$less$eq(BigInt$.MODULE$.int2bigInt(4095)), (Function0)new Serializable(this, aw){
                public static final long serialVersionUID = 0L;
                private final Stream aw$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Write request crossing 4k boundary (addr=", ", len=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)((Object)this.aw$1.payload())).addr()).toBigInt().toString(16), RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)((Object)this.aw$1.payload())).len()).toLong()))}));
                }
                {
                    this.aw$1 = aw$1;
                }
            }, new Location("AxiMemorySim", 526, 13));
            AxiJob job = this.newAxiJob(aw.payload());
            int i = 0;
            while (i <= package$.MODULE$.SimBitVectorPimper((BitVector)((Axi4Ax)aw.payload()).len()).toInt()) {
                if (this.config().interruptProbability() > random2.nextInt(100)) {
                    package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
                    package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(random2.nextInt(this.config().interruptMaxDelay() + 1));
                    package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(true);
                    continue;
                }
                package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)new Serializable(this, w){
                    public static final long serialVersionUID = 0L;
                    private final Stream w$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return package$.MODULE$.SimBoolPimper(this.w$1.valid()).toBoolean();
                    }
                    {
                        this.w$1 = w$1;
                    }
                });
                this.memory().writeBigInt(job.alignedBurstAddress(i, this.maxBurstSize()), package$.MODULE$.SimBitVectorPimper((BitVector)w.payload().data()).toBigInt(), this.busWordWidth(), this.getStrb(w.payload()));
                ++i;
            }
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(true);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(1);
            package$.MODULE$.SimBoolPimper(aw.ready()).$hash$eq(false);
            package$.MODULE$.SimBoolPimper(w.ready()).$hash$eq(false);
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSampling(this.config().writeResponseDelay());
            package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(true);
            if (DataCarrier$.MODULE$.toImplicit(b).config().useId()) {
                package$.MODULE$.SimBitVectorPimper((BitVector)b.payload().id()).$hash$eq(job.id());
            }
            if (DataCarrier$.MODULE$.toImplicit(b).config().useResp()) {
                package$.MODULE$.SimBitVectorPimper((BitVector)b.payload().resp()).$hash$eq(0);
            }
            package$.MODULE$.SimClockDomainPimper(this.clockDomain()).waitSamplingWhere((Function0)new Serializable(this, b){
                public static final long serialVersionUID = 0L;
                private final Stream b$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return package$.MODULE$.SimBoolPimper(this.b$1.ready()).toBoolean();
                }
                {
                    this.b$1 = b$1;
                }
            });
            package$.MODULE$.SimBoolPimper(b.valid()).$hash$eq(false);
        }
    }

    public AxiMemorySim copy(Axi4 axi, ClockDomain clockDomain, AxiMemorySimConfig config) {
        return new AxiMemorySim(axi, clockDomain, config);
    }

    public Axi4 copy$default$1() {
        return this.axi();
    }

    public ClockDomain copy$default$2() {
        return this.clockDomain();
    }

    public AxiMemorySimConfig copy$default$3() {
        return this.config();
    }

    public String productPrefix() {
        return "AxiMemorySim";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.config();
                break;
            }
            case 1: {
                object = this.clockDomain();
                break;
            }
            case 0: {
                object = this.axi();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AxiMemorySim;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AxiMemorySim)) return false;
        boolean bl = true;
        if (!bl) return false;
        AxiMemorySim axiMemorySim = (AxiMemorySim)x$1;
        Axi4 axi4 = this.axi();
        Axi4 axi42 = axiMemorySim.axi();
        if (axi4 == null) {
            if (axi42 != null) {
                return false;
            }
        } else if (!axi4.equals(axi42)) return false;
        ClockDomain clockDomain = this.clockDomain();
        ClockDomain clockDomain2 = axiMemorySim.clockDomain();
        if (clockDomain == null) {
            if (clockDomain2 != null) {
                return false;
            }
        } else if (!clockDomain.equals(clockDomain2)) return false;
        AxiMemorySimConfig axiMemorySimConfig = this.config();
        AxiMemorySimConfig axiMemorySimConfig2 = axiMemorySim.config();
        if (axiMemorySimConfig == null) {
            if (axiMemorySimConfig2 != null) {
                return false;
            }
        } else if (!((Object)axiMemorySimConfig).equals(axiMemorySimConfig2)) return false;
        if (!axiMemorySim.canEqual(this)) return false;
        return true;
    }

    public AxiMemorySim(Axi4 axi, ClockDomain clockDomain, AxiMemorySimConfig config) {
        this.axi = axi;
        this.clockDomain = clockDomain;
        this.config = config;
        Product.class.$init$((Product)this);
        this.memory = new SparseMemory();
        this.pending_reads = new Queue();
        this.pending_writes = new Queue();
        this.threads = new Queue();
        this.busWordWidth = axi.config().dataWidth() / 8;
        this.maxBurstSize = log2Up$.MODULE$.apply(this.busWordWidth());
    }
}

