/*
 * Decompiled with CFR 0.152.
 */
package tasks;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Map;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import tasks.DeployHandler;
import tasks.DeployOpts;

public final class DeployTask$ {
    public static DeployTask$ MODULE$;
    private Logger logger;

    static {
        new DeployTask$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void start(Logger logger, String stage, Seq<File> confs, File baseDir, File distFile) {
        this.logger_$eq(logger);
        if (!distFile.exists()) {
            logger.error((Function0 & Serializable & scala.Serializable)() -> "Dist file not exists");
        } else if (confs.isEmpty()) {
            logger.error((Function0 & Serializable & scala.Serializable)() -> "Config file list is empty");
        } else if (confs.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeployTask$.$anonfun$start$3(x$1)))) {
            logger.error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deploy config files not found: ", "'.\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)confs.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeployTask$.$anonfun$start$5(x$2)))).mkString(", ")})) + "Try to create config file using task 'deployGenerateConf' or specify correct file using 'deployConf' setting key");
        } else {
            Config config = ((Config)confs.foldLeft((Object)ConfigFactory.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Config config = (Config)tuple2._1();
                File confFile = (File)tuple2._2();
                Config config2 = config.withFallback((ConfigMergeable)ConfigFactory.parseFile((File)confFile));
                return config2;
            })).resolve();
            if (config.hasPath("deploy")) {
                String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deploy.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stage}));
                if (config.hasPath(path)) {
                    this.startWithConfig(config.getConfig(path), baseDir, distFile);
                } else {
                    logger.error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stage ", " not found in config"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stage})));
                }
            } else {
                logger.error((Function0 & Serializable & scala.Serializable)() -> "Config empty or does not contain 'deploy' path");
            }
        }
    }

    public void startWithConfig(Config config, File baseDir, File distFile) {
        String string;
        String projectName = config.getString("project-name");
        String userHome = System.getProperty("user.home");
        if (config.hasPath("ssh-identity-password")) {
            string = config.getString("ssh-identity-password");
        } else {
            Console c = System.console();
            if (c != null) {
                string = new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(c.readPassword("Type ssh identity password: ", new Object[0]))).mkString("").trim();
            } else {
                Predef$.MODULE$.print((Object)"Type ssh identity password: ");
                string = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
        }
        String password = string;
        Map serversConf = ((TraversableOnce)((SetLike)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(config.getObject("servers").entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Map.Entry entry = x0$2;
            String shardName = (String)entry.getKey();
            Config conf = config.getConfig(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"servers.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shardName})));
            Config commandsConf = conf.getConfig("commands");
            DeployOpts.Commands commands = new DeployOpts.Commands(commandsConf.getString("start"), commandsConf.getString("stop"), (Option<String>)DeployTask$.getString$1(commandsConf, "restart"));
            DeployOpts.ServerConf sConf = new DeployOpts.ServerConf(conf.getString("host"), commands, (Option<String>)DeployTask$.getString$1(conf, "user"), (String)DeployTask$.getString$1(conf, "path").getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"~/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{projectName, projectName}))), (Option<String>)DeployTask$.getString$1(conf, "on_complete_script"));
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)shardName), (Object)sConf);
            return tuple2;
        }, Set$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._1(), (Ordering)Ordering.String$.MODULE$)).toMap(Predef$.MODULE$.$conforms());
        Map sharedDirs = ((TraversableOnce)((SetLike)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(config.getObject("shared").entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Map.Entry entry = x0$3;
            Config conf = config.getConfig(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"shared.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entry.getKey()})));
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry.getKey()), (Object)new DeployOpts.SharedDir(conf.getString("directory"), conf.getString("path")));
            return tuple2;
        }, Set$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._1(), (Ordering)Ordering.String$.MODULE$)).toMap(Predef$.MODULE$.$conforms());
        DeployOpts opts = new DeployOpts(new DeployOpts.Paths(baseDir.getAbsolutePath(), distFile.getAbsolutePath(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"~/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{projectName, projectName})), userHome), (Map<String, DeployOpts.ServerConf>)serversConf, projectName, password, (Map<String, DeployOpts.SharedDir>)sharedDirs);
        DeployHandler deployHandler = new DeployHandler(opts);
        deployHandler.start();
    }

    public void log(String color, Object msg) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> color + msg.toString() + "\u001b[0m");
    }

    public static final /* synthetic */ boolean $anonfun$start$3(File x$1) {
        return !x$1.exists();
    }

    public static final /* synthetic */ boolean $anonfun$start$5(File x$2) {
        return !x$2.exists();
    }

    private static final Option getString$1(Config c, String key) {
        return c.hasPath(key) ? new Some((Object)c.getString(key)) : None$.MODULE$;
    }

    private DeployTask$() {
        MODULE$ = this;
    }
}

