/*
 * Decompiled with CFR 0.152.
 */
package tasks;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.OpenSSHConfig;
import fr.janalyse.ssh.SSH;
import fr.janalyse.ssh.SSH$;
import fr.janalyse.ssh.SSHCommand$;
import fr.janalyse.ssh.SSHIdentity;
import fr.janalyse.ssh.SSHOptions;
import fr.janalyse.ssh.SSHOptions$;
import fr.janalyse.ssh.SSHPassword;
import fr.janalyse.ssh.SSHScp;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import tasks.DeployOpts;
import tasks.DeployTask;
import tasks.DeployTask$;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001\u0015\u0011Q\u0002R3qY>L\b*\u00198eY\u0016\u0014(\"A\u0002\u0002\u000bQ\f7o[:\u0004\u0001M\u0011\u0001A\u0002\t\u0003\u000f)i\u0011\u0001\u0003\u0006\u0002\u0013\u0005)1oY1mC&\u00111\u0002\u0003\u0002\u0007\u0003:L(+\u001a4\t\u00115\u0001!\u0011!Q\u0001\n9\tAa\u001c9ugB\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u000b\t\u0016\u0004Hn\\=PaR\u001c\b\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u0016-A\u0011q\u0002\u0001\u0005\u0006\u001bI\u0001\rA\u0004\u0005\b1\u0001\u0011\r\u0011\"\u0001\u001a\u0003%\u00198\u000f[\"p]\u001aLw-F\u0001\u001b!\tY\"%D\u0001\u001d\u0015\tib$\u0001\u0003kg\u000eD'BA\u0010!\u0003\u0019Q7M]1gi*\t\u0011%A\u0002d_6L!a\t\u000f\u0003\u001b=\u0003XM\\*T\u0011\u000e{gNZ5h\u0011\u0019)\u0003\u0001)A\u00055\u0005Q1o\u001d5D_:4\u0017n\u001a\u0011\t\u000f\u001d\u0002!\u0019!C\u0001Q\u0005Iam\u001c:nCR$XM]\u000b\u0002SA\u0011!&M\u0007\u0002W)\u0011A&L\u0001\u0007M>\u0014X.\u0019;\u000b\u00059z\u0013\u0001\u0002;j[\u0016T\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023W\t\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:\t\rQ\u0002\u0001\u0015!\u0003*\u0003)1wN]7biR,'\u000f\t\u0005\tm\u0001A)\u0019!C\u0001o\u0005q1/\u001a:wKJ\u001cuN\u001c;fqR\u001cX#\u0001\u001d\u0011\u0007er\u0004)D\u0001;\u0015\tYD(A\u0005j[6,H/\u00192mK*\u0011Q\bC\u0001\u000bG>dG.Z2uS>t\u0017BA ;\u0005!IE/\u001a:bE2,\u0007CA!E\u001d\ty!)\u0003\u0002D\u0005\u0005QA)\u001a9m_f$\u0016m]6\n\u0005\u00153%!D*feZ,'oQ8oi\u0016DHO\u0003\u0002D\u0005!A\u0001\n\u0001EC\u0002\u0013\u0005\u0011*\u0001\bdkJ\u0014XM\u001c;SK2,\u0017m]3\u0016\u0003)\u0003\"a\u0013(\u000e\u00031S!!T\u0018\u0002\t1\fgnZ\u0005\u0003\u001f2\u0013aa\u0015;sS:<\u0007\"B)\u0001\t\u0003\u0011\u0016a\u0003:fY\u0016\f7/\u001a)bi\"$\"AS*\t\u000bQ\u0003\u00069\u0001!\u0002\u0003MDQA\u0016\u0001\u0005\u0002]\u000bq\u0001^7q!\u0006$\b\u000e\u0006\u0002K1\")A+\u0016a\u0002\u0001\")!\f\u0001C\u00017\u0006Y1-\u001e:sK:$\b+\u0019;i)\tQE\fC\u0003U3\u0002\u000f\u0001\tC\u0003_\u0001\u0011\u0005q,A\u0007{SB\u0014V-\\8uKB\u000bG\u000f\u001b\u000b\u0003\u0015\u0002DQ\u0001V/A\u0004\u0001CQA\u0019\u0001\u0005\u0002\r\fQa\u001d;beR$\u0012\u0001\u001a\t\u0003\u000f\u0015L!A\u001a\u0005\u0003\tUs\u0017\u000e\u001e\u0005\u0006Q\u0002!\t![\u0001\u001bGJ,\u0017\r^3D_:tWm\u0019;j_:\fe\u000eZ\"p]R,\u0007\u0010\u001e\u000b\u0004\u0001*4\b\"B6h\u0001\u0004a\u0017AC:feZ,'OT1nKB\u0011Q\u000e\u001e\b\u0003]J\u0004\"a\u001c\u0005\u000e\u0003AT!!\u001d\u0003\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\b\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fVT!a\u001d\u0005\t\u000b]<\u0007\u0019\u0001=\u0002\rM,'O^3s!\tIHP\u0004\u0002\u0010u&\u00111PA\u0001\u000b\t\u0016\u0004Hn\\=PaR\u001c\u0018BA?\u007f\u0005)\u0019VM\u001d<fe\u000e{gN\u001a\u0006\u0003w\nAq!!\u0001\u0001\t\u0003\t\u0019!\u0001\u0007eKBdw._*feZ,'\u000f\u0006\u0002\u0002\u0006Q\u0019A-a\u0002\t\r\u0005%q\u0010q\u0001A\u00035\u0019XM\u001d<fe\u000e{g\u000e^3yi\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011AF2sK\u0006$X\r\u0015:pU\u0016\u001cGo\u0015;sk\u000e$XO]3\u0015\u0005\u0005EAc\u00013\u0002\u0014!1A+a\u0003A\u0004\u0001Cq!a\u0006\u0001\t\u0003\tI\"A\u0007va2|\u0017\r\u001a*fY\u0016\f7/\u001a\u000b\u0003\u00037!2\u0001\\A\u000f\u0011\u0019!\u0016Q\u0003a\u0002\u0001\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012!\u0004:fgR\f'\u000f^*feZ,'\u000f\u0006\u0002\u0002&Q\u0019A.a\n\t\rQ\u000by\u0002q\u0001A\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\t!b\u001c8D_6\u0004H.\u001a;f)\t\ty\u0003F\u0002e\u0003cAa\u0001VA\u0015\u0001\b\u0001\u0005bBA\u001b\u0001\u0011%\u0011qG\u0001\fO\u0016$()Y:f\u001d\u0006lW\rF\u0002m\u0003sAq!a\u000f\u00024\u0001\u0007A.\u0001\u0005gS2,\u0007/\u0019;i\u0001")
public class DeployHandler {
    private Iterable<DeployTask.ServerContext> serverContexts;
    private String currentRelease;
    private final DeployOpts opts;
    private final OpenSSHConfig sshConfig;
    private final DateTimeFormatter formatter;
    private volatile byte bitmap$0;

    public OpenSSHConfig sshConfig() {
        return this.sshConfig;
    }

    public DateTimeFormatter formatter() {
        return this.formatter;
    }

    private Iterable<DeployTask.ServerContext> serverContexts$lzycompute() {
        DeployHandler deployHandler = this;
        synchronized (deployHandler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serverContexts = (Iterable)this.opts.servers().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String name = (String)tuple2._1();
                    DeployOpts.ServerConf conf = (DeployOpts.ServerConf)tuple2._2();
                    DeployTask.ServerContext serverContext = this.createConnectionAndContext(name, conf);
                    return serverContext;
                }, Iterable$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serverContexts;
    }

    public Iterable<DeployTask.ServerContext> serverContexts() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.serverContexts$lzycompute() : this.serverContexts;
    }

    private String currentRelease$lzycompute() {
        DeployHandler deployHandler = this;
        synchronized (deployHandler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.currentRelease = LocalDateTime.now().format(this.formatter());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.currentRelease;
    }

    public String currentRelease() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.currentRelease$lzycompute() : this.currentRelease;
    }

    public String releasePath(DeployTask.ServerContext s) {
        return s.conf().deployPath() + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/releases/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentRelease()}));
    }

    public String tmpPath(DeployTask.ServerContext s) {
        return s.conf().deployPath() + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/tmp"})).s((Seq)Nil$.MODULE$);
    }

    public String currentPath(DeployTask.ServerContext s) {
        return s.conf().deployPath() + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/current"})).s((Seq)Nil$.MODULE$);
    }

    public String zipRemotePath(DeployTask.ServerContext s) {
        return s.conf().deployPath() + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/tmp/", ".zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentRelease()}));
    }

    public void start() {
        try {
            this.serverContexts().foreach((Function1 & Serializable & scala.Serializable)context -> {
                DeployHandler.$anonfun$start$9(this, context);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.serverContexts().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.close();
                return BoxedUnit.UNIT;
            });
        }
    }

    public DeployTask.ServerContext createConnectionAndContext(String serverName, DeployOpts.ServerConf server) {
        ConfigRepository.Config hostConfig = this.sshConfig().getConfig(server.host());
        String host = (String)Option$.MODULE$.apply((Object)hostConfig.getHostname()).getOrElse((Function0 & Serializable & scala.Serializable)() -> server.host());
        String identityFile = ((String)Option$.MODULE$.apply((Object)hostConfig.getValue("IdentityFile")).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"~/.ssh/id_rsa"})).s((Seq)Nil$.MODULE$))).replace("~", this.opts.paths().userHome());
        String user = (String)server.username().getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)Option$.MODULE$.apply((Object)hostConfig.getUser()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.opts.projectName()));
        int port = hostConfig.getPort() > 0 ? hostConfig.getPort() : 22;
        SSHPassword password = new SSHPassword((Option)new Some((Object)this.opts.identityPassword()));
        String string = host;
        String string2 = serverName;
        String serverTitle = host + (!(string != null ? !string.equals(string2) : string2 != null) ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serverName})));
        DeployTask$.MODULE$.log("\u001b[33m", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start deploying to host ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serverTitle})));
        String x$6 = host;
        String x$7 = user;
        List x$8 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SSHIdentity[]{new SSHIdentity(identityFile, password)}));
        int x$9 = port;
        SSHPassword x$10 = SSHOptions$.MODULE$.apply$default$3();
        SSHPassword x$11 = SSHOptions$.MODULE$.apply$default$4();
        Option x$12 = SSHOptions$.MODULE$.apply$default$5();
        Option x$13 = SSHOptions$.MODULE$.apply$default$7();
        long x$14 = SSHOptions$.MODULE$.apply$default$8();
        long x$15 = SSHOptions$.MODULE$.apply$default$9();
        int x$16 = SSHOptions$.MODULE$.apply$default$10();
        int x$17 = SSHOptions$.MODULE$.apply$default$11();
        String x$18 = SSHOptions$.MODULE$.apply$default$13();
        boolean x$19 = SSHOptions$.MODULE$.apply$default$14();
        Option x$20 = SSHOptions$.MODULE$.apply$default$15();
        boolean x$21 = SSHOptions$.MODULE$.apply$default$16();
        String[] x$22 = SSHOptions$.MODULE$.apply$default$17();
        Option x$23 = SSHOptions$.MODULE$.apply$default$18();
        Map x$24 = SSHOptions$.MODULE$.apply$default$19();
        Option x$25 = SSHOptions$.MODULE$.apply$default$20();
        Option x$26 = SSHOptions$.MODULE$.apply$default$21();
        SSH ssh = SSH$.MODULE$.apply(new SSHOptions(x$6, x$7, x$10, x$11, x$12, x$9, x$13, x$14, x$15, x$16, x$17, x$8, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26));
        DeployTask$.MODULE$.log("\u001b[33m", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connected to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serverTitle})));
        String remoteHomedir = ssh.execOnce(SSHCommand$.MODULE$.stringToCommand("echo $HOME"));
        String x$27 = server.deployPath().replace("~", remoteHomedir);
        String x$28 = server.copy$default$1();
        DeployOpts.Commands x$29 = server.copy$default$2();
        Option<String> x$30 = server.copy$default$3();
        Option<String> x$31 = server.copy$default$5();
        return new DeployTask.ServerContext(serverTitle, remoteHomedir, server.copy(x$28, x$29, x$30, x$27, x$31), ssh);
    }

    public void deployServer(DeployTask.ServerContext serverContext) {
        this.createProjectStructure(serverContext);
        this.uploadRelease(serverContext);
        this.restartServer(serverContext);
        this.onComplete(serverContext);
    }

    public void createProjectStructure(DeployTask.ServerContext s) {
        s.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mkdir -p ", "/releases"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.conf().deployPath()})));
        s.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mkdir -p ", "/tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.conf().deployPath()})));
        s.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mkdir -p ", "/shared"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.conf().deployPath()})));
    }

    public String uploadRelease(DeployTask.ServerContext s) {
        String string;
        String rootFolderName = this.getBaseName(this.opts.paths().distFile());
        try (SSHScp scp = new SSHScp(s.ssh());){
            s.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rm -rf ", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmpPath(s), rootFolderName})));
            DeployTask$.MODULE$.log("\u001b[33m", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Upload build to ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.title()})));
            scp.send(this.opts.paths().distFile(), this.zipRemotePath(s));
            DeployTask$.MODULE$.log("\u001b[33m", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Upload completed"})).s((Seq)Nil$.MODULE$));
            s.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unzip -q ", " -d ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zipRemotePath(s), this.tmpPath(s)})));
            s.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mv ", "/", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmpPath(s), rootFolderName, this.releasePath(s)})));
            this.opts.sharedDirs().foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DeployOpts.SharedDir dir = (DeployOpts.SharedDir)tuple2._2();
                String string = s.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ln -s ", " ", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir.path(), this.releasePath(s), dir.directory()})));
                return string;
            });
            s.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rm ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zipRemotePath(s)})));
            s.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rm ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentPath(s)})));
            string = s.exec(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ln -s ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.releasePath(s), this.currentPath(s)})));
        }
        return string;
    }

    public String restartServer(DeployTask.ServerContext s) {
        String string;
        Option<String> option = s.conf().commands().restart();
        if (option instanceof Some) {
            Some some = (Some)option;
            String restart = (String)some.value();
            string = s.exec(restart);
        } else if (None$.MODULE$.equals(option)) {
            s.exec(s.conf().commands().stop());
            string = s.exec(s.conf().commands().start());
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public void onComplete(DeployTask.ServerContext s) {
        s.conf().onCompleteScript().foreach((Function1 & Serializable & scala.Serializable)script -> s.exec(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |export RELEASE_PATH=", "\n           |export RELEASE=", "\n           |", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.releasePath(s), this.currentRelease(), script})))).stripMargin()));
    }

    private String getBaseName(String filepath) {
        String filename = new File(filepath).getName();
        int index = filename.lastIndexOf(".");
        return index == -1 ? filename : filename.substring(0, index);
    }

    public static final /* synthetic */ void $anonfun$start$9(DeployHandler $this, DeployTask.ServerContext context) {
        long startAt = System.currentTimeMillis();
        DeployTask$.MODULE$.log("\u001b[46m", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start deploying to host ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context.title()})));
        $this.deployServer(context);
        String durationSec = Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)((double)(System.currentTimeMillis() - startAt) / 1000.0))), "%.1f");
        DeployTask$.MODULE$.log("\u001b[46m", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server ", " deployed in ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context.title(), durationSec})));
    }

    public DeployHandler(DeployOpts opts) {
        this.opts = opts;
        this.sshConfig = OpenSSHConfig.parseFile((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.ssh/config"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opts.paths().userHome()})));
        this.formatter = DateTimeFormatter.ofPattern("YYYYMMddHHmmss");
    }
}

