/*
 * Decompiled with CFR 0.152.
 */
package com.github.slavaz.maven.plugin.postgresql.embedded.psql.util;

import com.github.slavaz.maven.plugin.postgresql.embedded.psql.IPgInstanceProcessData;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

class CharsetParameterList {
    private static final String NO_PARAMETERS = "no";
    private final String charsetName;
    private final String localeName;

    CharsetParameterList(IPgInstanceProcessData pgInstanceProcess) {
        this.charsetName = this.calculateCharset(pgInstanceProcess);
        this.localeName = this.calculateLocale(pgInstanceProcess);
    }

    Collection<String> get() {
        if (NO_PARAMETERS.equals(this.localeName) || NO_PARAMETERS.equals(this.charsetName)) {
            return Collections.emptyList();
        }
        String lc = this.localeName + "." + this.charsetName;
        return Arrays.asList("-E", this.charsetName, "--locale=" + lc, "--lc-collate=" + lc, "--lc-ctype=" + lc);
    }

    private String calculateCharset(IPgInstanceProcessData iPgInstanceProcessData) {
        if (StringUtils.isEmpty((CharSequence)iPgInstanceProcessData.getPgCharset())) {
            return Charset.defaultCharset().name();
        }
        return iPgInstanceProcessData.getPgCharset();
    }

    private String calculateLocale(IPgInstanceProcessData iPgInstanceProcessData) {
        if (StringUtils.isEmpty((CharSequence)iPgInstanceProcessData.getPgLocale())) {
            return Locale.getDefault().toString();
        }
        return iPgInstanceProcessData.getPgLocale();
    }
}

