package dswork.springboot;

import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import dswork.config.WebRequestMappingHandlerMapping;

/**
 * 仅实现自定义RequestMappingHandlerMapping
 */
@Configuration
public class MyWebMvcRegistrations implements WebMvcRegistrations
{
	static String SUFFIX = "";
	@Override
	public RequestMappingHandlerMapping getRequestMappingHandlerMapping()
	{
		if(SUFFIX.length() > 0)
		{
			WebRequestMappingHandlerMapping.SUFFIX = SUFFIX;
			return new WebRequestMappingHandlerMapping();
		}
		else
		{
			return new RequestMappingHandlerMapping();
		}
	}
}
