package dswork.springboot;

import java.io.File;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.type.AnnotationMetadata;

import dswork.config.MyLog4jUtil;
import dswork.config.MyLogbackListener;
import dswork.config.MyRootRegistrar;
import dswork.config.WebMvcScannerController;
import dswork.core.util.EnvironmentUtil;

@Configuration
@AutoConfigureBefore({MyAutoConfiguration.class, MyRootRegistrar.class, WebMvcScannerController.class})
@Import({MySpringInitializer.class})
public class MySpringInitializer implements ImportBeanDefinitionRegistrar
{
	private final static String JarPath = EnvironmentUtil.getApplicationPath();
	private final static boolean isboot = JarPath != null;
	private static String[] servletMappings = new String[]{"/"};// springboot默认改为/
	private static boolean initMappings = false;
	public static String[] getServletMappings()
	{
		return servletMappings;
	}

	public static void setServletMappings(String[] servletMappings)
	{
		MySpringInitializer.servletMappings = servletMappings;
		initMappings = true;
	}
	private static boolean checkConfigFileExists(String path)
	{
		if(isboot)// 优先判断外置文件
		{
			if(new java.io.File(JarPath + path).isFile())
			{
				// System.out.println("check File= " + JarPath + path);
				return true;
			}
		}
		if(new ClassPathResource(path).exists())
		{
			// System.out.println("check ClassPathResource= " + JarPath + path);
			return true;
		}
		return false;
	}
	protected final Logger log = LoggerFactory.getLogger("dswork.config");
	public MySpringInitializer()
	{
		if(log.isDebugEnabled())
		{
			log.debug(MySpringInitializer.class.getName());
		}
	}

	@Override
	public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry)
	{
		String active = EnvironmentUtil.getToString("dswork.active", "");
		String logbackPath = "/config/logback.xml";
		String log4j2Path = "/config/log4j2.xml";
		String dsworkSSOPath = "/config/sso.properties";
		if(active.length() > 0)
		{
			String config = "/config/" + active + "/config.properties";
			if(checkConfigFileExists(config))
			{
				EnvironmentUtil.setSystemProperties(config);
			}
			String logback = "/config/" + active + "/logback.xml";
			if(checkConfigFileExists(logback))
			{
				logbackPath = logback;
			}
			String log4j2 = "/config/" + active + "/log4j2.xml";
			if(checkConfigFileExists(log4j2))
			{
				log4j2Path = log4j2;
			}
			String dsworkSSO = "/config/" + active + "/sso.properties";
			if(checkConfigFileExists(dsworkSSO))
			{
				dsworkSSOPath = dsworkSSO;
			}
		}
		System.setProperty("dsworkSSOConfiguration", dsworkSSOPath);
		try
		{
			String realPath = null;
			String logsDir = null;
			if(isboot)
			{
				realPath = JarPath;
				logsDir = new File(realPath + "/../logs").getCanonicalPath().replaceAll("\\\\", "/");
			}
			else
			{
				realPath = System.getProperty("user.dir").replaceAll("\\\\", "/");
				logsDir = new File(realPath + "/../../logs").getCanonicalPath().replaceAll("\\\\", "/");
			}
			String contextPath = realPath.substring(realPath.lastIndexOf("/"));
			System.setProperty("rootDir", realPath);
			System.setProperty("logsDir", logsDir);
			System.setProperty("contextPath", contextPath);
		}
		catch(Exception e)
		{
		}
		boolean isLoadingLog = false;// 优先加载logback
		try
		{
			if(checkConfigFileExists(logbackPath))
			{
				Class.forName("ch.qos.logback.core.Context");
				java.io.InputStream stream = null;
				if(isboot)
				{
					stream = new java.io.FileInputStream(JarPath + logbackPath);
				}
				else
				{
					ClassPathResource resource = new ClassPathResource(logbackPath);
					if(resource.exists())
					{
						stream = resource.getInputStream();
					}
				}
				if(stream != null)
				{
					MyLogbackListener.resetLogback(stream, null);
					isLoadingLog = true;
				}
			}
		}
		catch(Throwable c)
		{
		}
		try
		{
			if(!isLoadingLog && checkConfigFileExists(log4j2Path))
			{
				Class.forName("org.apache.logging.log4j.core.config.ConfigurationFactory");
				java.io.InputStream stream = null;
				if(isboot)
				{
					stream = new java.io.FileInputStream(JarPath + log4j2Path);
				}
				else
				{
					ClassPathResource resource = new ClassPathResource(log4j2Path);
					if(resource.exists())
					{
						stream = resource.getInputStream();
					}
				}
				if(stream != null)
				{
					MyLog4jUtil.resetLog(stream);
				}
			}
		}
		catch(ClassNotFoundException e)
		{
		}
		catch(Throwable c)
		{
		}
		try
		{
			String mappings = EnvironmentUtil.getToString("mvc.path", "").replaceAll(" ", "");
			String suffix = EnvironmentUtil.getToString("mvc.path.suffix", null);
			if(mappings.length() > 0)
			{
				if(log.isWarnEnabled() && initMappings)
				{
					log.warn("Repeat settings dswork.config.MyWebInitializer.setServletMappings()! Use mvc.path");
				}
				setServletMappings(mappings.split(","));
			}
			if(servletMappings.length == 1)
			{
				if(suffix != null)
				{
					if(suffix.startsWith("*.") && suffix.length() > 3)// 匹配后缀模式*.xx，其中后缀长度至少为2
					{
						MyWebMvcRegistrations.SUFFIX = suffix.substring(1);
					}
					else if(suffix.startsWith(".") && suffix.length() > 2)
					{
						MyWebMvcRegistrations.SUFFIX = suffix;
					}
				}
				else
				{
					if(servletMappings[0].startsWith("*.") && servletMappings[0].length() > 3)// 匹配后缀模式*.xx，其中后缀长度至少为2
					{
						if(log.isWarnEnabled())
						{
							log.warn("No mvc.path.suffix found");
						}
						MyWebMvcRegistrations.SUFFIX = servletMappings[0].substring(1);
					}
				}
			}
		}
		catch(Exception e)
		{
		}
		if(log.isDebugEnabled())
		{
			log.debug("dswork.springboot.MySpringInitializer.registerBeanDefinitions");
		}
	}
}
