package dswork.springboot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.util.IntrospectorCleanupListener;

@Configuration
@AutoConfigureBefore({DispatcherServletAutoConfiguration.class})
public class MyAutoConfiguration
{
	protected final Logger log = LoggerFactory.getLogger("dswork.config");
	
	@Bean
	public ServletRegistrationBean<DispatcherServlet> dispatcherServletBean(DispatcherServlet dispatcherServlet)
	{
		ServletRegistrationBean<DispatcherServlet> servletServletRegistrationBean = new ServletRegistrationBean<DispatcherServlet>(dispatcherServlet);
		servletServletRegistrationBean.addUrlMappings(MySpringInitializer.getServletMappings());

		if(log.isDebugEnabled())
		{
			StringBuffer sb = new StringBuffer();
			sb.append("dswork.springboot.MyAutoConfiguration.getServletMappings():");
			String[] urlArray = MySpringInitializer.getServletMappings();
			for(String s : urlArray)
			{
				sb.append(" ").append(s);
			}
			log.debug(sb.toString());
		}
		
		return servletServletRegistrationBean;
	}
	
	@Bean
	public ServletListenerRegistrationBean<IntrospectorCleanupListener> introspectorCleanupListenerBean()
	{
		ServletListenerRegistrationBean<IntrospectorCleanupListener> listenerRegistBean = new ServletListenerRegistrationBean<IntrospectorCleanupListener>();
		listenerRegistBean.setListener(new IntrospectorCleanupListener());
		return listenerRegistBean;
	}

	@Bean
	public FilterRegistrationBean<CharacterEncodingFilter> encodingFilterBean()
	{
		FilterRegistrationBean<CharacterEncodingFilter> registration = new FilterRegistrationBean<CharacterEncodingFilter>();
		registration.setFilter(new CharacterEncodingFilter());
		registration.setName("encodingFilter");
		registration.addInitParameter("encoding", "UTF-8");
		registration.addInitParameter("forceEncoding", "true");
		registration.addUrlPatterns("/*");
		registration.setOrder(1); // 值越小，Filter越靠前。
		return registration;
	}

	@Bean
	public ApplicationContextRegister applicationContextRegister()
	{
		return new ApplicationContextRegister();
	}
}
