package dswork.springboot;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.util.IntrospectorCleanupListener;

@Configuration
@AutoConfigureBefore({DispatcherServletAutoConfiguration.class})
public class DsworkSpringBootWeb
{
	private static String[] servletMappings = new String[]{"*.htm"};
	
	public static void setServletMappings(String[] servletMappings)
	{
		DsworkSpringBootWeb.servletMappings = servletMappings;
	}
	
	@Bean
	public ServletRegistrationBean<DispatcherServlet> dispatcherServletBean(DispatcherServlet dispatcherServlet)
	{
		ServletRegistrationBean<DispatcherServlet> servletServletRegistrationBean = new ServletRegistrationBean<DispatcherServlet>(dispatcherServlet);
		servletServletRegistrationBean.addUrlMappings(servletMappings);
		return servletServletRegistrationBean;
	}

	@Bean
	public ServletListenerRegistrationBean<IntrospectorCleanupListener> introspectorCleanupListenerBean()
	{
		ServletListenerRegistrationBean<IntrospectorCleanupListener> listenerRegistBean = new ServletListenerRegistrationBean<IntrospectorCleanupListener>();
		listenerRegistBean.setListener(new IntrospectorCleanupListener());
		return listenerRegistBean;
	}

	@Bean
	public FilterRegistrationBean<CharacterEncodingFilter> encodingFilterBean()
	{
		FilterRegistrationBean<CharacterEncodingFilter> registration = new FilterRegistrationBean<CharacterEncodingFilter>();
		registration.setFilter(new CharacterEncodingFilter());
		registration.setName("encodingFilter");
		registration.addInitParameter("encoding", "UTF-8");
		registration.addInitParameter("forceEncoding", "true");
		registration.addUrlPatterns("/*");
		registration.setOrder(1); // 值越小，Filter越靠前。
		return registration;
	}

	@Bean
	public ApplicationContextRegister applicationContextRegister()
	{
		return new ApplicationContextRegister();
	}
}
