package dswork.springboot;

import dswork.config.RootConfigBean;
import dswork.config.WebConfigBean;
import dswork.core.util.EnvironmentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.type.AnnotationMetadata;

import java.io.File;

@Configuration
@AutoConfigureBefore({WebConfigBean.class, RootConfigBean.class})
@Import({DsworkSpringBootConfig.class})
public class DsworkSpringBootConfig implements ImportBeanDefinitionRegistrar
{
	protected final Logger log = LoggerFactory.getLogger("dswork.config");

	public DsworkSpringBootConfig()
	{
		if(log.isDebugEnabled())
		{
			log.debug("dswork.springboot.DsworkSpringBootConfig()");
		}
	}

	@Override
	public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry)
	{
		String active = EnvironmentUtil.getToString("dswork.active", "");
		String log4j2Path = "/config/log4j2.xml";
		String dsworkSSOPath = "/config/sso.properties";
		if(active.length() > 0)
		{
			String config = "/config/" + active + "/config.properties";
			if(new ClassPathResource(config).exists())
			{
				System.out.println(new ClassPathResource(config).exists());
				EnvironmentUtil.setSystemProperties(config);
			}
			String log4j2 = "/config/" + active + "/log4j2.xml";
			if(new ClassPathResource(log4j2).exists())
			{
				log4j2Path = log4j2;
			}
			String dsworkSSO = "/config/" + active + "/sso.properties";
			if(new ClassPathResource(dsworkSSO).exists())
			{
				dsworkSSOPath = dsworkSSO;
			}
		}
		System.setProperty("dsworkSSOConfiguration", dsworkSSOPath);
		try
		{
			String realPath = System.getProperty("user.dir").replaceAll("\\\\", "/");
			String contextPath = realPath.substring(realPath.lastIndexOf("/"));
			String logsDir = new File(realPath + "/../../logs").getCanonicalPath().replaceAll("\\\\", "/");
			System.setProperty("rootDir", realPath);
			System.setProperty("logsDir", logsDir);
			System.setProperty("contextPath", contextPath);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		try
		{
			ClassPathResource resource = new ClassPathResource(log4j2Path);
			if(resource.exists())
			{
				// 创建XML配置解析工厂
				org.apache.logging.log4j.core.config.ConfigurationFactory configFactory = org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory.getInstance();
				// 设置配置工厂为XML方式
				org.apache.logging.log4j.core.config.ConfigurationFactory.setConfigurationFactory(configFactory);
				// 转换配置流为配置源
				org.apache.logging.log4j.core.config.ConfigurationSource configurationSource = new org.apache.logging.log4j.core.config.ConfigurationSource(resource.getInputStream());
				// 获取日志环境
				org.apache.logging.log4j.core.LoggerContext ctx = org.apache.logging.log4j.core.LoggerContext.getContext(false);
				// 生成新的配置
				org.apache.logging.log4j.core.config.Configuration configuration = configFactory.getConfiguration(ctx, configurationSource);
				// 使用新配置重新配置环境
				ctx.reconfigure(configuration);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		if(log.isDebugEnabled())
		{
			log.debug("dswork.springboot.DsworkSpringBootConfig.registerBeanDefinitions()");
		}
	}
}
