package com.github.shoothzj.sdk.sb.controller;

import com.github.shoothzj.sdk.sb.api.IHealthCheck;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author hezhangjian
 */
@Slf4j
@RestController
public class HeartBeatController {

    @Autowired(required = false)
    private IHealthCheck iHealthCheck;

    @GetMapping(path = "/readiness", consumes = MediaType.ALL_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<Void> readiness() {
        if (iHealthCheck == null) {
            return new ResponseEntity<>(HttpStatus.OK);
        }
        return iHealthCheck.readiness();
    }

    @GetMapping(path = "/liveness", consumes = MediaType.ALL_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<Void> liveness() {
        if (iHealthCheck == null) {
            return new ResponseEntity<>(HttpStatus.OK);
        }
        return iHealthCheck.liveness();
    }

}
