package com.github.shoothzj.sdk.sb.controller;

import com.github.shoothzj.sdk.config.api.BaseConfig;
import com.github.shoothzj.sdk.sb.config.SbConfigService;
import com.github.shoothzj.sdk.sb.module.ConfigValueAddReq;
import com.github.shoothzj.sdk.sb.module.ConfigValueModReq;
import com.github.shoothzj.sdk.sb.module.ConfigValueQueryResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author hezhangjian
 */
@Slf4j
@RestController
public class ConfigController {

    @Autowired
    private SbConfigService sbConfigService;

    @PostMapping(path = "/configName/{configName}")
    public ResponseEntity<Void> addConfigVal(@PathVariable(value = "configName") String configName,
                                             @RequestBody ConfigValueAddReq configValueAddReq) {
        sbConfigService.addConfig(configName, configValueAddReq.getContent());
        return new ResponseEntity<>(HttpStatus.CREATED);
    }

    /**
     * @param configName
     * @param configValueModReq
     * @return
     */
    @PutMapping(path = "/configName/{configName}")
    public ResponseEntity<Void> modConfigVal(@PathVariable(value = "configName") String configName,
                                             @RequestBody ConfigValueModReq configValueModReq) {
        sbConfigService.modConfig(configName, configValueModReq.getConfigId(), configValueModReq.getContent());
        return new ResponseEntity<>(HttpStatus.OK);
    }

    /**
     * @param configName
     * @param configId
     * @return
     */
    @GetMapping(path = "/configName/{configName}/configId/{configId}")
    public ResponseEntity<ConfigValueQueryResp> getConfigVal(@PathVariable(value = "configName") String configName,
                                                             @PathVariable(value = "configId") String configId) {
        BaseConfig baseConfig = sbConfigService.getConfig(configName, configId);
        if (baseConfig == null) {
            return new ResponseEntity<>(HttpStatus.NOT_FOUND);
        }
        ConfigValueQueryResp configValueQueryResp = new ConfigValueQueryResp();
        configValueQueryResp.setContent(baseConfig.toString());
        return new ResponseEntity<>(configValueQueryResp, HttpStatus.OK);
    }

    /**
     * @param configName
     * @param configId
     * @return
     */
    @DeleteMapping(path = "/configName/{configName}/configId/{configId}")
    public ResponseEntity<Void> delConfigVal(@PathVariable(value = "configName") String configName,
                                             @PathVariable(value = "configId") String configId) {
        sbConfigService.delConfig(configName, configId);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }


}