package com.github.shoothzj.sdk.sb.config;

import com.github.shoothzj.javatool.service.JacksonService;
import com.github.shoothzj.sdk.config.api.BaseConfig;
import com.github.shoothzj.sdk.config.api.ConfigListener;
import com.github.shoothzj.sdk.config.api.IConfig;
import com.github.shoothzj.sdk.config.api.module.ConfigAddResult;
import com.github.shoothzj.sdk.config.api.module.ConfigModResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.concurrent.ConcurrentHashMap;

/**
 * @author hezhangjian
 */
@Slf4j
@Service
public class SbConfigService implements IConfig {

    private final ConcurrentHashMap<String, MemoryConfigContainer> map = new ConcurrentHashMap<>();

    private final ConcurrentHashMap<String, Class> classMap = new ConcurrentHashMap<>();

    @Override
    public <T extends BaseConfig> void register(Class<T> clazz) {
        MemoryConfigContainer<T> configContainer = new MemoryConfigContainer<T>();
        map.put(clazz.getSimpleName(), configContainer);
        classMap.put(clazz.getSimpleName(), clazz);
    }

    @Override
    public <T extends BaseConfig> void register(Class<T> clazz, ConfigListener<T> configListener) {
        MemoryConfigContainer<T> configContainer = new MemoryConfigContainer<>(configListener);
        map.put(clazz.getSimpleName(), configContainer);
        classMap.put(clazz.getSimpleName(), clazz);
    }

    @Override
    public <T extends BaseConfig> ConfigAddResult addConfig(T config) {
        String simpleName = config.getClass().getSimpleName();
        MemoryConfigContainer<T> memoryConfigContainer = map.get(simpleName);
        memoryConfigContainer.addConfig(config);
        return new ConfigAddResult();
    }

    public <T extends BaseConfig> ConfigAddResult addConfig(String configName, String configContent) {
        MemoryConfigContainer<T> memoryConfigContainer = map.get(configName);
        Class clazz = classMap.get(configName);
        T t = (T) JacksonService.toObject(configContent, clazz);
        memoryConfigContainer.addConfig(t);
        return new ConfigAddResult();
    }

    @Override
    public <T extends BaseConfig> ConfigModResult modConfig(String configId, T newConfig) {
        String simpleName = newConfig.getClass().getSimpleName();
        MemoryConfigContainer<T> memoryConfigContainer = map.get(simpleName);
        memoryConfigContainer.modConfig(configId, newConfig);
        return new ConfigModResult();
    }

    public <T extends BaseConfig> ConfigModResult modConfig(String configName, String configId, String configContent) {
        MemoryConfigContainer<T> memoryConfigContainer = map.get(configName);
        Class clazz = classMap.get(configName);
        T t = (T) JacksonService.toObject(configContent, clazz);
        memoryConfigContainer.modConfig(configId, t);
        return new ConfigModResult();
    }

    @Override
    public <T extends BaseConfig> ConfigModResult modConfig(T oldConfig, T newConfig) {
        return new ConfigModResult();
    }

    @Override
    public <T extends BaseConfig> void delConfig(Class<T> clazz, String configId) {
        String simpleName = clazz.getSimpleName();
        MemoryConfigContainer memoryConfigContainer = map.get(simpleName);
        memoryConfigContainer.delConfig(configId);
    }

    @Override
    public <T extends BaseConfig> void delConfig(T oldConfig) {
        String simpleName = oldConfig.getClass().getSimpleName();
        MemoryConfigContainer<T> memoryConfigContainer = map.get(simpleName);
        memoryConfigContainer.delConfig(oldConfig);
    }

    public <T extends BaseConfig> void delConfig(String configName, String configId) {
        MemoryConfigContainer<T> memoryConfigContainer = map.get(configName);
        memoryConfigContainer.delConfig(configId);
    }

    @Override
    public <T extends BaseConfig> T getConfig(Class<T> clazz, String configId) {
        String simpleName = clazz.getSimpleName();
        MemoryConfigContainer<T> memoryConfigContainer = map.get(simpleName);
        return memoryConfigContainer.getConfig(configId);
    }

    public <T extends BaseConfig> T getConfig(String configName, String configId) {
        MemoryConfigContainer<T> memoryConfigContainer = map.get(configName);
        return memoryConfigContainer.getConfig(configId);
    }

}