package com.github.shoothzj.sdk.sb.config;

import com.github.shoothzj.sdk.config.api.BaseConfig;
import com.github.shoothzj.sdk.config.api.ConfigListener;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author hezhangjian
 */
@Slf4j
public class MemoryConfigContainer<T extends BaseConfig> {

    private final Optional<ConfigListener<T>> configListenerOp;

    /**
     * config => T
     */
    private final Map<String, T> map = new ConcurrentHashMap<>();

    public MemoryConfigContainer() {
        this.configListenerOp = Optional.empty();
    }

    public MemoryConfigContainer(ConfigListener<T> configListener) {
        this.configListenerOp = Optional.of(configListener);
    }

    public void addConfig(T config) {
        map.put(config.getConfigId(), config);
        configListenerOp.ifPresent(configListener -> configListener.addConfig(config));
    }

    public void modConfig(String configId, T newConfig) {
        map.computeIfPresent(configId, (s, t) -> {
            configListenerOp.ifPresent(configListener -> configListener.modConfig(t, newConfig));
            return newConfig;
        });
    }

    public void modConfig(T oldConfig, T newConfig) {

    }

    public void delConfig(String configId) {
        map.computeIfPresent(configId, (s, t) -> {
            configListenerOp.ifPresent(configListener -> configListener.delConfig(t));
            return null;
        });
    }

    public void delConfig(T oldConfig) {
    }

    public T getConfig(String configId) {
        return map.get(configId);
    }

}