package com.github.shoothzj.sdk.spring.util;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class SpringContextHelper implements ApplicationContextAware {

    private static ApplicationContext context;

    private static String[] activeProfiles = null;

    private static String[] defaultProfiles = null;

    public static <T> T getBean(Class<T> beanClass) {
        return context.getBean(beanClass);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;

        activeProfiles = context.getEnvironment().getActiveProfiles();

        defaultProfiles = context.getEnvironment().getDefaultProfiles();
    }
}
