/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.sdk.net;

import com.github.shoothzj.sdk.net.InetAddressUtils;
import com.github.shoothzj.sdk.net.IpAddressMatcher;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ipv6Util {
    private static final Logger log = LoggerFactory.getLogger(Ipv6Util.class);
    private static final String[] ZERO_ARRAY = new String[]{"", "0", "00", "000", "0000"};

    public static boolean isValidIp(String ip) {
        return InetAddressUtils.isIPv6Address(ip);
    }

    public static boolean isLinkLocalAddress(String ip) {
        if (!Ipv6Util.isValidIp(ip)) {
            return false;
        }
        InetAddress inetAddress = InetAddresses.forString((String)ip);
        return inetAddress.isLinkLocalAddress();
    }

    public static Optional<Integer> getMaskLen(String mask) {
        if (!Ipv6Util.isValidIp(mask)) {
            return Optional.empty();
        }
        char[] charArray = Ipv6Util.convertToByteString(mask).toCharArray();
        boolean encounterZero = false;
        int count = 0;
        for (char ch : charArray) {
            if (ch == '0') {
                if (encounterZero) continue;
                encounterZero = true;
                continue;
            }
            if (ch == '1') {
                ++count;
                if (!encounterZero) continue;
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.of(count);
    }

    public static Optional<String> convert2Cidr(String networkBit, String mask) {
        if (!Ipv6Util.isValidIp(networkBit)) {
            return Optional.empty();
        }
        Optional<Integer> integerOp = Ipv6Util.getMaskLen(mask);
        return integerOp.map(integer -> networkBit + "/" + integer);
    }

    public static boolean isInCidr(String ip, String cidr) {
        IpAddressMatcher addressMatcher = new IpAddressMatcher(cidr);
        return addressMatcher.matches(ip);
    }

    public static String convertToByteString(String ip) {
        char[] charArray = Ipv6Util.convertToStd(ip).toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : charArray) {
            if (c == ':') continue;
            sb.append(Ipv6Util.char2Str(c));
        }
        return sb.toString();
    }

    public static String convertToStd(String ip) {
        if (!InetAddressUtils.isIPv6HexCompressedAddress(ip)) {
            return ip;
        }
        String[] split = ip.split("::");
        if (ip.startsWith("::")) {
            String[] split1 = split[1].split(":");
            return Ipv6Util.completeFullZero(8 - split1.length) + ":" + Ipv6Util.completeZero(split1);
        }
        if (ip.endsWith("::")) {
            String[] split1 = split[0].split(":");
            return Ipv6Util.completeZero(split1) + ":" + Ipv6Util.completeFullZero(8 - split1.length);
        }
        String[] split1 = split[0].split(":");
        String[] split2 = split[1].split(":");
        return Ipv6Util.completeZero(split1) + ":" + Ipv6Util.completeFullZero(8 - split1.length - split2.length) + ":" + Ipv6Util.completeZero(split2);
    }

    private static String char2Str(char ch) {
        switch (ch) {
            case '0': {
                return "0000";
            }
            case '1': {
                return "0001";
            }
            case '2': {
                return "0010";
            }
            case '3': {
                return "0011";
            }
            case '4': {
                return "0100";
            }
            case '5': {
                return "0101";
            }
            case '6': {
                return "0110";
            }
            case '7': {
                return "0111";
            }
            case '8': {
                return "1000";
            }
            case '9': {
                return "1001";
            }
            case 'a': {
                return "1010";
            }
            case 'A': {
                return "1010";
            }
            case 'b': {
                return "1011";
            }
            case 'B': {
                return "1011";
            }
            case 'c': {
                return "1100";
            }
            case 'C': {
                return "1100";
            }
            case 'd': {
                return "1101";
            }
            case 'D': {
                return "1101";
            }
            case 'e': {
                return "1110";
            }
            case 'E': {
                return "1110";
            }
            case 'f': {
                return "1111";
            }
            case 'F': {
                return "1111";
            }
        }
        return "";
    }

    private static String completeZero(String[] array) {
        return Arrays.stream(array).map(s -> ZERO_ARRAY[4 - s.length()] + s).collect(Collectors.joining(":"));
    }

    private static String completeFullZero(int len) {
        String[] array = new String[len];
        for (int i = 0; i < len; ++i) {
            array[i] = "";
        }
        return Ipv6Util.completeZero(array);
    }
}

