package com.github.shoothzj.sdk.kubectl;

import com.github.shoothzj.javatool.module.HostPort;

import java.util.List;

/**
 * @author hezhangjian
 */
public interface IKubectl {

    /**
     * 获取指定服务名statefulSet的服务名列表
     * @param serviceName 服务名,如zookeeper
     * @return Host列表,如 zookeeper-0,zookeeper-1,zookeeper-2
     */
    List<String> getStatefulHosts(String serviceName);

    /**
     * 获取指定服务名的集群内访问地址
     * @param serviceName service名称
     * @return
     */
    HostPort getServiceIpPort(String serviceName);


    /**
     *
     * @param statefulName
     * @return
     */
    int getStatefulReplicaTotal(String statefulName);

    /**
     *
     * @param deployName
     * @return
     */
    int getDeployReplicaTotal(String deployName);

}
