package com.github.shoothzj.sdk.kubectl.module;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author hezhangjian
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class KubectlPodModule {

    private PodType kind;

    private String hostIp;

    private String podIp;

    /**
     * StatefulSet状态下会有这个值
     * zookeeper-0
     * zookeeper-1
     */
    private String hostname;

    /**
     * container的名字,多个实例是一样的,比如zookeeper,es
     */
    private String containerName;

}
