/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.sdk.http;

import com.github.shoothzj.sdk.http.module.HttpPoolConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPoolManager {
    private static final Logger log = LoggerFactory.getLogger(HttpPoolManager.class);
    private static final HttpPoolManager instance = new HttpPoolManager();

    public static HttpPoolManager getInstance() {
        return instance;
    }

    public static CloseableHttpClient createHttpPool(HttpPoolConfig httpPoolConfig) {
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnPerRoute(httpPoolConfig.getMaxConnPerRoute()).setMaxConnTotal(httpPoolConfig.getMaxConnTotal()).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }
}

