package com.github.shoothzj.sdk.config.api;


import com.github.shoothzj.sdk.config.api.module.ConfigAddResult;
import com.github.shoothzj.sdk.config.api.module.ConfigModResult;

/**
 * IConfig接口，管理配置中心的api
 * @author hezhangjian
 */
public interface IConfig {

    <T extends BaseConfig> void register(Class<T> clazz);

    <T extends BaseConfig> void register(Class<T> clazz, ConfigListener<T> configListener);

    <T extends BaseConfig> ConfigAddResult addConfig(T config);

    <T extends BaseConfig> ConfigModResult modConfig(String configId, T newConfig);

    <T extends BaseConfig> ConfigModResult modConfig(T oldConfig, T newConfig);

    <T extends BaseConfig> void delConfig(Class<T> clazz, String configId);

    <T extends BaseConfig> void delConfig(T oldConfig);

    <T extends BaseConfig> T getConfig(Class<T> clazz, String configId);

}