/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.io.Resources;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlUtil {
    private static final Logger log = LoggerFactory.getLogger(YamlUtil.class);
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static String toYaml(Object o) {
        try {
            return MAPPER.writeValueAsString(o);
        }
        catch (Exception e) {
            log.error("json process error, exception is ", (Throwable)e);
            return "";
        }
    }

    public static <T> T relativePathToObject(String relativePath, Class<T> type) {
        return YamlUtil.toObject(Resources.getResource((String)relativePath), type);
    }

    public static <T> T relativePathToRefer(String relativePath, TypeReference<T> reference) {
        return YamlUtil.toRefer(Resources.getResource((String)relativePath), reference);
    }

    public static <T> List<T> relativePathToList(String relativePath, TypeReference<List<T>> typeReference) {
        return YamlUtil.toList(Resources.getResource((String)relativePath), typeReference);
    }

    public static <T> T toObject(URL yaml, Class<T> type) {
        try {
            return (T)MAPPER.readValue(yaml, type);
        }
        catch (Exception e) {
            log.error("yaml process error, exception is ", (Throwable)e);
            return null;
        }
    }

    public static <T> T toRefer(URL yaml, TypeReference<T> reference) {
        try {
            return (T)MAPPER.readValue(yaml, reference);
        }
        catch (Exception e) {
            log.error("yaml process error, exception is ", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> toList(URL yaml, TypeReference<List<T>> typeReference) {
        try {
            return (List)MAPPER.readValue(yaml, typeReference);
        }
        catch (Exception e) {
            log.error("yaml process error, exception is ", (Throwable)e);
            return null;
        }
    }

    public static <T> T toObject(String yaml, Class<T> type) {
        try {
            return (T)MAPPER.readValue(yaml, type);
        }
        catch (Exception e) {
            log.error("yaml process error, exception is ", (Throwable)e);
            return null;
        }
    }

    public static <T> T toRefer(String yaml, TypeReference<T> reference) {
        try {
            return (T)MAPPER.readValue(yaml, reference);
        }
        catch (Exception e) {
            log.error("yaml process error, exception is ", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> toList(String yaml, TypeReference<List<T>> typeReference) {
        try {
            return (List)MAPPER.readValue(yaml, typeReference);
        }
        catch (Exception e) {
            log.error("yaml process error, exception is ", (Throwable)e);
            return null;
        }
    }
}

