/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.util;

import com.github.shoothzj.javatool.util.RegexUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtil {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtil.class);

    public static boolean processExists(String processName) throws Exception {
        File procFile = new File("/proc");
        if (!procFile.isDirectory()) {
            throw new Exception("why proc dir is not directory");
        }
        File[] listFiles = procFile.listFiles();
        if (listFiles == null) {
            return false;
        }
        List procDir = Arrays.stream(listFiles).filter(f -> RegexUtil.NUMBER_PATTERN.matcher(f.getName()).matches()).collect(Collectors.toList());
        for (File file : procDir) {
            try {
                byte[] byteArray = FileUtils.readFileToByteArray((File)new File(file.getCanonicalPath() + File.separator + "cmdline"));
                byte[] bytes = new byte[byteArray.length];
                for (int i = 0; i < byteArray.length; ++i) {
                    bytes[i] = byteArray[i] != 0 ? byteArray[i] : 32;
                }
                String cmdLine = new String(bytes, StandardCharsets.UTF_8);
                if (!cmdLine.contains(processName)) continue;
                return true;
            }
            catch (IOException e) {
                log.error("read file exception ", (Throwable)e);
            }
        }
        return false;
    }
}

