/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoUtil
extends IOUtils {
    private static final Logger log = LoggerFactory.getLogger(IoUtil.class);

    public static String readFile2String(String fileName) {
        try {
            return IoUtil.read2String(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e) {
            log.error("file not found exception is ", (Throwable)e);
            return "";
        }
    }

    public static String read2String(InputStream inputStream) {
        return IoUtil.read2StringCharset(inputStream, StandardCharsets.UTF_8);
    }

    public static String read2StringCharset(InputStream inputStream, Charset charset) {
        return new String(IoUtil.read2Byte(inputStream), charset);
    }

    public static byte[] read2Byte(InputStream inputStream) {
        try {
            return IoUtil.readFully((InputStream)new BufferedInputStream(inputStream), (int)inputStream.available());
        }
        catch (IOException e) {
            log.error("Read File error, exception is ", (Throwable)e);
            return new byte[0];
        }
    }
}

