/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonService {
    private static final Logger log = LoggerFactory.getLogger(JacksonService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toJson(Object o) {
        try {
            return MAPPER.writeValueAsString(o);
        }
        catch (Exception e) {
            log.error("json process error, exception is ", (Throwable)e);
            return "";
        }
    }

    public static <T> T toObject(String json, Class<T> type) {
        try {
            return (T)MAPPER.readValue(json, type);
        }
        catch (Exception e) {
            log.error("json process error, exception is ", (Throwable)e);
            return null;
        }
    }

    public static <T> T toRefer(String json, TypeReference<T> reference) {
        try {
            return (T)MAPPER.readValue(json, reference);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> List<T> toList(String json, TypeReference<List<T>> typeReference) {
        try {
            return (List)MAPPER.readValue(json, typeReference);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JsonNode toJsonNode(String json) {
        try {
            return MAPPER.readTree(json);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ObjectNode createObjectNode() {
        return MAPPER.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return MAPPER.createArrayNode();
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
    }
}

