/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.util;

import com.github.shoothzj.javatool.util.ExceptionUtil;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertUtil {
    private static final Logger log = LoggerFactory.getLogger(X509CertUtil.class);
    private static final CertificateFactory factory;

    public static boolean isValid(X509Certificate certificate) {
        try {
            certificate.checkValidity();
            return true;
        }
        catch (CertificateExpiredException e) {
            log.error("cert expire, exception is {}", (Throwable)e);
        }
        catch (CertificateNotYetValidException e) {
            log.error("cert not yet valid {}", (Throwable)e);
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isCA(X509Certificate certificate) {
        int basicConstraints = certificate.getBasicConstraints();
        boolean[] usage = certificate.getKeyUsage();
        return basicConstraints != 1 && null != usage && usage.length > 5 && usage[5];
    }

    static {
        try {
            factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            log.error("fatal exception, cert factory init failed, {}", (Object)ExceptionUtil.getException(e));
            throw new RuntimeException();
        }
    }
}

