/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.util;

import com.github.shoothzj.javatool.util.ExceptionUtil;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static String getFilePath(String filename) {
        return Resources.getResource((String)filename).getPath();
    }

    public static String getFileType(String fileName) {
        int lastIndexOf = fileName.lastIndexOf(46);
        return fileName.substring(lastIndexOf + 1);
    }

    public static void removeRecursive(String dirPath) {
        FileUtil.removeRecursive(Paths.get(dirPath, new String[0]));
    }

    public static void removeRecursive(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
        catch (IOException e) {
            log.error("walk file error, exception is {}", (Object)ExceptionUtil.getException(e));
        }
    }

    public static void inputStream2File(InputStream inputStream, String file) {
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(file));
        }
        catch (Exception e) {
            log.error("convert to file error, exception is {}", (Object)ExceptionUtil.getException(e));
        }
    }

    public static void inputStream2File(InputStream inputStream, File file) {
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
        }
        catch (Exception e) {
            log.error("convert to file error, exception is {}", (Object)ExceptionUtil.getException(e));
        }
    }
}

