package com.github.shoothzj.javatool.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

@Slf4j
public class ShellUtil {

    public static boolean executeShellCheckRet(String cmd) {
        log.info("exec command {}", cmd);
        if (StringUtils.isEmpty(cmd)) {
            log.error("command is empty.");
            return false;
        }
        try {
            Process pid = Runtime.getRuntime().exec(cmd);
            int ret = pid.waitFor();
            if (ret == 0) {
                return true;
            } else {
                log.error("command is {}, result is {}", cmd, ret);
            }
        } catch (Exception e) {
            log.error("Execute command exception.", e);
        }
        return false;
    }

}
