package com.github.shoothzj.javatool.util;

import com.github.shoothzj.javatool.constant.EnvConstant;
import com.github.shoothzj.javatool.module.OperationSystem;
import lombok.extern.slf4j.Slf4j;

/**
 * @author hezhangjian
 */
@Slf4j
public class OSUtil {

    public static OperationSystem getOS() {
        String osName = EnvConstant.osName;
        if (osName.startsWith("Mac")) {
            return OperationSystem.MAC;
        } else if (osName.startsWith("Windows")) {
            return OperationSystem.WINDOWS;
        } else if (osName.startsWith("Linux")) {
            return OperationSystem.LINUX;
        }

        return OperationSystem.UNKNOWN;
    }

    public static String getDocumentPath() {
        OperationSystem operationSystem = getOS();
        if (operationSystem.equals(OperationSystem.MAC) || operationSystem.equals(OperationSystem.WINDOWS)) {
            return EnvConstant.userHome + "/Documents";
        } else {
            return EnvConstant.userHome + "/Documents";
        }
    }

}
